/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console;

import java.security.AccessControlException;
import javax.ws.rs.BadRequestException;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.console.SyncopeSession;
import org.apache.syncope.console.pages.ErrorPage;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.markup.html.pages.ExceptionErrorPage;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.AbstractRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncopeRequestCycleListener
extends AbstractRequestCycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeRequestCycleListener.class);

    public IRequestHandler onException(RequestCycle cycle, Exception e) {
        ErrorPage errorPage;
        LOG.error("Exception found", (Throwable)e);
        PageParameters errorParameters = new PageParameters();
        errorParameters.add("errorTitle", (Object)new StringResourceModel("alert", null, new Object[0]).getString());
        if (e instanceof UnauthorizedInstantiationException) {
            errorParameters.add("errorMessage", (Object)new StringResourceModel("unauthorizedInstantiationException", null, new Object[0]).getString());
            errorPage = new ErrorPage(errorParameters);
        } else if (e.getCause() instanceof AccessControlException) {
            errorParameters.add("errorMessage", (Object)new StringResourceModel("accessControlException", null, new Object[0]).getString());
            errorPage = new ErrorPage(errorParameters);
        } else if (e instanceof PageExpiredException || !SyncopeSession.get().isAuthenticated()) {
            errorParameters.add("errorMessage", (Object)new StringResourceModel("pageExpiredException", null, new Object[0]).getString());
            errorPage = new ErrorPage(errorParameters);
        } else if (e.getCause() instanceof BadRequestException || e.getCause() instanceof WebServiceException || e.getCause() instanceof SyncopeClientException) {
            errorParameters.add("errorMessage", (Object)new StringResourceModel("restClientException", null, new Object[0]).getString());
            errorPage = new ErrorPage(errorParameters);
        } else {
            errorPage = new ExceptionErrorPage((Throwable)e, null);
        }
        return new RenderPageRequestHandler((IPageProvider)new PageProvider((IRequestablePage)errorPage));
    }
}

