/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.syncope.common.to.NotificationTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.common.types.IntMappingType;
import org.apache.syncope.common.types.TraceLevel;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.NotificationModalPage;
import org.apache.syncope.console.pages.panels.RoleSearchPanel;
import org.apache.syncope.console.pages.panels.UserSearchPanel;
import org.apache.syncope.console.rest.LoggerRestClient;
import org.apache.syncope.console.rest.NotificationRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.EmailAddressValidator;

class NotificationModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -1975312550059578553L;
    @SpringBean
    private NotificationRestClient restClient;
    @SpringBean
    private LoggerRestClient loggerRestClient;

    public NotificationModalPage(PageReference pageRef, ModalWindow window, NotificationTO notificationTO, boolean createFlag) {
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)notificationTO));
        AjaxTextFieldPanel sender = new AjaxTextFieldPanel("sender", this.getString("sender"), (IModel)new PropertyModel((Object)notificationTO, "sender"));
        sender.addRequiredLabel();
        sender.addValidator((IValidator)EmailAddressValidator.getInstance());
        form.add(new Component[]{sender});
        AjaxTextFieldPanel subject = new AjaxTextFieldPanel("subject", this.getString("subject"), (IModel)new PropertyModel((Object)notificationTO, "subject"));
        subject.addRequiredLabel();
        form.add(new Component[]{subject});
        AjaxDropDownChoicePanel template = new AjaxDropDownChoicePanel("template", this.getString("template"), (IModel)new PropertyModel((Object)notificationTO, "template"));
        template.setChoices(this.confRestClient.getMailTemplates());
        template.addRequiredLabel();
        form.add(new Component[]{template});
        AjaxDropDownChoicePanel traceLevel = new AjaxDropDownChoicePanel("traceLevel", this.getString("traceLevel"), (IModel)new PropertyModel((Object)notificationTO, "traceLevel"));
        traceLevel.setChoices(Arrays.asList(TraceLevel.values()));
        traceLevel.addRequiredLabel();
        form.add(new Component[]{traceLevel});
        AjaxCheckBoxPanel isActive = new AjaxCheckBoxPanel("isActive", this.getString("isActive"), (IModel)new PropertyModel((Object)notificationTO, "active"));
        if (createFlag) {
            isActive.getField().setDefaultModelObject((Object)Boolean.TRUE);
        }
        form.add(new Component[]{isActive});
        WebMarkupContainer aboutContainer = new WebMarkupContainer("aboutContainer");
        aboutContainer.setOutputMarkupId(true);
        form.add(new Component[]{aboutContainer});
        AjaxCheckBoxPanel checkAbout = new AjaxCheckBoxPanel("checkAbout", "checkAbout", (IModel)new Model((Serializable)Boolean.valueOf(notificationTO.getUserAbout() == null && notificationTO.getRoleAbout() == null)));
        aboutContainer.add(new Component[]{checkAbout});
        AjaxCheckBoxPanel checkUserAbout = new AjaxCheckBoxPanel("checkUserAbout", "checkUserAbout", (IModel)new Model((Serializable)Boolean.valueOf(notificationTO.getUserAbout() != null)));
        aboutContainer.add(new Component[]{checkUserAbout});
        AjaxCheckBoxPanel checkRoleAbout = new AjaxCheckBoxPanel("checkRoleAbout", "checkRoleAbout", (IModel)new Model((Serializable)Boolean.valueOf(notificationTO.getRoleAbout() != null)));
        aboutContainer.add(new Component[]{checkRoleAbout});
        UserSearchPanel userAbout = new UserSearchPanel.Builder("userAbout").fiql(notificationTO.getUserAbout()).build();
        aboutContainer.add(new Component[]{userAbout});
        userAbout.setEnabled(((Boolean)checkUserAbout.getModelObject()).booleanValue());
        RoleSearchPanel roleAbout = new RoleSearchPanel.Builder("roleAbout").fiql(notificationTO.getRoleAbout()).build();
        aboutContainer.add(new Component[]{roleAbout});
        roleAbout.setEnabled(((Boolean)checkRoleAbout.getModelObject()).booleanValue());
        checkAbout.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        checkUserAbout.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        checkRoleAbout.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        AjaxDropDownChoicePanel recipientAttrType = new AjaxDropDownChoicePanel("recipientAttrType", new ResourceModel("recipientAttrType", "recipientAttrType").getObject(), (IModel)new PropertyModel((Object)notificationTO, "recipientAttrType"));
        recipientAttrType.setChoices(new ArrayList(IntMappingType.getAttributeTypes((AttributableType)AttributableType.USER, EnumSet.of(IntMappingType.UserId, IntMappingType.Password))));
        recipientAttrType.addRequiredLabel();
        form.add(new Component[]{recipientAttrType});
        AjaxDropDownChoicePanel recipientAttrName = new AjaxDropDownChoicePanel("recipientAttrName", new ResourceModel("recipientAttrName", "recipientAttrName").getObject(), (IModel)new PropertyModel((Object)notificationTO, "recipientAttrName"));
        recipientAttrName.setChoices(this.getSchemaNames((IntMappingType)recipientAttrType.getModelObject()));
        recipientAttrName.addRequiredLabel();
        form.add(new Component[]{recipientAttrName});
        recipientAttrType.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        WebMarkupContainer recipientsContainer = new WebMarkupContainer("recipientsContainer");
        recipientsContainer.setOutputMarkupId(true);
        form.add(new Component[]{recipientsContainer});
        AjaxCheckBoxPanel checkStaticRecipients = new AjaxCheckBoxPanel("checkStaticRecipients", "recipients", (IModel)new Model((Serializable)Boolean.valueOf(!notificationTO.getStaticRecipients().isEmpty())));
        form.add(new Component[]{checkStaticRecipients});
        if (createFlag) {
            checkStaticRecipients.getField().setDefaultModelObject((Object)Boolean.FALSE);
        }
        AjaxTextFieldPanel staticRecipientsFieldPanel = new AjaxTextFieldPanel("panel", "staticRecipients", (IModel)new Model(null));
        staticRecipientsFieldPanel.addValidator((IValidator)EmailAddressValidator.getInstance());
        staticRecipientsFieldPanel.setRequired(((Boolean)checkStaticRecipients.getModelObject()).booleanValue());
        if (notificationTO.getStaticRecipients().isEmpty()) {
            notificationTO.getStaticRecipients().add(null);
        }
        MultiFieldPanel staticRecipients = new MultiFieldPanel("staticRecipients", (IModel)new PropertyModel((Object)notificationTO, "staticRecipients"), (FieldPanel)staticRecipientsFieldPanel);
        staticRecipients.setEnabled(((Boolean)checkStaticRecipients.getModelObject()).booleanValue());
        form.add(new Component[]{staticRecipients});
        AjaxCheckBoxPanel checkRecipients = new AjaxCheckBoxPanel("checkRecipients", "checkRecipients", (IModel)new Model((Serializable)Boolean.valueOf(notificationTO.getRecipients() != null)));
        recipientsContainer.add(new Component[]{checkRecipients});
        if (createFlag) {
            checkRecipients.getField().setDefaultModelObject((Object)Boolean.TRUE);
        }
        UserSearchPanel recipients = new UserSearchPanel.Builder("recipients").fiql(notificationTO.getRecipients()).build();
        recipients.setEnabled(((Boolean)checkRecipients.getModelObject()).booleanValue());
        recipientsContainer.add(new Component[]{recipients});
        AjaxCheckBoxPanel selfAsRecipient = new AjaxCheckBoxPanel("selfAsRecipient", this.getString("selfAsRecipient"), (IModel)new PropertyModel((Object)notificationTO, "selfAsRecipient"));
        form.add(new Component[]{selfAsRecipient});
        if (createFlag) {
            selfAsRecipient.getField().setDefaultModelObject((Object)Boolean.FALSE);
        }
        selfAsRecipient.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        checkRecipients.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        checkStaticRecipients.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        9 submit = new /* Unavailable Anonymous Inner Class!! */;
        10 cancel = new /* Unavailable Anonymous Inner Class!! */;
        cancel.setDefaultFormProcessing(false);
        String allowedRoles = createFlag ? this.xmlRolesReader.getEntitlement("Notification", "create") : this.xmlRolesReader.getEntitlement("Notification", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)allowedRoles);
        form.add(new Component[]{submit});
        form.setDefaultButton((IFormSubmittingComponent)submit);
        form.add(new Component[]{cancel});
        this.add(new Component[]{form});
    }

    private List<String> getSchemaNames(IntMappingType type) {
        List result;
        if (type == null) {
            result = Collections.emptyList();
        } else {
            switch (11.$SwitchMap$org$apache$syncope$common$types$IntMappingType[type.ordinal()]) {
                case 1: {
                    result = this.schemaRestClient.getSchemaNames(AttributableType.USER);
                    break;
                }
                case 2: {
                    result = this.schemaRestClient.getDerSchemaNames(AttributableType.USER);
                    break;
                }
                case 3: {
                    result = this.schemaRestClient.getVirSchemaNames(AttributableType.USER);
                    break;
                }
                case 4: {
                    result = Collections.singletonList("Username");
                    break;
                }
                default: {
                    result = Collections.emptyList();
                }
            }
        }
        return result;
    }

    static /* synthetic */ List access$000(NotificationModalPage x0, IntMappingType x1) {
        return x0.getSchemaNames(x1);
    }

    static /* synthetic */ NotificationRestClient access$100(NotificationModalPage x0) {
        return x0.restClient;
    }
}

