/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.syncope.common.to.AbstractPolicyTO;
import org.apache.syncope.common.to.AccountPolicyTO;
import org.apache.syncope.common.to.PasswordPolicyTO;
import org.apache.syncope.common.to.ResourceTO;
import org.apache.syncope.common.to.SyncPolicyTO;
import org.apache.syncope.common.types.AbstractPolicySpec;
import org.apache.syncope.common.types.AccountPolicySpec;
import org.apache.syncope.common.types.PasswordPolicySpec;
import org.apache.syncope.common.types.PolicyType;
import org.apache.syncope.common.types.SyncPolicySpec;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.PolicyModalPage;
import org.apache.syncope.console.pages.panels.PolicyBeanPanel;
import org.apache.syncope.console.rest.PolicyRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class PolicyModalPage<T extends AbstractPolicyTO>
extends BaseModalPage {
    private static final long serialVersionUID = -7325772767481076679L;
    private static final int WIN_HEIGHT = 600;
    private static final int WIN_WIDTH = 1100;
    @SpringBean
    private PolicyRestClient policyRestClient;

    public PolicyModalPage(PageReference pageRef, ModalWindow window, T policyTO) {
        Fragment fragment;
        Form form = new Form("form");
        form.setOutputMarkupId(true);
        this.add(new Component[]{form});
        AjaxTextFieldPanel policyid = new AjaxTextFieldPanel("id", "id", (IModel)new PropertyModel(policyTO, "id"));
        policyid.setEnabled(false);
        policyid.setStyleSheet("ui-widget-content ui-corner-all short_fixedsize");
        form.add(new Component[]{policyid});
        AjaxTextFieldPanel description = new AjaxTextFieldPanel("description", "description", (IModel)new PropertyModel(policyTO, "description"));
        description.addRequiredLabel();
        description.setStyleSheet("ui-widget-content ui-corner-all medium_dynamicsize");
        form.add(new Component[]{description});
        AjaxDropDownChoicePanel type = new AjaxDropDownChoicePanel("type", "type", (IModel)new PropertyModel(policyTO, "type"));
        switch (9.$SwitchMap$org$apache$syncope$common$types$PolicyType[policyTO.getType().ordinal()]) {
            case 1: 
            case 2: {
                type.setChoices(Arrays.asList(PolicyType.GLOBAL_ACCOUNT, PolicyType.ACCOUNT));
                break;
            }
            case 3: 
            case 4: {
                type.setChoices(Arrays.asList(PolicyType.GLOBAL_PASSWORD, PolicyType.PASSWORD));
                break;
            }
            case 5: 
            case 6: {
                type.setChoices(Arrays.asList(PolicyType.GLOBAL_SYNC, PolicyType.SYNC));
            }
        }
        type.setChoiceRenderer((IChoiceRenderer)new PolicyTypeRenderer(this, null));
        type.addRequiredLabel();
        form.add(new Component[]{type});
        if (policyTO instanceof AccountPolicyTO) {
            fragment = new Fragment("forAccountOnly", "authResourcesFragment", (MarkupContainer)form);
            ArrayList<String> resourceNames = new ArrayList<String>();
            for (ResourceTO resource : this.resourceRestClient.getAll()) {
                resourceNames.add(resource.getName());
            }
            fragment.add(new Component[]{new AjaxPalettePanel("authResources", (IModel)new PropertyModel(policyTO, "resources"), new ListModel(resourceNames))});
        } else {
            fragment = new Fragment("forAccountOnly", "emptyFragment", (MarkupContainer)form);
        }
        form.add(new Component[]{fragment});
        AbstractPolicySpec policy = this.getPolicySpecification(policyTO);
        form.add(new Component[]{new PolicyBeanPanel("panel", policy)});
        ModalWindow mwindow = new ModalWindow("metaEditModalWin");
        mwindow.setCssClassName("w_silver");
        mwindow.setInitialHeight(600);
        mwindow.setInitialWidth(1100);
        mwindow.setCookieName("meta-edit-modal");
        this.add(new Component[]{mwindow});
        ArrayList<Object> resColumns = new ArrayList<Object>();
        resColumns.add(new /* Unavailable Anonymous Inner Class!! */);
        resColumns.add(new /* Unavailable Anonymous Inner Class!! */);
        3 resDataProvider = new /* Unavailable Anonymous Inner Class!! */;
        AjaxFallbackDefaultDataTable resources = new AjaxFallbackDefaultDataTable("resources", resColumns, (ISortableDataProvider)resDataProvider, 10);
        form.add(new Component[]{resources});
        ArrayList<Object> roleColumns = new ArrayList<Object>();
        roleColumns.add(new PropertyColumn((IModel)new ResourceModel("id", "id"), (Object)"id", "id"));
        roleColumns.add(new PropertyColumn((IModel)new ResourceModel("name", "name"), (Object)"name", "name"));
        roleColumns.add(new /* Unavailable Anonymous Inner Class!! */);
        5 roleDataProvider = new /* Unavailable Anonymous Inner Class!! */;
        AjaxFallbackDefaultDataTable roles = new AjaxFallbackDefaultDataTable("roles", roleColumns, (ISortableDataProvider)roleDataProvider, 10);
        form.add(new Component[]{roles});
        mwindow.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
        7 submit = new /* Unavailable Anonymous Inner Class!! */;
        form.add(new Component[]{submit});
        8 cancel = new /* Unavailable Anonymous Inner Class!! */;
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
    }

    private AbstractPolicySpec getPolicySpecification(AbstractPolicyTO policyTO) {
        AccountPolicySpec spec;
        switch (9.$SwitchMap$org$apache$syncope$common$types$PolicyType[policyTO.getType().ordinal()]) {
            case 1: 
            case 2: {
                spec = ((AccountPolicyTO)policyTO).getSpecification() != null ? ((AccountPolicyTO)policyTO).getSpecification() : new AccountPolicySpec();
                break;
            }
            case 3: 
            case 4: {
                spec = ((PasswordPolicyTO)policyTO).getSpecification() != null ? ((PasswordPolicyTO)policyTO).getSpecification() : new PasswordPolicySpec();
                break;
            }
            default: {
                spec = ((SyncPolicyTO)policyTO).getSpecification() != null ? ((SyncPolicyTO)policyTO).getSpecification() : new SyncPolicySpec();
            }
        }
        return spec;
    }

    private void setPolicySpecification(AbstractPolicyTO policyTO, AbstractPolicySpec specification) {
        switch (9.$SwitchMap$org$apache$syncope$common$types$PolicyType[policyTO.getType().ordinal()]) {
            case 1: 
            case 2: {
                if (!(specification instanceof AccountPolicySpec)) {
                    throw new ClassCastException("policy is type Account, but spec is not: " + specification.getClass().getName());
                }
                ((AccountPolicyTO)policyTO).setSpecification((AccountPolicySpec)specification);
                break;
            }
            case 3: 
            case 4: {
                if (!(specification instanceof PasswordPolicySpec)) {
                    throw new ClassCastException("policy is type Password, but spec is not: " + specification.getClass().getName());
                }
                ((PasswordPolicyTO)policyTO).setSpecification((PasswordPolicySpec)specification);
                break;
            }
            case 5: 
            case 6: {
                if (!(specification instanceof SyncPolicySpec)) {
                    throw new ClassCastException("policy is type Sync, but spec is not: " + specification.getClass().getName());
                }
                ((SyncPolicyTO)policyTO).setSpecification((SyncPolicySpec)specification);
            }
        }
    }

    static /* synthetic */ PolicyRestClient access$100(PolicyModalPage x0) {
        return x0.policyRestClient;
    }

    static /* synthetic */ void access$200(PolicyModalPage x0, AbstractPolicyTO x1, AbstractPolicySpec x2) {
        x0.setPolicySpecification(x1, x2);
    }
}

