/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.util.Arrays;
import java.util.Date;
import org.apache.syncope.common.report.AbstractReportletConf;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.ReportletConfModalPage;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.DateTimeFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.SpinnerFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.springframework.util.ClassUtils;

public class ReportletConfModalPage
extends BaseModalPage {
    private static final long serialVersionUID = 3910027601200382958L;
    private static final String[] EXCLUDE_PROPERTIES = new String[]{"serialVersionUID", "class", "name", "reportletClassName"};
    private AbstractReportletConf reportletConf;
    private final AjaxTextFieldPanel name;
    private WebMarkupContainer propertiesContainer;
    private ListView<String> propView;

    public ReportletConfModalPage(AbstractReportletConf reportletConf, ModalWindow window, PageReference pageRef) {
        this.reportletConf = reportletConf;
        Form form = new Form("form");
        this.add(new Component[]{form});
        this.propertiesContainer = new WebMarkupContainer("container");
        this.propertiesContainer.setOutputMarkupId(true);
        form.add(new Component[]{this.propertiesContainer});
        this.name = new AjaxTextFieldPanel("name", "name", (IModel)(this.reportletConf == null ? new Model() : new PropertyModel((Object)this.reportletConf, "name")));
        this.name.setOutputMarkupId(true);
        this.name.addRequiredLabel();
        form.add(new Component[]{this.name});
        AjaxDropDownChoicePanel reportletClass = new AjaxDropDownChoicePanel("reportletClass", "reportletClass", (IModel)new /* Unavailable Anonymous Inner Class!! */);
        reportletClass.setStyleSheet("long_dynamicsize");
        reportletClass.setChoices(this.reportRestClient.getReportletConfClasses());
        ((DropDownChoice)reportletClass.getField()).setNullValid(true);
        reportletClass.addRequiredLabel();
        reportletClass.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{reportletClass});
        this.propertiesContainer.add(new Component[]{this.buildPropView()});
        3 submit = new /* Unavailable Anonymous Inner Class!! */;
        form.add(new Component[]{submit});
        4 cancel = new /* Unavailable Anonymous Inner Class!! */;
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
    }

    private FieldPanel buildSinglePanel(Class<?> type, String fieldName, String id) {
        AjaxCheckBoxPanel result = null;
        PropertyModel model = new PropertyModel((Object)this.reportletConf, fieldName);
        if (ClassUtils.isAssignable(Boolean.class, type)) {
            result = new AjaxCheckBoxPanel(id, fieldName, (IModel)model);
        } else if (ClassUtils.isAssignable(Number.class, type)) {
            result = new SpinnerFieldPanel(id, fieldName, ClassUtils.resolvePrimitiveIfNecessary(type), (IModel)model, null, null);
        } else if (Date.class.equals(type)) {
            result = new DateTimeFieldPanel(id, fieldName, (IModel)model, "yyyy-MM-dd'T'HH:mm:ssZ");
        } else if (type.isEnum()) {
            result = new AjaxDropDownChoicePanel(id, fieldName, (IModel)model).setChoices(Arrays.asList(type.getEnumConstants()));
        }
        if (result == null) {
            result = new AjaxTextFieldPanel(id, fieldName, (IModel)model);
        }
        return result;
    }

    private ListView<String> buildPropView() {
        5 propViewModel = new /* Unavailable Anonymous Inner Class!! */;
        this.propView = new /* Unavailable Anonymous Inner Class!! */;
        return this.propView;
    }

    static /* synthetic */ AbstractReportletConf access$000(ReportletConfModalPage x0) {
        return x0.reportletConf;
    }

    static /* synthetic */ AbstractReportletConf access$002(ReportletConfModalPage x0, AbstractReportletConf x1) {
        x0.reportletConf = x1;
        return x0.reportletConf;
    }

    static /* synthetic */ ListView access$100(ReportletConfModalPage x0) {
        return x0.buildPropView();
    }

    static /* synthetic */ WebMarkupContainer access$200(ReportletConfModalPage x0) {
        return x0.propertiesContainer;
    }

    static /* synthetic */ AjaxTextFieldPanel access$300(ReportletConfModalPage x0) {
        return x0.name;
    }

    static /* synthetic */ ListView access$400(ReportletConfModalPage x0) {
        return x0.propView;
    }

    static /* synthetic */ String[] access$500() {
        return EXCLUDE_PROPERTIES;
    }

    static /* synthetic */ FieldPanel access$600(ReportletConfModalPage x0, Class x1, String x2, String x3) {
        return x0.buildSinglePanel(x1, x2, x3);
    }
}

