/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.common.types.SchemaType;
import org.apache.syncope.console.commons.PreferenceManager;
import org.apache.syncope.console.commons.SelectChoiceRenderer;
import org.apache.syncope.console.pages.AbstractSchemaModalPage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.Schema;
import org.apache.syncope.console.pages.panels.JQueryUITabbedPanel;
import org.apache.syncope.console.rest.SchemaRestClient;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.springframework.util.ReflectionUtils;

public class Schema
extends BasePage {
    private static final long serialVersionUID = 8091922398776299403L;
    private static final Map<SchemaType, List<String>> COL_NAMES = new /* Unavailable Anonymous Inner Class!! */;
    private static final Map<Map.Entry<AttributableType, SchemaType>, String> PAGINATOR_ROWS_KEYS = new /* Unavailable Anonymous Inner Class!! */;
    private static final int WIN_WIDTH = 600;
    private static final int WIN_HEIGHT = 200;
    private static final int NORMAL_WIN_HEIGHT = 500;
    @SpringBean
    private SchemaRestClient restClient;
    @SpringBean
    private PreferenceManager prefMan;
    private final String allowedCreateRoles;
    private final String allowedReadRoles;
    private final String allowedDeleteRoles;

    public Schema() {
        this.allowedCreateRoles = this.xmlRolesReader.getEntitlement("Schema", "create");
        this.allowedReadRoles = this.xmlRolesReader.getEntitlement("Schema", "read");
        this.allowedDeleteRoles = this.xmlRolesReader.getEntitlement("Schema", "delete");
        for (AttributableType attrType : AttributableType.values()) {
            String attrTypeAsString = attrType.name().toLowerCase();
            ArrayList<3> tabs = new ArrayList<3>();
            for (SchemaType schemaType : SchemaType.values()) {
                if (attrType == AttributableType.CONFIGURATION && schemaType != SchemaType.NORMAL) continue;
                String schemaTypeAsString = schemaType.name().toLowerCase();
                tabs.add(new /* Unavailable Anonymous Inner Class!! */);
            }
            this.add(new Component[]{new JQueryUITabbedPanel(attrTypeAsString + "Tabs", tabs)});
        }
    }

    private <T extends AbstractSchemaModalPage> List<IColumn> getColumns(WebMarkupContainer webContainer, ModalWindow modalWindow, AttributableType attributableType, SchemaType schemaType, Collection<String> fields) {
        ArrayList<IColumn> columns = new ArrayList<IColumn>();
        for (String field : fields) {
            Field clazzField = ReflectionUtils.findField((Class)schemaType.getToClass(), (String)field);
            if (clazzField == null) continue;
            if (clazzField.getType().equals(Boolean.class) || clazzField.getType().equals(Boolean.TYPE)) {
                columns.add((IColumn)new /* Unavailable Anonymous Inner Class!! */);
                continue;
            }
            5 column = new /* Unavailable Anonymous Inner Class!! */;
            columns.add((IColumn)column);
        }
        columns.add((IColumn)new /* Unavailable Anonymous Inner Class!! */);
        return columns;
    }

    private Form<Void> getPaginatorForm(WebMarkupContainer webContainer, AjaxFallbackDefaultDataTable dataTable, String formname, SchemaTypePanel schemaTypePanel, String rowsPerPagePrefName) {
        Form form = new Form(formname);
        DropDownChoice rowChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)schemaTypePanel, "pageRows"), this.prefMan.getPaginatorChoices(), (IChoiceRenderer)new SelectChoiceRenderer());
        rowChooser.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{rowChooser});
        return form;
    }

    private <T extends AbstractSchemaModalPage> AjaxLink<Void> getCreateSchemaLink(ModalWindow modalWindow, AttributableType attrType, SchemaType schemaType, String winLinkName) {
        8 link = new /* Unavailable Anonymous Inner Class!! */;
        MetaDataRoleAuthorizationStrategy.authorize((Component)link, (Action)ENABLE, (String)this.allowedCreateRoles);
        return link;
    }

    static /* synthetic */ String access$000(Schema x0) {
        return x0.allowedReadRoles;
    }

    static /* synthetic */ SchemaRestClient access$100(Schema x0) {
        return x0.restClient;
    }

    static /* synthetic */ String access$200(Schema x0) {
        return x0.allowedDeleteRoles;
    }

    static /* synthetic */ PreferenceManager access$300(Schema x0) {
        return x0.prefMan;
    }

    static /* synthetic */ Map access$400() {
        return PAGINATOR_ROWS_KEYS;
    }

    static /* synthetic */ Map access$500() {
        return COL_NAMES;
    }

    static /* synthetic */ List access$600(Schema x0, WebMarkupContainer x1, ModalWindow x2, AttributableType x3, SchemaType x4, Collection x5) {
        return x0.getColumns(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ Form access$700(Schema x0, WebMarkupContainer x1, AjaxFallbackDefaultDataTable x2, String x3, SchemaTypePanel x4, String x5) {
        return x0.getPaginatorForm(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ AjaxLink access$800(Schema x0, ModalWindow x1, AttributableType x2, SchemaType x3, String x4) {
        return x0.getCreateSchemaLink(x1, x2, x3, x4);
    }
}

