/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.to.SchemaTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.common.types.AttributeSchemaType;
import org.apache.syncope.common.types.CipherAlgorithm;
import org.apache.syncope.console.commons.JexlHelpUtil;
import org.apache.syncope.console.pages.AbstractSchemaModalPage;
import org.apache.syncope.console.pages.SchemaModalPage;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class SchemaModalPage
extends AbstractSchemaModalPage<SchemaTO> {
    private static final long serialVersionUID = -5991561277287424057L;

    public SchemaModalPage(AttributableType kind) {
        super(kind);
    }

    public void setSchemaModalPage(PageReference pageRef, ModalWindow window, SchemaTO schemaTO, boolean createFlag) {
        SchemaTO schema = schemaTO == null ? new SchemaTO() : schemaTO;
        Form schemaForm = new Form("form");
        schemaForm.setModel((IModel)new CompoundPropertyModel((Object)schema));
        schemaForm.setOutputMarkupId(true);
        AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", this.getString("name"), (IModel)new PropertyModel((Object)schema, "name"));
        name.addRequiredLabel();
        name.setEnabled(createFlag);
        schemaForm.add(new Component[]{name});
        AjaxDropDownChoicePanel type = new AjaxDropDownChoicePanel("type", this.getString("type"), (IModel)new PropertyModel((Object)schema, "type"));
        type.setChoices(Arrays.asList(AttributeSchemaType.values()));
        type.addRequiredLabel();
        schemaForm.add(new Component[]{type});
        AjaxTextFieldPanel conversionPattern = new AjaxTextFieldPanel("conversionPattern", this.getString("conversionPattern"), (IModel)new PropertyModel((Object)schema, "conversionPattern"));
        schemaForm.add(new Component[]{conversionPattern});
        WebMarkupContainer conversionParams = new WebMarkupContainer("conversionParams");
        conversionParams.setOutputMarkupPlaceholderTag(true);
        conversionParams.add(new Component[]{conversionPattern});
        schemaForm.add(new Component[]{conversionParams});
        WebMarkupContainer typeParams = new WebMarkupContainer("typeParams");
        typeParams.setOutputMarkupPlaceholderTag(true);
        AjaxTextFieldPanel enumerationValuesPanel = new AjaxTextFieldPanel("panel", "enumerationValues", (IModel)new Model(null));
        MultiFieldPanel enumerationValues = new MultiFieldPanel("enumerationValues", (IModel)new Model(), (FieldPanel)enumerationValuesPanel);
        enumerationValues.setModelObject(this.getEnumValuesAsList(schema.getEnumerationValues()));
        MultiFieldPanel enumerationKeys = new MultiFieldPanel("enumerationKeys", (IModel)new Model(), (FieldPanel)new AjaxTextFieldPanel("panel", "enumerationKeys", (IModel)new Model(null)));
        enumerationKeys.setModelObject(this.getEnumValuesAsList(schema.getEnumerationKeys()));
        WebMarkupContainer enumParams = new WebMarkupContainer("enumParams");
        enumParams.setOutputMarkupPlaceholderTag(true);
        enumParams.add(new Component[]{enumerationValues});
        enumParams.add(new Component[]{enumerationKeys});
        typeParams.add(new Component[]{enumParams});
        AjaxTextFieldPanel secretKey = new AjaxTextFieldPanel("secretKey", this.getString("secretKey"), (IModel)new PropertyModel((Object)schema, "secretKey"));
        AjaxDropDownChoicePanel cipherAlgorithm = new AjaxDropDownChoicePanel("cipherAlgorithm", this.getString("cipherAlgorithm"), (IModel)new PropertyModel((Object)schema, "cipherAlgorithm"));
        cipherAlgorithm.setChoices(Arrays.asList(CipherAlgorithm.values()));
        WebMarkupContainer encryptedParams = new WebMarkupContainer("encryptedParams");
        encryptedParams.setOutputMarkupPlaceholderTag(true);
        encryptedParams.add(new Component[]{secretKey});
        encryptedParams.add(new Component[]{cipherAlgorithm});
        typeParams.add(new Component[]{encryptedParams});
        AjaxTextFieldPanel mimeType = new AjaxTextFieldPanel("mimeType", this.getString("mimeType"), (IModel)new PropertyModel((Object)schema, "mimeType"));
        mimeType.setChoices(this.mimeTypesInitializer.getMimeTypes());
        WebMarkupContainer binaryParams = new WebMarkupContainer("binaryParams");
        binaryParams.setOutputMarkupPlaceholderTag(true);
        binaryParams.add(new Component[]{mimeType});
        typeParams.add(new Component[]{binaryParams});
        schemaForm.add(new Component[]{typeParams});
        this.showHide(schema, type, conversionParams, conversionPattern, enumParams, enumerationValuesPanel, enumerationValues, enumerationKeys, encryptedParams, secretKey, cipherAlgorithm, binaryParams, mimeType);
        type.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        2 validatorsList = new /* Unavailable Anonymous Inner Class!! */;
        AjaxDropDownChoicePanel validatorClass = new AjaxDropDownChoicePanel("validatorClass", this.getString("validatorClass"), (IModel)new PropertyModel((Object)schema, "validatorClass"));
        ((DropDownChoice)validatorClass.getField()).setNullValid(true);
        validatorClass.setChoices((List)validatorsList.getObject());
        schemaForm.add(new Component[]{validatorClass});
        3 mandatoryCondition = new /* Unavailable Anonymous Inner Class!! */;
        mandatoryCondition.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        schemaForm.add(new Component[]{mandatoryCondition});
        WebMarkupContainer pwdJexlHelp = JexlHelpUtil.getJexlHelpWebContainer((String)"jexlHelp");
        AjaxLink pwdQuestionMarkJexlHelp = JexlHelpUtil.getAjaxLink((WebMarkupContainer)pwdJexlHelp, (String)"questionMarkJexlHelp");
        schemaForm.add(new Component[]{pwdQuestionMarkJexlHelp});
        pwdQuestionMarkJexlHelp.add(new Component[]{pwdJexlHelp});
        AjaxCheckBoxPanel multivalue = new AjaxCheckBoxPanel("multivalue", this.getString("multivalue"), (IModel)new PropertyModel((Object)schema, "multivalue"));
        schemaForm.add(new Component[]{multivalue});
        AjaxCheckBoxPanel readonly = new AjaxCheckBoxPanel("readonly", this.getString("readonly"), (IModel)new PropertyModel((Object)schema, "readonly"));
        schemaForm.add(new Component[]{readonly});
        AjaxCheckBoxPanel uniqueConstraint = new AjaxCheckBoxPanel("uniqueConstraint", this.getString("uniqueConstraint"), (IModel)new PropertyModel((Object)schema, "uniqueConstraint"));
        schemaForm.add(new Component[]{uniqueConstraint});
        5 submit = new /* Unavailable Anonymous Inner Class!! */;
        schemaForm.add(new Component[]{submit});
        6 cancel = new /* Unavailable Anonymous Inner Class!! */;
        cancel.setDefaultFormProcessing(false);
        schemaForm.add(new Component[]{cancel});
        String allowedRoles = createFlag ? this.xmlRolesReader.getEntitlement("Schema", "create") : this.xmlRolesReader.getEntitlement("Schema", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)allowedRoles);
        this.add(new Component[]{schemaForm});
    }

    private void showHide(SchemaTO schema, AjaxDropDownChoicePanel<AttributeSchemaType> type, WebMarkupContainer conversionParams, AjaxTextFieldPanel conversionPattern, WebMarkupContainer enumParams, AjaxTextFieldPanel enumerationValuesPanel, MultiFieldPanel<String> enumerationValues, MultiFieldPanel<String> enumerationKeys, WebMarkupContainer encryptedParams, AjaxTextFieldPanel secretKey, AjaxDropDownChoicePanel<CipherAlgorithm> cipherAlgorithm, WebMarkupContainer binaryParams, AjaxTextFieldPanel mimeType) {
        int typeOrdinal = Integer.parseInt(type.getField().getValue());
        if (AttributeSchemaType.Long.ordinal() == typeOrdinal || AttributeSchemaType.Double.ordinal() == typeOrdinal || AttributeSchemaType.Date.ordinal() == typeOrdinal) {
            conversionParams.setVisible(true);
            enumParams.setVisible(false);
            if (enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.removeRequiredLabel();
            }
            enumerationValues.setModelObject(this.getEnumValuesAsList(null));
            enumerationKeys.setModelObject(this.getEnumValuesAsList(null));
            encryptedParams.setVisible(false);
            if (secretKey.isRequired()) {
                secretKey.removeRequiredLabel();
            }
            secretKey.setModelObject(null);
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.removeRequiredLabel();
            }
            cipherAlgorithm.setModelObject(null);
            binaryParams.setVisible(false);
            mimeType.setModelObject(null);
        } else if (AttributeSchemaType.Enum.ordinal() == typeOrdinal) {
            conversionParams.setVisible(false);
            conversionPattern.setModelObject(null);
            enumParams.setVisible(true);
            if (!enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.addRequiredLabel();
            }
            enumerationValues.setModelObject(this.getEnumValuesAsList(schema.getEnumerationValues()));
            enumerationKeys.setModelObject(this.getEnumValuesAsList(schema.getEnumerationKeys()));
            encryptedParams.setVisible(false);
            if (secretKey.isRequired()) {
                secretKey.removeRequiredLabel();
            }
            secretKey.setModelObject(null);
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.removeRequiredLabel();
            }
            cipherAlgorithm.setModelObject(null);
            binaryParams.setVisible(false);
            mimeType.setModelObject(null);
        } else if (AttributeSchemaType.Encrypted.ordinal() == typeOrdinal) {
            conversionParams.setVisible(false);
            conversionPattern.setModelObject(null);
            enumParams.setVisible(false);
            if (enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.removeRequiredLabel();
            }
            enumerationValues.setModelObject(this.getEnumValuesAsList(null));
            enumerationKeys.setModelObject(this.getEnumValuesAsList(null));
            encryptedParams.setVisible(true);
            if (!secretKey.isRequired()) {
                secretKey.addRequiredLabel();
            }
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.addRequiredLabel();
            }
            binaryParams.setVisible(false);
            mimeType.setModelObject(null);
        } else if (AttributeSchemaType.Binary.ordinal() == typeOrdinal) {
            conversionParams.setVisible(false);
            conversionPattern.setModelObject(null);
            enumParams.setVisible(false);
            if (enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.removeRequiredLabel();
            }
            enumerationValues.setModelObject(this.getEnumValuesAsList(null));
            enumerationKeys.setModelObject(this.getEnumValuesAsList(null));
            encryptedParams.setVisible(false);
            if (secretKey.isRequired()) {
                secretKey.removeRequiredLabel();
            }
            secretKey.setModelObject(null);
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.removeRequiredLabel();
            }
            cipherAlgorithm.setModelObject(null);
            binaryParams.setVisible(true);
        } else {
            conversionParams.setVisible(false);
            conversionPattern.setModelObject(null);
            enumParams.setVisible(false);
            if (enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.removeRequiredLabel();
            }
            enumerationValues.setModelObject(this.getEnumValuesAsList(null));
            enumerationKeys.setModelObject(this.getEnumValuesAsList(null));
            encryptedParams.setVisible(false);
            if (secretKey.isRequired()) {
                secretKey.removeRequiredLabel();
            }
            secretKey.setModelObject(null);
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.removeRequiredLabel();
            }
            cipherAlgorithm.setModelObject(null);
            binaryParams.setVisible(false);
            mimeType.setModelObject(null);
        }
    }

    private String getEnumValuesAsString(List<String> enumerationValues) {
        StringBuilder builder = new StringBuilder();
        for (String str : enumerationValues) {
            if (!StringUtils.isNotBlank((CharSequence)str)) continue;
            if (builder.length() > 0) {
                builder.append(";");
            }
            builder.append(str.trim());
        }
        return builder.toString();
    }

    private List<String> getEnumValuesAsList(String enumerationValues) {
        ArrayList<String> values = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)enumerationValues)) {
            for (String value : enumerationValues.split(";")) {
                values.add(value.trim());
            }
        } else {
            values.add("");
        }
        return values;
    }

    static /* synthetic */ void access$000(SchemaModalPage x0, SchemaTO x1, AjaxDropDownChoicePanel x2, WebMarkupContainer x3, AjaxTextFieldPanel x4, WebMarkupContainer x5, AjaxTextFieldPanel x6, MultiFieldPanel x7, MultiFieldPanel x8, WebMarkupContainer x9, AjaxTextFieldPanel x10, AjaxDropDownChoicePanel x11, WebMarkupContainer x12, AjaxTextFieldPanel x13) {
        x0.showHide(x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13);
    }

    static /* synthetic */ String access$100(SchemaModalPage x0, List x1) {
        return x0.getEnumValuesAsString(x1);
    }
}

