/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.client.CompleteCondition;
import org.apache.cxf.jaxrs.ext.search.fiql.FiqlParser;
import org.apache.syncope.common.search.RoleFiqlSearchConditionBuilder;
import org.apache.syncope.common.search.SpecialAttr;
import org.apache.syncope.common.search.SyncopeFiqlSearchConditionBuilder;
import org.apache.syncope.common.search.SyncopeProperty;
import org.apache.syncope.common.search.UserFiqlSearchConditionBuilder;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.console.pages.panels.AbstractSearchPanel;
import org.apache.syncope.console.pages.panels.NotificationPanel;
import org.apache.syncope.console.pages.panels.SearchClause;
import org.apache.syncope.console.pages.panels.SearchView;
import org.apache.syncope.console.rest.AuthRestClient;
import org.apache.syncope.console.rest.ResourceRestClient;
import org.apache.syncope.console.rest.SchemaRestClient;
import org.apache.wicket.Component;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchPanel
extends Panel {
    private static final long serialVersionUID = 5922413053568696414L;
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractSearchPanel.class);
    @SpringBean
    protected SchemaRestClient schemaRestClient;
    @SpringBean
    protected ResourceRestClient resourceRestClient;
    @SpringBean
    protected AuthRestClient authRestClient;
    protected IModel<List<String>> dnames;
    protected IModel<List<String>> anames;
    protected IModel<List<String>> resourceNames;
    protected IModel<List<String>> entitlements;
    protected IModel<List<SearchClause.Type>> types;
    protected IModel<List<String>> roleNames;
    protected NotificationPanel searchFeedback;
    protected List<SearchClause> searchClauses;
    protected WebMarkupContainer searchFormContainer;
    protected AttributableType attributableType;
    protected boolean required;

    protected AbstractSearchPanel(String id, AttributableType attributableType) {
        this(id, attributableType, null, true);
    }

    protected AbstractSearchPanel(String id, AttributableType attributableType, String fiql, boolean required) {
        super(id);
        this.populate();
        this.attributableType = attributableType;
        this.required = required;
        this.setOutputMarkupId(true);
        this.searchFormContainer = new WebMarkupContainer("searchFormContainer");
        this.searchFormContainer.setOutputMarkupId(true);
        this.searchFeedback = new NotificationPanel("searchFeedback", "notificationpanel_top_right", (IFeedbackMessageFilter)new /* Unavailable Anonymous Inner Class!! */);
        this.searchFeedback.setOutputMarkupId(true);
        this.add(new Component[]{this.searchFeedback});
        this.searchClauses = new ArrayList();
        this.searchClauses.add(new SearchClause());
        if (StringUtils.isNotBlank((CharSequence)fiql)) {
            try {
                FiqlParser fiqlParser = new FiqlParser(SearchBean.class, SyncopeFiqlSearchConditionBuilder.CONTEXTUAL_PROPERTIES);
                List parsed = this.getSearchClauses(fiqlParser.parse(fiql));
                this.searchClauses.clear();
                this.searchClauses.addAll(parsed);
            }
            catch (Exception e) {
                LOG.error("Unparseable FIQL expression '{}'", (Object)fiql, (Object)e);
            }
        }
        this.searchFormContainer.add(new Component[]{new SearchView("searchView", this.searchClauses, this.searchFormContainer, required, this.types, this.anames, this.dnames, this.roleNames, this.resourceNames, this.entitlements)});
        this.add(new Component[]{this.searchFormContainer});
    }

    protected void populate() {
        this.dnames = new /* Unavailable Anonymous Inner Class!! */;
        this.anames = new /* Unavailable Anonymous Inner Class!! */;
        this.resourceNames = new /* Unavailable Anonymous Inner Class!! */;
        this.entitlements = new /* Unavailable Anonymous Inner Class!! */;
    }

    public NotificationPanel getSearchFeedback() {
        return this.searchFeedback;
    }

    private SearchClause getPrimitiveSearchClause(SearchCondition<SearchBean> sc) {
        SearchClause searchClause = new SearchClause();
        String property = (String)((SearchBean)sc.getCondition()).getKeySet().iterator().next();
        searchClause.setProperty(property);
        String value = ((SearchBean)sc.getCondition()).get(property);
        searchClause.setValue(value);
        if (SpecialAttr.ROLES.toString().equals(property)) {
            searchClause.setType(SearchClause.Type.MEMBERSHIP);
            for (String label : (List)this.roleNames.getObject()) {
                if (!value.equals(label.substring(0, label.indexOf(32)))) continue;
                searchClause.setProperty(label);
            }
        } else if (SpecialAttr.RESOURCES.toString().equals(property)) {
            searchClause.setType(SearchClause.Type.RESOURCE);
            searchClause.setProperty(value);
        } else if (SpecialAttr.ENTITLEMENTS.toString().equals(property)) {
            searchClause.setType(SearchClause.Type.ENTITLEMENT);
        } else {
            searchClause.setType(SearchClause.Type.ATTRIBUTE);
        }
        switch (6.$SwitchMap$org$apache$cxf$jaxrs$ext$search$ConditionType[sc.getConditionType().ordinal()]) {
            case 1: {
                searchClause.setComparator(SpecialAttr.NULL.toString().equals(value) ? SearchClause.Comparator.IS_NULL : SearchClause.Comparator.EQUALS);
                break;
            }
            case 2: {
                searchClause.setComparator(SpecialAttr.NULL.toString().equals(value) ? SearchClause.Comparator.IS_NOT_NULL : SearchClause.Comparator.NOT_EQUALS);
                break;
            }
            case 3: {
                searchClause.setComparator(SearchClause.Comparator.GREATER_OR_EQUALS);
                break;
            }
            case 4: {
                searchClause.setComparator(SearchClause.Comparator.GREATER_THAN);
                break;
            }
            case 5: {
                searchClause.setComparator(SearchClause.Comparator.LESS_OR_EQUALS);
                break;
            }
            case 6: {
                searchClause.setComparator(SearchClause.Comparator.LESS_THAN);
                break;
            }
        }
        return searchClause;
    }

    private List<SearchClause> getCompoundSearchClause(SearchCondition<SearchBean> sc) {
        ArrayList<SearchClause> clauses = new ArrayList<SearchClause>();
        for (SearchCondition searchCondition : sc.getSearchConditions()) {
            if (searchCondition.getStatement() == null) {
                clauses.addAll(this.getCompoundSearchClause(searchCondition));
                continue;
            }
            SearchClause clause = this.getPrimitiveSearchClause(searchCondition);
            if (sc.getConditionType() == ConditionType.AND) {
                clause.setOperator(SearchClause.Operator.AND);
            }
            if (sc.getConditionType() == ConditionType.OR) {
                clause.setOperator(SearchClause.Operator.OR);
            }
            clauses.add(clause);
        }
        return clauses;
    }

    private List<SearchClause> getSearchClauses(SearchCondition<SearchBean> sc) {
        ArrayList<SearchClause> clauses = new ArrayList<SearchClause>();
        if (sc.getStatement() == null) {
            clauses.addAll(this.getCompoundSearchClause(sc));
        } else {
            clauses.add(this.getPrimitiveSearchClause(sc));
        }
        return clauses;
    }

    protected abstract SyncopeFiqlSearchConditionBuilder getSearchConditionBuilder();

    public String buildFIQL() {
        LOG.debug("Generating FIQL from List<SearchClause>: {}", (Object)this.searchClauses);
        if (this.searchClauses.isEmpty() || ((SearchClause)this.searchClauses.get(0)).getType() == null) {
            return "";
        }
        SyncopeFiqlSearchConditionBuilder builder = this.getSearchConditionBuilder();
        CompleteCondition condition = null;
        for (int i = 0; i < this.searchClauses.size(); ++i) {
            CompleteCondition prevCondition = condition;
            block0 : switch (6.$SwitchMap$org$apache$syncope$console$pages$panels$SearchClause$Type[((SearchClause)this.searchClauses.get(i)).getType().ordinal()]) {
                case 1: {
                    condition = ((SearchClause)this.searchClauses.get(i)).getComparator() == SearchClause.Comparator.EQUALS ? ((RoleFiqlSearchConditionBuilder)builder).hasEntitlements(((SearchClause)this.searchClauses.get(i)).getProperty(), new String[0]) : ((RoleFiqlSearchConditionBuilder)builder).hasNotEntitlements(((SearchClause)this.searchClauses.get(i)).getProperty(), new String[0]);
                    break;
                }
                case 2: {
                    Long roleId = NumberUtils.toLong((String)((SearchClause)this.searchClauses.get(i)).getProperty().split(" ")[0]);
                    condition = ((SearchClause)this.searchClauses.get(i)).getComparator() == SearchClause.Comparator.EQUALS ? ((UserFiqlSearchConditionBuilder)builder).hasRoles(roleId, new Long[0]) : ((UserFiqlSearchConditionBuilder)builder).hasNotRoles(roleId, new Long[0]);
                    break;
                }
                case 3: {
                    condition = ((SearchClause)this.searchClauses.get(i)).getComparator() == SearchClause.Comparator.EQUALS ? builder.hasResources(((SearchClause)this.searchClauses.get(i)).getProperty(), new String[0]) : builder.hasNotResources(((SearchClause)this.searchClauses.get(i)).getProperty(), new String[0]);
                    break;
                }
                case 4: {
                    SyncopeProperty property = builder.is(((SearchClause)this.searchClauses.get(i)).getProperty());
                    switch (6.$SwitchMap$org$apache$syncope$console$pages$panels$SearchClause$Comparator[((SearchClause)this.searchClauses.get(i)).getComparator().ordinal()]) {
                        case 1: {
                            condition = builder.isNull(((SearchClause)this.searchClauses.get(i)).getProperty());
                            break block0;
                        }
                        case 2: {
                            condition = builder.isNotNull(((SearchClause)this.searchClauses.get(i)).getProperty());
                            break block0;
                        }
                        case 3: {
                            condition = StringUtils.isNumeric((CharSequence)((SearchClause)this.searchClauses.get(i)).getProperty()) ? property.lessThan(Double.valueOf(NumberUtils.toDouble((String)((SearchClause)this.searchClauses.get(i)).getValue()))) : property.lexicalBefore(((SearchClause)this.searchClauses.get(i)).getValue());
                            break block0;
                        }
                        case 4: {
                            condition = StringUtils.isNumeric((CharSequence)((SearchClause)this.searchClauses.get(i)).getProperty()) ? property.lessOrEqualTo(Double.valueOf(NumberUtils.toDouble((String)((SearchClause)this.searchClauses.get(i)).getValue()))) : property.lexicalNotAfter(((SearchClause)this.searchClauses.get(i)).getValue());
                            break block0;
                        }
                        case 5: {
                            condition = StringUtils.isNumeric((CharSequence)((SearchClause)this.searchClauses.get(i)).getProperty()) ? property.greaterThan(Double.valueOf(NumberUtils.toDouble((String)((SearchClause)this.searchClauses.get(i)).getValue()))) : property.lexicalAfter(((SearchClause)this.searchClauses.get(i)).getValue());
                            break block0;
                        }
                        case 6: {
                            condition = StringUtils.isNumeric((CharSequence)((SearchClause)this.searchClauses.get(i)).getProperty()) ? property.greaterOrEqualTo(Double.valueOf(NumberUtils.toDouble((String)((SearchClause)this.searchClauses.get(i)).getValue()))) : property.lexicalNotBefore(((SearchClause)this.searchClauses.get(i)).getValue());
                            break block0;
                        }
                        case 7: {
                            condition = property.notEqualTo(((SearchClause)this.searchClauses.get(i)).getValue());
                            break block0;
                        }
                    }
                    condition = property.equalTo(((SearchClause)this.searchClauses.get(i)).getValue(), new String[0]);
                }
            }
            if (i <= 0) continue;
            if (((SearchClause)this.searchClauses.get(i)).getOperator() == SearchClause.Operator.AND) {
                condition = builder.and(prevCondition, condition, new CompleteCondition[0]);
            }
            if (((SearchClause)this.searchClauses.get(i)).getOperator() != SearchClause.Operator.OR) continue;
            condition = builder.or(prevCondition, condition, new CompleteCondition[0]);
        }
        String fiql = condition == null ? "" : condition.query();
        LOG.debug("Generated FIQL: {}", (Object)fiql);
        return fiql;
    }
}

