/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.to.EventCategoryTO;
import org.apache.syncope.common.types.AuditElements;
import org.apache.syncope.common.util.LoggerEventUtils;
import org.apache.syncope.console.pages.panels.LoggerCategoryPanel;
import org.apache.syncope.console.pages.panels.SelectedEventsPanel;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoggerCategoryPanel
extends Panel {
    private static final Logger LOG = LoggerFactory.getLogger(LoggerCategoryPanel.class);
    private static final long serialVersionUID = 6429053774964787734L;
    private final List<EventCategoryTO> eventCategoryTOs;
    private final EventCategoryTO eventCategoryTO = new EventCategoryTO();
    private final WebMarkupContainer categoryContainer;
    private final WebMarkupContainer eventsContainer;
    private final SelectedEventsPanel selectedEventsPanel;
    private final AjaxDropDownChoicePanel<AuditElements.EventCategoryType> type;
    private final AjaxDropDownChoicePanel<String> category;
    private final AjaxDropDownChoicePanel<String> subcategory;
    private final AjaxTextFieldPanel custom;
    private final ActionLinksPanel actionPanel;
    private final IModel<List<String>> model;

    public LoggerCategoryPanel(String id, List<EventCategoryTO> eventCategoryTOs, IModel<List<String>> model, PageReference pageReference, String pageId) {
        super(id);
        this.model = model;
        this.selectedEventsPanel = new SelectedEventsPanel("selectedEventsPanel", model);
        this.add(new Component[]{this.selectedEventsPanel});
        this.eventCategoryTOs = eventCategoryTOs;
        this.categoryContainer = new WebMarkupContainer("categoryContainer");
        this.categoryContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.categoryContainer});
        this.eventsContainer = new WebMarkupContainer("eventsContainer");
        this.eventsContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.eventsContainer});
        this.authorizeList();
        this.authorizeChanges();
        this.categoryContainer.add(new Component[]{new Label("typeLabel", (IModel)new ResourceModel("type", "type"))});
        this.type = new AjaxDropDownChoicePanel("type", "type", (IModel)new PropertyModel((Object)this.eventCategoryTO, "type"), false);
        this.type.setChoices(Arrays.asList(AuditElements.EventCategoryType.values()));
        this.type.setStyleSheet("ui-widget-content ui-corner-all");
        this.type.setChoiceRenderer((IChoiceRenderer)new /* Unavailable Anonymous Inner Class!! */);
        this.categoryContainer.add(new Component[]{this.type});
        this.type.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        this.categoryContainer.add(new Component[]{new Label("categoryLabel", (IModel)new ResourceModel("category", "category"))});
        this.category = new AjaxDropDownChoicePanel("category", "category", (IModel)new PropertyModel((Object)this.eventCategoryTO, "category"), false);
        this.category.setChoices(this.filter(eventCategoryTOs, (AuditElements.EventCategoryType)this.type.getModelObject()));
        this.category.setStyleSheet("ui-widget-content ui-corner-all");
        this.categoryContainer.add(new Component[]{this.category});
        this.category.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        this.categoryContainer.add(new Component[]{new Label("subcategoryLabel", (IModel)new ResourceModel("subcategory", "subcategory"))});
        this.subcategory = new AjaxDropDownChoicePanel("subcategory", "subcategory", (IModel)new PropertyModel((Object)this.eventCategoryTO, "subcategory"), false);
        this.subcategory.setChoices(this.filter(eventCategoryTOs, (AuditElements.EventCategoryType)this.type.getModelObject(), (String)this.category.getModelObject()));
        this.subcategory.setStyleSheet("ui-widget-content ui-corner-all");
        this.categoryContainer.add(new Component[]{this.subcategory});
        this.subcategory.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        this.categoryContainer.add(new Component[]{new Label("customLabel", (IModel)new ResourceModel("custom", "custom")).setVisible(false)});
        this.custom = new AjaxTextFieldPanel("custom", "custom", (IModel)new Model(null));
        this.custom.setStyleSheet("ui-widget-content ui-corner-all short_fixedsize");
        this.custom.setVisible(false);
        this.custom.setEnabled(false);
        this.categoryContainer.add(new Component[]{this.custom});
        this.actionPanel = new ActionLinksPanel("customActions", (IModel)new Model(), pageReference);
        this.categoryContainer.add(new Component[]{this.actionPanel});
        this.actionPanel.add((ActionLink)new /* Unavailable Anonymous Inner Class!! */, ActionLink.ActionType.CREATE, pageId, true);
        this.actionPanel.add((ActionLink)new /* Unavailable Anonymous Inner Class!! */, ActionLink.ActionType.DELETE, pageId, true);
        this.actionPanel.setVisible(false);
        this.actionPanel.setEnabled(false);
        this.eventsContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private List<String> filter(List<EventCategoryTO> eventCategoryTOs, AuditElements.EventCategoryType type) {
        HashSet<String> res = new HashSet<String>();
        for (EventCategoryTO eventCategory : eventCategoryTOs) {
            if (type != eventCategory.getType() || !StringUtils.isNotEmpty((CharSequence)eventCategory.getCategory())) continue;
            res.add(eventCategory.getCategory());
        }
        ArrayList<String> filtered = new ArrayList<String>(res);
        Collections.sort(filtered);
        return filtered;
    }

    private List<String> filter(List<EventCategoryTO> eventCategoryTOs, AuditElements.EventCategoryType type, String category) {
        HashSet<String> res = new HashSet<String>();
        for (EventCategoryTO eventCategory : eventCategoryTOs) {
            if (type != eventCategory.getType() || !StringUtils.equals((CharSequence)category, (CharSequence)eventCategory.getCategory()) || !StringUtils.isNotEmpty((CharSequence)eventCategory.getSubcategory())) continue;
            res.add(eventCategory.getSubcategory());
        }
        ArrayList<String> filtered = new ArrayList<String>(res);
        Collections.sort(filtered);
        return filtered;
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof ChangeCategoryEvent) {
            this.eventCategoryTO.getEvents().clear();
            ChangeCategoryEvent change = (ChangeCategoryEvent)event.getPayload();
            Panel changedPanel = change.getChangedPanel();
            if ("type".equals(changedPanel.getId())) {
                this.eventCategoryTO.setType((AuditElements.EventCategoryType)this.type.getModelObject());
                this.eventCategoryTO.setCategory(null);
                this.eventCategoryTO.setSubcategory(null);
                if (this.type.getModelObject() == AuditElements.EventCategoryType.CUSTOM) {
                    this.category.setChoices(Collections.emptyList());
                    this.subcategory.setChoices(Collections.emptyList());
                    this.category.setEnabled(false);
                    this.subcategory.setEnabled(false);
                    this.custom.setVisible(true);
                    this.custom.setEnabled(true);
                    this.actionPanel.setVisible(true);
                    this.actionPanel.setEnabled(true);
                } else {
                    this.category.setChoices(this.filter(this.eventCategoryTOs, (AuditElements.EventCategoryType)this.type.getModelObject()));
                    this.subcategory.setChoices(Collections.emptyList());
                    this.category.setEnabled(true);
                    this.subcategory.setEnabled(true);
                    this.custom.setVisible(false);
                    this.custom.setEnabled(false);
                    this.actionPanel.setVisible(false);
                    this.actionPanel.setEnabled(false);
                }
                change.getTarget().add(new Component[]{this.categoryContainer});
            } else if ("category".equals(changedPanel.getId())) {
                this.subcategory.setChoices(this.filter(this.eventCategoryTOs, (AuditElements.EventCategoryType)this.type.getModelObject(), (String)this.category.getModelObject()));
                this.eventCategoryTO.setCategory((String)this.category.getModelObject());
                this.eventCategoryTO.setSubcategory(null);
                change.getTarget().add(new Component[]{this.categoryContainer});
            } else {
                this.eventCategoryTO.setSubcategory((String)this.subcategory.getModelObject());
            }
            this.updateEventsContainer(change.getTarget());
        } else if (event.getPayload() instanceof SelectedEventsPanel.InspectSelectedEvent) {
            this.eventCategoryTO.getEvents().clear();
            SelectedEventsPanel.InspectSelectedEvent inspectSelectedEvent = (SelectedEventsPanel.InspectSelectedEvent)event.getPayload();
            Map.Entry categoryEvent = LoggerEventUtils.parseEventCategory((String)inspectSelectedEvent.getEvent());
            this.eventCategoryTO.setType(((EventCategoryTO)categoryEvent.getKey()).getType());
            this.category.setChoices(this.filter(this.eventCategoryTOs, (AuditElements.EventCategoryType)this.type.getModelObject()));
            this.eventCategoryTO.setCategory(((EventCategoryTO)categoryEvent.getKey()).getCategory());
            this.subcategory.setChoices(this.filter(this.eventCategoryTOs, (AuditElements.EventCategoryType)this.type.getModelObject(), (String)this.category.getModelObject()));
            this.eventCategoryTO.setSubcategory(((EventCategoryTO)categoryEvent.getKey()).getSubcategory());
            if (((EventCategoryTO)categoryEvent.getKey()).getType() == AuditElements.EventCategoryType.CUSTOM) {
                this.custom.setModelObject((Object)LoggerEventUtils.buildEvent((AuditElements.EventCategoryType)((EventCategoryTO)categoryEvent.getKey()).getType(), (String)((EventCategoryTO)categoryEvent.getKey()).getCategory(), (String)((EventCategoryTO)categoryEvent.getKey()).getSubcategory(), (String)(((EventCategoryTO)categoryEvent.getKey()).getEvents().isEmpty() ? "" : (String)((EventCategoryTO)categoryEvent.getKey()).getEvents().iterator().next()), (AuditElements.Result)((AuditElements.Result)categoryEvent.getValue())));
                this.category.setEnabled(false);
                this.subcategory.setEnabled(false);
                this.custom.setVisible(true);
                this.custom.setEnabled(true);
                this.actionPanel.setVisible(true);
                this.actionPanel.setEnabled(true);
            } else {
                this.category.setEnabled(true);
                this.subcategory.setEnabled(true);
                this.custom.setVisible(false);
                this.custom.setEnabled(false);
                this.actionPanel.setVisible(false);
                this.actionPanel.setEnabled(false);
            }
            inspectSelectedEvent.getTarget().add(new Component[]{this.categoryContainer});
            this.updateEventsContainer(inspectSelectedEvent.getTarget());
        }
    }

    private void setEvents() {
        Iterator itor = this.eventCategoryTOs.iterator();
        while (itor.hasNext() && this.eventCategoryTO.getEvents().isEmpty()) {
            EventCategoryTO eventCategory = (EventCategoryTO)itor.next();
            if (eventCategory.getType() != this.eventCategoryTO.getType() || !StringUtils.equals((CharSequence)eventCategory.getCategory(), (CharSequence)this.eventCategoryTO.getCategory()) || !StringUtils.equals((CharSequence)eventCategory.getSubcategory(), (CharSequence)this.eventCategoryTO.getSubcategory())) continue;
            this.eventCategoryTO.getEvents().addAll(eventCategory.getEvents());
        }
    }

    protected void onEventAction(IEvent<?> event) {
    }

    private void authorizeList() {
        for (String role : this.getListRoles()) {
            MetaDataRoleAuthorizationStrategy.authorize((Component)this.selectedEventsPanel, (Action)RENDER, (String)role);
        }
    }

    private void authorizeChanges() {
        for (String role : this.getChangeRoles()) {
            MetaDataRoleAuthorizationStrategy.authorize((Component)this.categoryContainer, (Action)RENDER, (String)role);
            MetaDataRoleAuthorizationStrategy.authorize((Component)this.eventsContainer, (Action)RENDER, (String)role);
        }
    }

    private void updateEventsContainer(AjaxRequestTarget target) {
        this.setEvents();
        this.eventsContainer.addOrReplace(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        target.add(new Component[]{this.eventsContainer});
    }

    protected abstract String[] getListRoles();

    protected abstract String[] getChangeRoles();

    static /* synthetic */ AjaxDropDownChoicePanel access$000(LoggerCategoryPanel x0) {
        return x0.type;
    }

    static /* synthetic */ AjaxDropDownChoicePanel access$100(LoggerCategoryPanel x0) {
        return x0.category;
    }

    static /* synthetic */ AjaxDropDownChoicePanel access$200(LoggerCategoryPanel x0) {
        return x0.subcategory;
    }

    static /* synthetic */ AjaxTextFieldPanel access$300(LoggerCategoryPanel x0) {
        return x0.custom;
    }

    static /* synthetic */ WebMarkupContainer access$400(LoggerCategoryPanel x0) {
        return x0.categoryContainer;
    }
}

