/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.console.commons.JexlHelpUtil;
import org.apache.syncope.console.pages.panels.RoleDetailsPanel;
import org.apache.syncope.console.rest.RoleRestClient;
import org.apache.syncope.console.rest.UserRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleDetailsPanel
extends Panel {
    private static final long serialVersionUID = 855618618337931784L;
    protected static final Logger LOG = LoggerFactory.getLogger(RoleDetailsPanel.class);
    @SpringBean
    private UserRestClient userRestClient;
    @SpringBean
    private RoleRestClient roleRestClient;
    private final Fragment parentFragment;
    private final WebMarkupContainer ownerContainer = new WebMarkupContainer("ownerContainer");
    private final OwnerModel userOwnerModel;
    private final OwnerModel roleOwnerModel;
    private ParentModel parentModel;

    public RoleDetailsPanel(String id, RoleTO roleTO, boolean templateMode) {
        super(id);
        this.ownerContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.ownerContainer});
        ModalWindow userOwnerSelectWin = new ModalWindow("userOwnerSelectWin");
        userOwnerSelectWin.setCssClassName("w_silver");
        userOwnerSelectWin.setCookieName("create-userOwnerSelect-modal");
        this.add(new Component[]{userOwnerSelectWin});
        ModalWindow roleOwnerSelectWin = new ModalWindow("roleOwnerSelectWin");
        roleOwnerSelectWin.setCssClassName("w_silver");
        roleOwnerSelectWin.setCookieName("create-roleOwnerSelect-modal");
        this.add(new Component[]{roleOwnerSelectWin});
        ModalWindow parentSelectWin = new ModalWindow("parentSelectWin");
        parentSelectWin.setCssClassName("w_silver");
        parentSelectWin.setCookieName("create-parentSelect-modal");
        this.add(new Component[]{parentSelectWin});
        if (templateMode) {
            this.parentFragment = new Fragment("parent", "parentFragment", (MarkupContainer)this);
            this.parentModel = new ParentModel(this, roleTO);
            AjaxTextFieldPanel parent = new AjaxTextFieldPanel("parent", "parent", (IModel)this.parentModel);
            parent.setReadOnly(true);
            parent.setOutputMarkupId(true);
            this.parentFragment.add(new Component[]{parent});
            1 parentSelect = new /* Unavailable Anonymous Inner Class!! */;
            this.parentFragment.add(new Component[]{parentSelect});
            2 parentReset = new /* Unavailable Anonymous Inner Class!! */;
            this.parentFragment.add(new Component[]{parentReset});
        } else {
            this.parentFragment = new Fragment("parent", "emptyFragment", (MarkupContainer)this);
        }
        this.parentFragment.setOutputMarkupId(true);
        this.add(new Component[]{this.parentFragment});
        AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", "name", (IModel)new PropertyModel((Object)roleTO, "name"));
        WebMarkupContainer jexlHelp = JexlHelpUtil.getJexlHelpWebContainer((String)"jexlHelp");
        AjaxLink questionMarkJexlHelp = JexlHelpUtil.getAjaxLink((WebMarkupContainer)jexlHelp, (String)"questionMarkJexlHelp");
        this.add(new Component[]{questionMarkJexlHelp});
        questionMarkJexlHelp.add(new Component[]{jexlHelp});
        if (!templateMode) {
            name.addRequiredLabel();
            questionMarkJexlHelp.setVisible(false);
        }
        this.add(new Component[]{name});
        this.userOwnerModel = new OwnerModel(this, roleTO, AttributableType.USER);
        AjaxTextFieldPanel userOwner = new AjaxTextFieldPanel("userOwner", "userOwner", (IModel)this.userOwnerModel);
        userOwner.setReadOnly(true);
        userOwner.setOutputMarkupId(true);
        this.ownerContainer.add(new Component[]{userOwner});
        3 userOwnerSelect = new /* Unavailable Anonymous Inner Class!! */;
        this.ownerContainer.add(new Component[]{userOwnerSelect});
        4 userOwnerReset = new /* Unavailable Anonymous Inner Class!! */;
        this.ownerContainer.add(new Component[]{userOwnerReset});
        this.roleOwnerModel = new OwnerModel(this, roleTO, AttributableType.ROLE);
        AjaxTextFieldPanel roleOwner = new AjaxTextFieldPanel("roleOwner", "roleOwner", (IModel)this.roleOwnerModel);
        roleOwner.setReadOnly(true);
        roleOwner.setOutputMarkupId(true);
        this.ownerContainer.add(new Component[]{roleOwner});
        5 roleOwnerSelect = new /* Unavailable Anonymous Inner Class!! */;
        this.ownerContainer.add(new Component[]{roleOwnerSelect});
        6 roleOwnerReset = new /* Unavailable Anonymous Inner Class!! */;
        this.ownerContainer.add(new Component[]{roleOwnerReset});
        AjaxCheckBoxPanel inhOwner = new AjaxCheckBoxPanel("inheritOwner", "inheritOwner", (IModel)new PropertyModel((Object)roleTO, "inheritOwner"));
        this.add(new Component[]{inhOwner});
        AjaxCheckBoxPanel inhTemplates = new AjaxCheckBoxPanel("inheritTemplates", "inheritTemplates", (IModel)new PropertyModel((Object)roleTO, "inheritTemplates"));
        inhTemplates.getField().add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{inhTemplates});
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof ParentSelectPayload) {
            this.parentModel.setObject((Object)((ParentSelectPayload)event.getPayload()).getRoleId());
        }
        if (event.getPayload() instanceof UserOwnerSelectPayload) {
            this.userOwnerModel.setObject((Object)((UserOwnerSelectPayload)event.getPayload()).getUserId());
        }
        if (event.getPayload() instanceof RoleOwnerSelectPayload) {
            this.roleOwnerModel.setObject((Object)((RoleOwnerSelectPayload)event.getPayload()).getRoleId());
        }
        if (event.getPayload() instanceof AjaxRequestTarget) {
            ((AjaxRequestTarget)event.getPayload()).add(new Component[]{this.parentFragment});
            ((AjaxRequestTarget)event.getPayload()).add(new Component[]{this.ownerContainer});
        }
    }

    static /* synthetic */ ParentModel access$000(RoleDetailsPanel x0) {
        return x0.parentModel;
    }

    static /* synthetic */ OwnerModel access$100(RoleDetailsPanel x0) {
        return x0.userOwnerModel;
    }

    static /* synthetic */ OwnerModel access$200(RoleDetailsPanel x0) {
        return x0.roleOwnerModel;
    }

    static /* synthetic */ UserRestClient access$300(RoleDetailsPanel x0) {
        return x0.userRestClient;
    }

    static /* synthetic */ RoleRestClient access$400(RoleDetailsPanel x0) {
        return x0.roleRestClient;
    }
}

