/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.syncope.common.mod.StatusMod;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.AbstractSubjectTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.console.commons.status.ConnObjectWrapper;
import org.apache.syncope.console.commons.status.Status;
import org.apache.syncope.console.commons.status.StatusBean;
import org.apache.syncope.console.commons.status.StatusUtils;
import org.apache.syncope.console.rest.AbstractSubjectRestClient;
import org.apache.syncope.console.rest.RoleRestClient;
import org.apache.syncope.console.rest.UserRestClient;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.CheckGroupSelector;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusPanel
extends Panel
implements IHeaderContributor {
    private static final Logger LOG = LoggerFactory.getLogger(StatusPanel.class);
    private static final long serialVersionUID = -4064294905566247728L;
    public static final String IMG_STATUES = "../statuses/";
    private static final int CONNOBJECT_WIN_HEIGHT = 400;
    private static final int CONNOBJECT_WIN_WIDTH = 600;
    @SpringBean
    private UserRestClient userRestClient;
    @SpringBean
    private RoleRestClient roleRestClient;
    private final ModalWindow connObjectWin = new ModalWindow("connObjectWin");
    private final List<ConnObjectWrapper> connObjects;
    private final Map<String, StatusBean> initialStatusBeanMap;
    private final CheckGroup<StatusBean> checkGroup;
    private final ListView<StatusBean> statusBeansListView;
    private final StatusUtils statusUtils;

    public <T extends AbstractAttributableTO> StatusPanel(String id, AbstractSubjectTO subject, List<StatusBean> selectedResources, PageReference pageref) {
        super(id);
        this.connObjectWin.setCssClassName("w_silver");
        this.connObjectWin.setInitialHeight(400);
        this.connObjectWin.setInitialWidth(600);
        this.connObjectWin.setCookieName("connobject-modal");
        this.add(new Component[]{this.connObjectWin});
        this.statusUtils = new StatusUtils((AbstractSubjectRestClient)(subject instanceof RoleTO ? this.roleRestClient : this.userRestClient));
        this.connObjects = this.statusUtils.getConnectorObjects(subject);
        ArrayList<StatusBean> statusBeans = new ArrayList<StatusBean>(this.connObjects.size() + 1);
        this.initialStatusBeanMap = new LinkedHashMap(this.connObjects.size() + 1);
        StatusBean syncope = new StatusBean((AbstractAttributableTO)subject, "syncope");
        if (subject instanceof UserTO) {
            syncope.setAccountLink(((UserTO)subject).getUsername());
            Object syncopeStatus = Status.UNDEFINED;
            if (((UserTO)subject).getStatus() != null) {
                try {
                    syncopeStatus = Status.valueOf((String)((UserTO)subject).getStatus().toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Unexpected status found: {}", (Object)((UserTO)subject).getStatus(), (Object)e);
                }
            }
            syncope.setStatus((Status)syncopeStatus);
        } else if (subject instanceof RoleTO) {
            syncope.setAccountLink(((RoleTO)subject).getDisplayName());
            syncope.setStatus(Status.ACTIVE);
        }
        statusBeans.add(syncope);
        this.initialStatusBeanMap.put(syncope.getResourceName(), syncope);
        for (ConnObjectWrapper entry : this.connObjects) {
            StatusBean statusBean = this.statusUtils.getStatusBean(entry.getAttributable(), entry.getResourceName(), entry.getConnObjectTO(), subject instanceof RoleTO);
            this.initialStatusBeanMap.put(entry.getResourceName(), statusBean);
            statusBeans.add(statusBean);
        }
        this.checkGroup = new CheckGroup("group", selectedResources);
        this.checkGroup.setOutputMarkupId(true);
        this.checkGroup.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{this.checkGroup});
        CheckGroupSelector groupSelector = new CheckGroupSelector("groupselector", this.checkGroup);
        if (subject instanceof RoleTO) {
            groupSelector.setVisible(false);
        }
        this.add(new Component[]{groupSelector});
        this.statusBeansListView = new /* Unavailable Anonymous Inner Class!! */;
        this.statusBeansListView.setReuseItems(true);
        this.checkGroup.add(new Component[]{this.statusBeansListView});
    }

    public StatusMod getStatusMod() {
        StatusMod result = new StatusMod();
        Collection statusBeans = (Collection)this.checkGroup.getModel().getObject();
        if (statusBeans != null && !statusBeans.isEmpty()) {
            result = StatusUtils.buildStatusMod((Collection)statusBeans);
        }
        return result;
    }

    public List<StatusBean> getStatusBeans() {
        return this.statusBeansListView.getModelObject();
    }

    public Map<String, StatusBean> getInitialStatusBeanMap() {
        return this.initialStatusBeanMap;
    }

    public void updateStatusBeans(List<StatusBean> statusBeans) {
        this.statusBeansListView.removeAll();
        this.statusBeansListView.getModelObject().clear();
        this.statusBeansListView.getModelObject().addAll(statusBeans);
        for (StatusBean statusBean : statusBeans) {
            if (((Collection)this.checkGroup.getModelObject()).contains(statusBean) || statusBean.getStatus() != Status.NOT_YET_SUBMITTED) continue;
            ((Collection)this.checkGroup.getModelObject()).add(statusBean);
        }
    }

    static /* synthetic */ StatusUtils access$000(StatusPanel x0) {
        return x0.statusUtils;
    }

    static /* synthetic */ CheckGroup access$100(StatusPanel x0) {
        return x0.checkGroup;
    }

    static /* synthetic */ List access$200(StatusPanel x0) {
        return x0.connObjects;
    }

    static /* synthetic */ ModalWindow access$300(StatusPanel x0) {
        return x0.connObjectWin;
    }
}

