/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.resources;

import java.io.File;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemResource
extends AbstractResource {
    private static final long serialVersionUID = -4791087117785935198L;
    private static final Logger LOG = LoggerFactory.getLogger(FilesystemResource.class);
    private final String baseCtx;
    private final String basePath;

    public FilesystemResource(String baseCtx, String basePath) {
        this.baseCtx = baseCtx;
        this.basePath = basePath;
    }

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        File baseDir = new File(this.basePath);
        if (baseDir.exists() && baseDir.canRead() && baseDir.isDirectory()) {
            String reqPath = attributes.getRequest().getUrl().getPath();
            String subPath = reqPath.substring(reqPath.indexOf(this.baseCtx) + this.baseCtx.length()).replace('/', File.separatorChar);
            LOG.debug("Request for {}", (Object)subPath);
            response.setWriteCallback((AbstractResource.WriteCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            LOG.error("{} not found, not readable or not a directory", (Object)this.basePath);
        }
        return response;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

