/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.rest;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.syncope.common.services.LoggerService;
import org.apache.syncope.common.to.EventCategoryTO;
import org.apache.syncope.common.to.LoggerTO;
import org.apache.syncope.common.types.AuditLoggerName;
import org.apache.syncope.common.types.LoggerLevel;
import org.apache.syncope.common.types.LoggerType;
import org.apache.syncope.common.util.CollectionWrapper;
import org.apache.syncope.console.rest.BaseRestClient;
import org.springframework.stereotype.Component;

@Component
public class LoggerRestClient
extends BaseRestClient {
    private static final long serialVersionUID = 4579786978763032240L;

    public List<LoggerTO> listLogs() {
        return ((LoggerService)this.getService(LoggerService.class)).list(LoggerType.LOG);
    }

    public List<AuditLoggerName> listAudits() {
        return CollectionWrapper.wrapLogger((Collection)((LoggerService)this.getService(LoggerService.class)).list(LoggerType.AUDIT));
    }

    public Map<String, Set<AuditLoggerName>> listAuditsByCategory() {
        HashMap<String, Set<AuditLoggerName>> result = new HashMap<String, Set<AuditLoggerName>>();
        for (AuditLoggerName auditLoggerName : this.listAudits()) {
            if (!result.containsKey(auditLoggerName.getCategory())) {
                result.put(auditLoggerName.getCategory(), new HashSet());
            }
            ((Set)result.get(auditLoggerName.getCategory())).add(auditLoggerName);
        }
        return result;
    }

    public void setLogLevel(String name, LoggerLevel level) {
        LoggerTO loggerTO = new LoggerTO();
        loggerTO.setName(name);
        loggerTO.setLevel(level);
        ((LoggerService)this.getService(LoggerService.class)).update(LoggerType.LOG, name, loggerTO);
    }

    public void enableAudit(AuditLoggerName auditLoggerName) {
        String name = auditLoggerName.toLoggerName();
        LoggerTO loggerTO = new LoggerTO();
        loggerTO.setName(name);
        loggerTO.setLevel(LoggerLevel.DEBUG);
        ((LoggerService)this.getService(LoggerService.class)).update(LoggerType.AUDIT, name, loggerTO);
    }

    public void deleteLog(String name) {
        ((LoggerService)this.getService(LoggerService.class)).delete(LoggerType.LOG, name);
    }

    public void disableAudit(AuditLoggerName auditLoggerName) {
        ((LoggerService)this.getService(LoggerService.class)).delete(LoggerType.AUDIT, auditLoggerName.toLoggerName());
    }

    public List<EventCategoryTO> listEvents() {
        try {
            return ((LoggerService)this.getService(LoggerService.class)).events();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }
}

