/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.rest;

import java.io.InputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.services.WorkflowService;
import org.apache.syncope.common.types.SubjectType;
import org.apache.syncope.console.SyncopeSession;
import org.apache.syncope.console.rest.BaseRestClient;
import org.springframework.stereotype.Component;

@Component
public class WorkflowRestClient
extends BaseRestClient {
    private static final long serialVersionUID = 5049285686167071017L;

    private WorkflowService getService(MediaType mediaType) {
        return (WorkflowService)SyncopeSession.get().getService(mediaType, WorkflowService.class);
    }

    public InputStream getDefinition(MediaType mediaType) {
        Response response = this.getService(mediaType).exportDefinition(SubjectType.USER);
        return (InputStream)response.getEntity();
    }

    public byte[] getDiagram() {
        byte[] diagram;
        WorkflowService service = (WorkflowService)this.getService(WorkflowService.class);
        WebClient.client((Object)service).accept(new String[]{"image/png"});
        Response response = service.exportDiagram(SubjectType.USER);
        try {
            diagram = IOUtils.readBytesFromStream((InputStream)((InputStream)response.getEntity()));
        }
        catch (Exception e) {
            LOG.error("Could not get workflow diagram", (Throwable)e);
            diagram = new byte[]{};
        }
        return diagram;
    }

    public boolean isActivitiEnabledForUsers() {
        Boolean result = null;
        try {
            result = SyncopeSession.get().isActivitiEnabledFor(SubjectType.USER);
        }
        catch (SyncopeClientException e) {
            LOG.error("While seeking if Activiti is enabled for users", (Throwable)e);
        }
        return result == null ? false : result;
    }

    public void updateDefinition(MediaType mediaType, String definition) {
        this.getService(mediaType).importDefinition(SubjectType.USER, definition);
    }
}

