/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.wicket.markup.html.form;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.console.SyncopeSession;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDoubleFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.FieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class AjaxDoubleFieldPanel
extends FieldPanel<Double> {
    private static final long serialVersionUID = 935151916638207380L;
    private static final Pattern ENGLISH_DOUBLE_PATTERN = Pattern.compile("\\d+\\.\\d+");
    private static final Pattern OTHER_DOUBLE_PATTERN = Pattern.compile("\\d+,\\d+");
    private final String name;
    private final Pattern pattern;
    private final DecimalFormat englishDf;
    private final DecimalFormat localeDf;

    public AjaxDoubleFieldPanel(String id, String name, String conversionPattern, IModel<Double> model) {
        super(id, model);
        this.name = name;
        this.pattern = SyncopeSession.get().getLocale().equals(Locale.ENGLISH) ? ENGLISH_DOUBLE_PATTERN : OTHER_DOUBLE_PATTERN;
        this.englishDf = new DecimalFormat();
        this.englishDf.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        if (StringUtils.isNotBlank((CharSequence)conversionPattern)) {
            this.englishDf.applyPattern(conversionPattern);
        }
        this.localeDf = new DecimalFormat();
        this.localeDf.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(SyncopeSession.get().getLocale()));
        if (StringUtils.isNotBlank((CharSequence)conversionPattern)) {
            this.localeDf.applyPattern(conversionPattern);
        }
        this.field = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{this.field.setLabel((IModel)new Model((Serializable)((Object)name))).setOutputMarkupId(true)});
        if (!this.isReadOnly()) {
            this.field.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        }
    }

    public FieldPanel<Double> addRequiredLabel() {
        if (!this.isRequired()) {
            this.setRequired(true);
        }
        this.isRequiredLabelAdded = true;
        return this;
    }

    public FieldPanel<Double> setNewModel(List<Serializable> list) {
        this.setNewModel((IModel)new /* Unavailable Anonymous Inner Class!! */);
        return this;
    }

    public FieldPanel<Double> setNewModel(ListItem item) {
        4 model = new /* Unavailable Anonymous Inner Class!! */;
        this.field.setModel((IModel)model);
        return this;
    }

    static /* synthetic */ Pattern access$000(AjaxDoubleFieldPanel x0) {
        return x0.pattern;
    }

    static /* synthetic */ DecimalFormat access$100(AjaxDoubleFieldPanel x0) {
        return x0.localeDf;
    }

    static /* synthetic */ DecimalFormat access$200(AjaxDoubleFieldPanel x0) {
        return x0.englishDf;
    }

    static /* synthetic */ String access$300(AjaxDoubleFieldPanel x0) {
        return x0.name;
    }
}

