/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.wicket.markup.html.form;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.apache.syncope.console.wicket.markup.html.form.FieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class SpinnerFieldPanel<T extends Number>
extends FieldPanel<T> {
    private static final long serialVersionUID = 6413819574530703577L;
    private final String name;
    private final Class<T> reference;
    private final IModel<T> model;
    private final T min;
    private final T max;

    public SpinnerFieldPanel(String id, String name, Class<T> reference, IModel<T> model, T min, T max) {
        super(id, model);
        this.name = name;
        this.reference = reference;
        this.model = model;
        this.min = min;
        this.max = max;
        String uuid = UUID.randomUUID().toString();
        this.field = new TextField("spinnerField", model, reference);
        this.field.setMarkupId(uuid);
        this.add(new Component[]{this.field.setLabel((IModel)new Model((Serializable)((Object)name)))});
        if (!this.isReadOnly()) {
            this.field.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        }
        StringBuilder statements = new StringBuilder();
        statements.append("jQuery(function() {").append("var spinner = $('#").append(uuid).append("').spinner();").append("$('#").append(uuid).append("').spinner(").append("'option', 'stop', function(event, ui) { $(this).change(); });");
        if (this.min != null) {
            statements.append("$('#").append(uuid).append("').spinner(").append("'option', 'min', ").append(this.min).append(");");
        }
        if (this.max != null) {
            statements.append("$('#").append(uuid).append("').spinner(").append("'option', 'max', ").append(this.max).append(");");
        }
        statements.append("});");
        Label spinnerFieldJS = new Label("spinnerFieldJS", statements.toString());
        spinnerFieldJS.setEscapeModelStrings(false);
        this.add(new Component[]{spinnerFieldJS});
    }

    public SpinnerFieldPanel<T> setNewModel(List<Serializable> list) {
        this.setNewModel((IModel)new /* Unavailable Anonymous Inner Class!! */);
        return this;
    }

    public SpinnerFieldPanel<T> setNewModel(ListItem item) {
        this.field.setModel((IModel)new /* Unavailable Anonymous Inner Class!! */);
        return this;
    }

    public SpinnerFieldPanel<T> clone() {
        SpinnerFieldPanel panel = new SpinnerFieldPanel(this.getId(), this.name, this.reference, this.model, this.min, this.max);
        panel.setRequired(this.isRequired());
        panel.setReadOnly(this.isReadOnly());
        panel.setTitle(this.title);
        if (this.isRequiredLabelAdded) {
            panel.addRequiredLabel();
        }
        return panel;
    }

    static /* synthetic */ Class access$000(SpinnerFieldPanel x0) {
        return x0.reference;
    }
}

