/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.wicket.markup.html.form.preview;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.syncope.console.preview.BinaryPreview;
import org.apache.syncope.console.wicket.markup.html.form.preview.AbstractBinaryPreviewer;
import org.apache.syncope.console.wicket.markup.html.form.preview.BinaryPDFPreviewer;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.image.NonCachingImage;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.io.IOUtils;

@BinaryPreview(mimeTypes={"application/pdf"})
public class BinaryPDFPreviewer
extends AbstractBinaryPreviewer {
    private static final long serialVersionUID = 7743389062928086373L;
    private static final int IMG_SIZE = 230;
    private static final int RESOLUTION = 96;
    private static final int IMAGE_TYPE = 1;
    private transient BufferedImage firstPage;

    public BinaryPDFPreviewer(String id, String mimeType, byte[] uploadedBytes) {
        super(id, mimeType, uploadedBytes);
    }

    public Component preview() {
        Fragment fragment;
        PDDocument document;
        block7: {
            this.firstPage = null;
            document = null;
            try {
                document = PDDocument.load((InputStream)new ByteArrayInputStream(this.uploadedBytes));
                if (document.isEncrypted()) {
                    LOG.info("Document is encrypted, no preview is possible");
                    break block7;
                }
                List pages = document.getDocumentCatalog().getAllPages();
                this.firstPage = ((PDPage)pages.get(0)).convertToImage(1, 96);
            }
            catch (IOException e) {
                try {
                    LOG.error("While generating thumbnail from first page", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(document);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)document);
            }
        }
        IOUtils.closeQuietly((Closeable)document);
        if (this.firstPage == null) {
            fragment = new Fragment("preview", "noPreviewFragment", (MarkupContainer)this);
        } else {
            fragment = new Fragment("preview", "previewFragment", (MarkupContainer)this);
            fragment.add(new Component[]{new NonCachingImage("previewImage", (IResource)new ThumbnailImageResource(this.firstPage))});
        }
        WebMarkupContainer previewContainer = new WebMarkupContainer("previewContainer");
        previewContainer.setOutputMarkupId(true);
        previewContainer.add(new Component[]{fragment});
        return this.addOrReplace(new Component[]{previewContainer});
    }
}

