/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra;

import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.keymaster.client.api.startstop.KeymasterStart;
import org.apache.syncope.common.keymaster.client.api.startstop.KeymasterStop;
import org.apache.syncope.sra.RouteProvider;
import org.apache.syncope.sra.SRAProperties;
import org.apache.syncope.sra.SyncopeSRAWebExceptionHandler;
import org.apache.syncope.sra.actuate.SRASessions;
import org.apache.syncope.sra.actuate.SyncopeCoreHealthIndicator;
import org.apache.syncope.sra.actuate.SyncopeSRAInfoContributor;
import org.apache.syncope.sra.security.CsrfRouteMatcher;
import org.apache.syncope.sra.security.LogoutRouteMatcher;
import org.apache.syncope.sra.security.PublicRouteMatcher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.web.server.WebExceptionHandler;
import reactor.core.publisher.Flux;

@SpringBootApplication(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SRAProperties.class})
public class SyncopeSRAApplication {
    public static void main(String[] args) {
        new SpringApplicationBuilder(new Class[]{SyncopeSRAApplication.class}).properties(new String[]{"spring.config.name:sra"}).build().run(args);
    }

    @Bean
    public LogoutRouteMatcher logoutRouteMatcher() {
        return new LogoutRouteMatcher();
    }

    @Bean
    public PublicRouteMatcher publicRouteMatcher() {
        return new PublicRouteMatcher();
    }

    @Bean
    public CsrfRouteMatcher csrfRouteMatcher(PublicRouteMatcher publicRouteMatcher) {
        return new CsrfRouteMatcher(publicRouteMatcher);
    }

    @ConditionalOnMissingBean
    @Bean
    public RouteProvider routeProvider(ConfigurableApplicationContext ctx, ServiceOps serviceOps, SRAProperties props) {
        return new RouteProvider(serviceOps, ctx, props.getAnonymousUser(), props.getAnonymousKey(), props.isUseGZIPCompression());
    }

    @ConditionalOnMissingBean
    @Bean
    public RouteLocator routes(@Qualifier(value="routeProvider") RouteProvider routeProvider) {
        return () -> Flux.fromIterable(routeProvider.fetch()).map(Route.AbstractBuilder::build);
    }

    @ConditionalOnMissingBean
    @Bean
    public SRASessions sraSessionsActuatorEndpoint(CacheManager cacheManager) {
        return new SRASessions(cacheManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public SyncopeCoreHealthIndicator syncopeCoreHealthIndicator(ServiceOps serviceOps, SRAProperties props) {
        return new SyncopeCoreHealthIndicator(serviceOps, props.getAnonymousUser(), props.getAnonymousKey(), props.isUseGZIPCompression());
    }

    @ConditionalOnMissingBean
    @Bean
    public SyncopeSRAInfoContributor syncopeSRAInfoContributor() {
        return new SyncopeSRAInfoContributor();
    }

    @Bean
    public KeymasterStart keymasterStart() {
        return new KeymasterStart(NetworkService.Type.SRA);
    }

    @Bean
    public KeymasterStop keymasterStop() {
        return new KeymasterStop(NetworkService.Type.SRA);
    }

    @Bean
    public WebExceptionHandler syncopeSRAWebExceptionHandler(@Qualifier(value="routeProvider") RouteProvider routeProvider, SRAProperties props) {
        return new SyncopeSRAWebExceptionHandler(routeProvider, props);
    }
}

