/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security.saml2;

import java.util.Optional;
import org.apache.syncope.sra.security.pac4j.NoOpSessionStore;
import org.apache.syncope.sra.security.pac4j.RedirectionActionUtils;
import org.apache.syncope.sra.security.pac4j.ServerWebExchangeContext;
import org.apache.syncope.sra.security.saml2.SAML2ServerLogoutSuccessHandler;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.http.OkAction;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.context.SAML2MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class SAML2LogoutResponseWebFilter
implements WebFilter {
    private static final Logger LOG = LoggerFactory.getLogger(SAML2LogoutResponseWebFilter.class);
    public static final ServerWebExchangeMatcher MATCHER = ServerWebExchangeMatchers.pathMatchers((String[])new String[]{"/logout/saml2/sso"});
    private final SAML2Client saml2Client;
    private final ServerLogoutSuccessHandler logoutSuccessHandler;
    private final CacheManager cacheManager;

    public SAML2LogoutResponseWebFilter(SAML2Client saml2Client, SAML2ServerLogoutSuccessHandler logoutSuccessHandler, CacheManager cacheManager) {
        this.saml2Client = saml2Client;
        this.logoutSuccessHandler = logoutSuccessHandler;
        this.cacheManager = cacheManager;
    }

    private Mono<Void> handleLogoutResponse(ServerWebExchange exchange, WebFilterChain chain, ServerWebExchangeContext swec) {
        try {
            SAML2MessageContext ctx = this.saml2Client.getContextProvider().buildContext(this.saml2Client, (WebContext)swec, (SessionStore)NoOpSessionStore.INSTANCE);
            this.saml2Client.getLogoutProfileHandler().receive(ctx);
        }
        catch (OkAction e) {
            LOG.debug("LogoutResponse was actually validated but no postLogoutURL was set", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Could not validate LogoutResponse", (Throwable)e);
        }
        return this.logoutSuccessHandler.onLogoutSuccess(new WebFilterExchange(exchange, chain), null);
    }

    private Mono<Void> handleLogoutRequest(ServerWebExchange exchange, WebFilterChain chain, ServerWebExchangeContext swec) {
        return exchange.getSession().switchIfEmpty(chain.filter(exchange).then(Mono.empty())).flatMap(session -> {
            this.cacheManager.getCache("default").evictIfPresent((Object)session.getId());
            return session.invalidate().then(Mono.defer(() -> {
                try {
                    this.saml2Client.getCredentialsExtractor().extract((WebContext)swec, (SessionStore)NoOpSessionStore.INSTANCE);
                }
                catch (RedirectionAction action) {
                    return RedirectionActionUtils.handle(action, swec);
                }
                return chain.filter(exchange).then(Mono.empty());
            }));
        });
    }

    private Mono<Void> handleGET(ServerWebExchange exchange, WebFilterChain chain) {
        if (exchange.getRequest().getQueryParams().getFirst((Object)"SAMLResponse") != null) {
            return this.handleLogoutResponse(exchange, chain, new ServerWebExchangeContext(exchange));
        }
        if (exchange.getRequest().getQueryParams().getFirst((Object)"SAMLRequest") != null) {
            return this.handleLogoutRequest(exchange, chain, new ServerWebExchangeLogoutContext(exchange));
        }
        return chain.filter(exchange).then(Mono.empty());
    }

    private Mono<Void> handlePOST(ServerWebExchange exchange, WebFilterChain chain) {
        return exchange.getFormData().flatMap(form -> {
            if (form.containsKey((Object)"SAMLResponse")) {
                return this.handleLogoutResponse(exchange, chain, new ServerWebExchangeContext(exchange).setForm((MultiValueMap<String, String>)form));
            }
            if (form.containsKey((Object)"SAMLRequest")) {
                return this.handleLogoutRequest(exchange, chain, new ServerWebExchangeLogoutContext(exchange).setForm((MultiValueMap<String, String>)form));
            }
            return chain.filter(exchange).then(Mono.empty());
        });
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return MATCHER.matches(exchange).filter(ServerWebExchangeMatcher.MatchResult::isMatch).switchIfEmpty(chain.filter(exchange).then(Mono.empty())).flatMap(matchResult -> exchange.getRequest().getMethod() == HttpMethod.GET ? this.handleGET(exchange, chain) : (exchange.getRequest().getMethod() == HttpMethod.POST ? this.handlePOST(exchange, chain) : Mono.error(() -> new UnsupportedOperationException("Unsupported HTTP method: " + exchange.getRequest().getMethod()))));
    }

    private static class ServerWebExchangeLogoutContext
    extends ServerWebExchangeContext {
        ServerWebExchangeLogoutContext(ServerWebExchange exchange) {
            super(exchange);
        }

        @Override
        public Optional<String> getRequestParameter(String name) {
            return "logoutendpoint".equals(name) ? Optional.of("true") : super.getRequestParameter(name);
        }
    }
}

