/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.bootstrap;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.attr.AttrRepoConf;
import org.apache.syncope.common.lib.auth.AuthModuleConf;
import org.apache.syncope.common.rest.api.service.AttrRepoService;
import org.apache.syncope.common.rest.api.service.AuthModuleService;
import org.apache.syncope.common.rest.api.service.wa.WAConfigService;
import org.apache.syncope.wa.bootstrap.AttrRepoPropertySourceMapper;
import org.apache.syncope.wa.bootstrap.AuthModulePropertySourceMapper;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Order
public class WAPropertySourceLocator
implements PropertySourceLocator {
    protected static final Logger LOG = LoggerFactory.getLogger(WAPropertySourceLocator.class);
    protected final WARestClient waRestClient;
    protected final AuthModulePropertySourceMapper authModulePropertySourceMapper;
    protected final AttrRepoPropertySourceMapper attrRepoPropertySourceMapper;

    public WAPropertySourceLocator(WARestClient waRestClient, AuthModulePropertySourceMapper authModulePropertySourceMapper, AttrRepoPropertySourceMapper attrRepoPropertySourceMapper) {
        this.waRestClient = waRestClient;
        this.authModulePropertySourceMapper = authModulePropertySourceMapper;
        this.attrRepoPropertySourceMapper = attrRepoPropertySourceMapper;
    }

    protected Map<String, Object> index(Map<String, Object> map, Map<String, Integer> prefixes) {
        String prefix;
        Map<String, Object> indexed = map;
        if (!map.isEmpty() && (prefix = map.keySet().iterator().next()).contains("[]")) {
            prefix = StringUtils.substringBefore((String)prefix, (String)"[]");
            Integer index = prefixes.getOrDefault(prefix, 0);
            indexed = map.entrySet().stream().map(e -> Pair.of((Object)((String)e.getKey()).replace("[]", "[" + index + "]"), e.getValue())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            prefixes.put(prefix, index + 1);
        }
        return indexed;
    }

    public PropertySource<?> locate(Environment environment) {
        SyncopeClient syncopeClient = this.waRestClient.getSyncopeClient();
        if (syncopeClient == null) {
            LOG.warn("Application context is not ready to bootstrap WA configuration");
            return null;
        }
        LOG.info("Bootstrapping WA configuration");
        TreeMap properties = new TreeMap();
        HashMap prefixes = new HashMap();
        ((AuthModuleService)syncopeClient.getService(AuthModuleService.class)).list().forEach(authModuleTO -> {
            LOG.debug("Mapping auth module {} ", (Object)authModuleTO.getKey());
            Map map = authModuleTO.getConf().map(authModuleTO, (AuthModuleConf.Mapper)this.authModulePropertySourceMapper);
            properties.putAll(this.index(map, prefixes));
        });
        ((AttrRepoService)syncopeClient.getService(AttrRepoService.class)).list().forEach(attrRepoTO -> {
            LOG.debug("Mapping attr repo {} ", (Object)attrRepoTO.getKey());
            Map map = attrRepoTO.getConf().map(attrRepoTO, (AttrRepoConf.Mapper)this.attrRepoPropertySourceMapper);
            properties.putAll(this.index(map, prefixes));
        });
        ((WAConfigService)syncopeClient.getService(WAConfigService.class)).list().forEach(attr -> properties.put(attr.getSchema(), attr.getValues().stream().collect(Collectors.joining(","))));
        LOG.debug("Collected WA properties: {}", properties);
        return new MapPropertySource(this.getClass().getName(), properties);
    }
}

