/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TimeZone;
import org.apache.tajo.ConfigKey;
import org.apache.tajo.OverridableConf;
import org.apache.tajo.SessionVars;
import org.apache.tajo.algebra.BetweenPredicate;
import org.apache.tajo.algebra.BinaryOperator;
import org.apache.tajo.algebra.BooleanLiteral;
import org.apache.tajo.algebra.CaseWhenPredicate;
import org.apache.tajo.algebra.CastExpr;
import org.apache.tajo.algebra.ColumnReferenceExpr;
import org.apache.tajo.algebra.CountRowsFunctionExpr;
import org.apache.tajo.algebra.DataTypeExpr;
import org.apache.tajo.algebra.DateLiteral;
import org.apache.tajo.algebra.DateValue;
import org.apache.tajo.algebra.ExistsPredicate;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.FunctionExpr;
import org.apache.tajo.algebra.GeneralSetFunctionExpr;
import org.apache.tajo.algebra.InPredicate;
import org.apache.tajo.algebra.IntervalLiteral;
import org.apache.tajo.algebra.IsNullPredicate;
import org.apache.tajo.algebra.LiteralValue;
import org.apache.tajo.algebra.NamedExpr;
import org.apache.tajo.algebra.NotExpr;
import org.apache.tajo.algebra.NullLiteral;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.algebra.PatternMatchPredicate;
import org.apache.tajo.algebra.SignedExpr;
import org.apache.tajo.algebra.TimeLiteral;
import org.apache.tajo.algebra.TimeValue;
import org.apache.tajo.algebra.TimestampLiteral;
import org.apache.tajo.algebra.ValueListExpr;
import org.apache.tajo.algebra.WindowFunctionExpr;
import org.apache.tajo.algebra.WindowSpec;
import org.apache.tajo.catalog.CatalogService;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.FunctionDesc;
import org.apache.tajo.catalog.exception.NoSuchFunctionException;
import org.apache.tajo.catalog.proto.CatalogProtos;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.DateDatum;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.datum.TimeDatum;
import org.apache.tajo.datum.TimestampDatum;
import org.apache.tajo.exception.InternalException;
import org.apache.tajo.exception.InvalidOperationException;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.LogicalPlanner;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.algebra.BaseAlgebraVisitor;
import org.apache.tajo.plan.expr.AggregationFunctionCallEval;
import org.apache.tajo.plan.expr.BetweenPredicateEval;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.CaseWhenEval;
import org.apache.tajo.plan.expr.CastEval;
import org.apache.tajo.plan.expr.ConstEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalTreeUtil;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.FieldEval;
import org.apache.tajo.plan.expr.GeneralFunctionEval;
import org.apache.tajo.plan.expr.InEval;
import org.apache.tajo.plan.expr.IsNullEval;
import org.apache.tajo.plan.expr.LikePredicateEval;
import org.apache.tajo.plan.expr.NotEval;
import org.apache.tajo.plan.expr.RegexPredicateEval;
import org.apache.tajo.plan.expr.RowConstantEval;
import org.apache.tajo.plan.expr.SignedEval;
import org.apache.tajo.plan.expr.SimilarToPredicateEval;
import org.apache.tajo.plan.expr.WindowFunctionEval;
import org.apache.tajo.plan.function.AggFunction;
import org.apache.tajo.plan.function.GeneralFunction;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.WindowSpec;
import org.apache.tajo.plan.nameresolver.NameResolver;
import org.apache.tajo.plan.nameresolver.NameResolvingMode;
import org.apache.tajo.util.Pair;
import org.apache.tajo.util.TUtil;
import org.apache.tajo.util.datetime.DateTimeUtil;
import org.apache.tajo.util.datetime.TimeMeta;

public class ExprAnnotator
extends BaseAlgebraVisitor<Context, EvalNode> {
    private CatalogService catalog;
    public static final Set<String> WINDOW_FUNCTIONS = Sets.newHashSet((Object[])new String[]{"row_number", "rank", "dense_rank", "percent_rank", "cume_dist", "first_value", "lag"});

    public ExprAnnotator(CatalogService catalog) {
        this.catalog = catalog;
    }

    public EvalNode createEvalNode(LogicalPlanner.PlanContext planContext, Expr expr, NameResolvingMode colRsvLevel) throws PlanningException {
        Context context = new Context(planContext, colRsvLevel);
        return planContext.evalOptimizer.optimize(planContext, (EvalNode)this.visit(context, new Stack<Expr>(), expr));
    }

    public static void assertEval(boolean condition, String message) throws PlanningException {
        if (!condition) {
            throw new PlanningException(message);
        }
    }

    private static Pair<EvalNode, EvalNode> convertTypesIfNecessary(Context ctx, EvalNode lhs, EvalNode rhs) {
        TajoDataTypes.Type lhsType = lhs.getValueType().getType();
        TajoDataTypes.Type rhsType = rhs.getValueType().getType();
        if (lhsType == TajoDataTypes.Type.NULL_TYPE || rhsType == TajoDataTypes.Type.NULL_TYPE) {
            return new Pair((Object)lhs, (Object)rhs);
        }
        TajoDataTypes.Type toBeCasted = (TajoDataTypes.Type)TUtil.getFromNestedMap((Map)CatalogUtil.OPERATION_CASTING_MAP, (Object)lhsType, (Object)rhsType);
        if (toBeCasted != null) {
            if (lhsType != toBeCasted) {
                lhs = ExprAnnotator.convertType(ctx, lhs, CatalogUtil.newSimpleDataType((TajoDataTypes.Type)toBeCasted));
            }
            if (rhsType != toBeCasted) {
                rhs = ExprAnnotator.convertType(ctx, rhs, CatalogUtil.newSimpleDataType((TajoDataTypes.Type)toBeCasted));
            }
        }
        return new Pair((Object)lhs, (Object)rhs);
    }

    private static EvalNode convertType(Context ctx, EvalNode evalNode, TajoDataTypes.DataType toType) {
        if (evalNode.getValueType().equals((Object)toType)) {
            return evalNode;
        }
        if (evalNode.getValueType().getType() == TajoDataTypes.Type.NULL_TYPE || toType.getType() == TajoDataTypes.Type.NULL_TYPE) {
            return evalNode;
        }
        if (evalNode.getType() == EvalType.BETWEEN) {
            BetweenPredicateEval between = (BetweenPredicateEval)evalNode;
            between.setPredicand(ExprAnnotator.convertType(ctx, between.getPredicand(), toType));
            between.setBegin(ExprAnnotator.convertType(ctx, between.getBegin(), toType));
            between.setEnd(ExprAnnotator.convertType(ctx, between.getEnd(), toType));
            return between;
        }
        if (evalNode.getType() == EvalType.CASE) {
            CaseWhenEval caseWhenEval = (CaseWhenEval)evalNode;
            for (CaseWhenEval.IfThenEval ifThen : caseWhenEval.getIfThenEvals()) {
                ifThen.setResult(ExprAnnotator.convertType(ctx, ifThen.getResult(), toType));
            }
            if (caseWhenEval.hasElse()) {
                caseWhenEval.setElseResult(ExprAnnotator.convertType(ctx, caseWhenEval.getElse(), toType));
            }
            return caseWhenEval;
        }
        if (evalNode.getType() == EvalType.ROW_CONSTANT) {
            RowConstantEval original = (RowConstantEval)evalNode;
            Datum[] datums = original.getValues();
            Datum[] convertedDatum = new Datum[datums.length];
            for (int i = 0; i < datums.length; ++i) {
                convertedDatum[i] = DatumFactory.cast((Datum)datums[i], (TajoDataTypes.DataType)toType, (TimeZone)ctx.timeZone);
            }
            RowConstantEval convertedRowConstant = new RowConstantEval(convertedDatum);
            return convertedRowConstant;
        }
        if (evalNode.getType() == EvalType.CONST) {
            ConstEval original = (ConstEval)evalNode;
            ConstEval newConst = new ConstEval(DatumFactory.cast((Datum)original.getValue(), (TajoDataTypes.DataType)toType, (TimeZone)ctx.timeZone));
            return newConst;
        }
        return new CastEval(ctx.queryContext, evalNode, toType);
    }

    @Override
    public EvalNode visitAnd(Context ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        stack.push((Expr)expr);
        EvalNode left = (EvalNode)this.visit(ctx, stack, expr.getLeft());
        EvalNode right = (EvalNode)this.visit(ctx, stack, expr.getRight());
        stack.pop();
        return new BinaryEval(EvalType.AND, left, right);
    }

    @Override
    public EvalNode visitOr(Context ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        stack.push((Expr)expr);
        EvalNode left = (EvalNode)this.visit(ctx, stack, expr.getLeft());
        EvalNode right = (EvalNode)this.visit(ctx, stack, expr.getRight());
        stack.pop();
        return new BinaryEval(EvalType.OR, left, right);
    }

    @Override
    public EvalNode visitNot(Context ctx, Stack<Expr> stack, NotExpr expr) throws PlanningException {
        stack.push((Expr)expr);
        EvalNode child = (EvalNode)this.visit(ctx, stack, expr.getChild());
        stack.pop();
        return new NotEval(child);
    }

    @Override
    public EvalNode visitEquals(Context ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitCommonComparison(ctx, stack, expr);
    }

    @Override
    public EvalNode visitNotEquals(Context ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitCommonComparison(ctx, stack, expr);
    }

    @Override
    public EvalNode visitLessThan(Context ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitCommonComparison(ctx, stack, expr);
    }

    @Override
    public EvalNode visitLessThanOrEquals(Context ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitCommonComparison(ctx, stack, expr);
    }

    @Override
    public EvalNode visitGreaterThan(Context ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitCommonComparison(ctx, stack, expr);
    }

    @Override
    public EvalNode visitGreaterThanOrEquals(Context ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitCommonComparison(ctx, stack, expr);
    }

    public EvalNode visitCommonComparison(Context ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        EvalType evalType;
        stack.push((Expr)expr);
        EvalNode left = (EvalNode)this.visit(ctx, stack, expr.getLeft());
        EvalNode right = (EvalNode)this.visit(ctx, stack, expr.getRight());
        stack.pop();
        switch (expr.getType()) {
            case Equals: {
                evalType = EvalType.EQUAL;
                break;
            }
            case NotEquals: {
                evalType = EvalType.NOT_EQUAL;
                break;
            }
            case LessThan: {
                evalType = EvalType.LTH;
                break;
            }
            case LessThanOrEquals: {
                evalType = EvalType.LEQ;
                break;
            }
            case GreaterThan: {
                evalType = EvalType.GTH;
                break;
            }
            case GreaterThanOrEquals: {
                evalType = EvalType.GEQ;
                break;
            }
            default: {
                throw new IllegalStateException("Wrong Expr Type: " + expr.getType());
            }
        }
        return ExprAnnotator.createBinaryNode(ctx, evalType, left, right);
    }

    @Override
    public EvalNode visitBetween(Context ctx, Stack<Expr> stack, BetweenPredicate between) throws PlanningException {
        stack.push((Expr)between);
        EvalNode predicand = (EvalNode)this.visit(ctx, stack, between.predicand());
        EvalNode begin = (EvalNode)this.visit(ctx, stack, between.begin());
        EvalNode end = (EvalNode)this.visit(ctx, stack, between.end());
        stack.pop();
        TajoDataTypes.DataType widestType = null;
        try {
            widestType = CatalogUtil.getWidestType((TajoDataTypes.DataType[])new TajoDataTypes.DataType[]{predicand.getValueType(), begin.getValueType(), end.getValueType()});
        }
        catch (InvalidOperationException ioe) {
            throw new PlanningException((Exception)((Object)ioe));
        }
        BetweenPredicateEval betweenEval = new BetweenPredicateEval(between.isNot(), between.isSymmetric(), predicand, begin, end);
        betweenEval = (BetweenPredicateEval)ExprAnnotator.convertType(ctx, betweenEval, widestType);
        return betweenEval;
    }

    @Override
    public EvalNode visitCaseWhen(Context ctx, Stack<Expr> stack, CaseWhenPredicate caseWhen) throws PlanningException {
        CaseWhenEval caseWhenEval = new CaseWhenEval();
        for (CaseWhenPredicate.WhenExpr when : caseWhen.getWhens()) {
            EvalNode condition = (EvalNode)this.visit(ctx, stack, when.getCondition());
            EvalNode result = (EvalNode)this.visit(ctx, stack, when.getResult());
            caseWhenEval.addIfCond(condition, result);
        }
        if (caseWhen.hasElseResult()) {
            caseWhenEval.setElseResult((EvalNode)this.visit(ctx, stack, caseWhen.getElseResult()));
        }
        TajoDataTypes.DataType widestType = caseWhenEval.getIfThenEvals().get(0).getResult().getValueType();
        for (int i = 1; i < caseWhenEval.getIfThenEvals().size(); ++i) {
            widestType = CatalogUtil.getWidestType((TajoDataTypes.DataType[])new TajoDataTypes.DataType[]{caseWhenEval.getIfThenEvals().get(i).getResult().getValueType(), widestType});
        }
        if (caseWhen.hasElseResult()) {
            widestType = CatalogUtil.getWidestType((TajoDataTypes.DataType[])new TajoDataTypes.DataType[]{widestType, caseWhenEval.getElse().getValueType()});
        }
        ExprAnnotator.assertEval(widestType != null, "Invalid Type Conversion for CaseWhen");
        caseWhenEval = (CaseWhenEval)ExprAnnotator.convertType(ctx, caseWhenEval, widestType);
        return caseWhenEval;
    }

    @Override
    public EvalNode visitIsNullPredicate(Context ctx, Stack<Expr> stack, IsNullPredicate expr) throws PlanningException {
        stack.push((Expr)expr);
        EvalNode child = (EvalNode)this.visit(ctx, stack, expr.getPredicand());
        stack.pop();
        return new IsNullEval(expr.isNot(), child);
    }

    @Override
    public EvalNode visitInPredicate(Context ctx, Stack<Expr> stack, InPredicate expr) throws PlanningException {
        stack.push((Expr)expr);
        EvalNode lhs = (EvalNode)this.visit(ctx, stack, expr.getLeft());
        RowConstantEval rowConstantEval = (RowConstantEval)this.visit(ctx, stack, expr.getInValue());
        stack.pop();
        Pair<EvalNode, EvalNode> pair = ExprAnnotator.convertTypesIfNecessary(ctx, lhs, rowConstantEval);
        return new InEval((EvalNode)pair.getFirst(), (RowConstantEval)pair.getSecond(), expr.isNot());
    }

    @Override
    public EvalNode visitValueListExpr(Context ctx, Stack<Expr> stack, ValueListExpr expr) throws PlanningException {
        Datum[] values = new Datum[expr.getValues().length];
        EvalNode[] evalNodes = new EvalNode[expr.getValues().length];
        for (int i = 0; i < expr.getValues().length; ++i) {
            evalNodes[i] = (EvalNode)this.visit(ctx, stack, expr.getValues()[i]);
            if (!EvalTreeUtil.checkIfCanBeConstant(evalNodes[i])) {
                throw new PlanningException("Non constant values cannot be included in IN PREDICATE.");
            }
            values[i] = EvalTreeUtil.evaluateImmediately(evalNodes[i]);
        }
        return new RowConstantEval(values);
    }

    @Override
    public EvalNode visitExistsPredicate(Context ctx, Stack<Expr> stack, ExistsPredicate expr) throws PlanningException {
        throw new PlanningException("Cannot support EXISTS clause yet");
    }

    @Override
    public EvalNode visitLikePredicate(Context ctx, Stack<Expr> stack, PatternMatchPredicate expr) throws PlanningException {
        return this.visitPatternMatchPredicate(ctx, stack, expr);
    }

    @Override
    public EvalNode visitSimilarToPredicate(Context ctx, Stack<Expr> stack, PatternMatchPredicate expr) throws PlanningException {
        return this.visitPatternMatchPredicate(ctx, stack, expr);
    }

    @Override
    public EvalNode visitRegexpPredicate(Context ctx, Stack<Expr> stack, PatternMatchPredicate expr) throws PlanningException {
        return this.visitPatternMatchPredicate(ctx, stack, expr);
    }

    @Override
    public EvalNode visitConcatenate(Context ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        stack.push((Expr)expr);
        EvalNode lhs = (EvalNode)this.visit(ctx, stack, expr.getLeft());
        EvalNode rhs = (EvalNode)this.visit(ctx, stack, expr.getRight());
        stack.pop();
        if (lhs.getValueType().getType() != TajoDataTypes.Type.TEXT) {
            lhs = ExprAnnotator.convertType(ctx, lhs, CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.TEXT));
        }
        if (rhs.getValueType().getType() != TajoDataTypes.Type.TEXT) {
            rhs = ExprAnnotator.convertType(ctx, rhs, CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.TEXT));
        }
        return new BinaryEval(EvalType.CONCATENATE, lhs, rhs);
    }

    private EvalNode visitPatternMatchPredicate(Context ctx, Stack<Expr> stack, PatternMatchPredicate expr) throws PlanningException {
        EvalNode field = (EvalNode)this.visit(ctx, stack, expr.getPredicand());
        ConstEval pattern = (ConstEval)this.visit(ctx, stack, expr.getPattern());
        if (pattern.getValue() instanceof NullDatum) {
            return new ConstEval((Datum)NullDatum.get());
        }
        if (expr.getType() == OpType.LikePredicate) {
            return new LikePredicateEval(expr.isNot(), field, pattern, expr.isCaseInsensitive());
        }
        if (expr.getType() == OpType.SimilarToPredicate) {
            return new SimilarToPredicateEval(expr.isNot(), field, pattern);
        }
        return new RegexPredicateEval(expr.isNot(), field, pattern, expr.isCaseInsensitive());
    }

    private static BinaryEval createBinaryNode(Context ctx, EvalType type, EvalNode lhs, EvalNode rhs) {
        Pair<EvalNode, EvalNode> pair = ExprAnnotator.convertTypesIfNecessary(ctx, lhs, rhs);
        return new BinaryEval(type, (EvalNode)pair.getFirst(), (EvalNode)pair.getSecond());
    }

    @Override
    public EvalNode visitPlus(Context ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        stack.push((Expr)expr);
        EvalNode left = (EvalNode)this.visit(ctx, stack, expr.getLeft());
        EvalNode right = (EvalNode)this.visit(ctx, stack, expr.getRight());
        stack.pop();
        return ExprAnnotator.createBinaryNode(ctx, EvalType.PLUS, left, right);
    }

    @Override
    public EvalNode visitMinus(Context ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        stack.push((Expr)expr);
        EvalNode left = (EvalNode)this.visit(ctx, stack, expr.getLeft());
        EvalNode right = (EvalNode)this.visit(ctx, stack, expr.getRight());
        stack.pop();
        return ExprAnnotator.createBinaryNode(ctx, EvalType.MINUS, left, right);
    }

    @Override
    public EvalNode visitMultiply(Context ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        stack.push((Expr)expr);
        EvalNode left = (EvalNode)this.visit(ctx, stack, expr.getLeft());
        EvalNode right = (EvalNode)this.visit(ctx, stack, expr.getRight());
        stack.pop();
        return ExprAnnotator.createBinaryNode(ctx, EvalType.MULTIPLY, left, right);
    }

    @Override
    public EvalNode visitDivide(Context ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        stack.push((Expr)expr);
        EvalNode left = (EvalNode)this.visit(ctx, stack, expr.getLeft());
        EvalNode right = (EvalNode)this.visit(ctx, stack, expr.getRight());
        stack.pop();
        return ExprAnnotator.createBinaryNode(ctx, EvalType.DIVIDE, left, right);
    }

    @Override
    public EvalNode visitModular(Context ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        stack.push((Expr)expr);
        EvalNode left = (EvalNode)this.visit(ctx, stack, expr.getLeft());
        EvalNode right = (EvalNode)this.visit(ctx, stack, expr.getRight());
        stack.pop();
        return ExprAnnotator.createBinaryNode(ctx, EvalType.MODULAR, left, right);
    }

    @Override
    public EvalNode visitSign(Context ctx, Stack<Expr> stack, SignedExpr expr) throws PlanningException {
        stack.push((Expr)expr);
        EvalNode numericExpr = (EvalNode)this.visit(ctx, stack, expr.getChild());
        stack.pop();
        if (expr.isNegative()) {
            return new SignedEval(expr.isNegative(), numericExpr);
        }
        return numericExpr;
    }

    @Override
    public EvalNode visitColumnReference(Context ctx, Stack<Expr> stack, ColumnReferenceExpr expr) throws PlanningException {
        Column column;
        switch (ctx.columnRsvLevel) {
            case LEGACY: {
                column = ctx.plan.resolveColumn(ctx.currentBlock, expr);
                break;
            }
            case RELS_ONLY: 
            case RELS_AND_SUBEXPRS: 
            case SUBEXPRS_AND_RELS: {
                column = NameResolver.resolve(ctx.plan, ctx.currentBlock, expr, ctx.columnRsvLevel);
                break;
            }
            default: {
                throw new PlanningException("Unsupported column resolving level: " + ctx.columnRsvLevel.name());
            }
        }
        return new FieldEval(column);
    }

    @Override
    public EvalNode visitTargetExpr(Context ctx, Stack<Expr> stack, NamedExpr expr) throws PlanningException {
        throw new PlanningException("ExprAnnotator cannot take NamedExpr");
    }

    @Override
    public EvalNode visitFunction(Context ctx, Stack<Expr> stack, FunctionExpr expr) throws PlanningException {
        stack.push((Expr)expr);
        Expr[] params = expr.getParams();
        if (params == null) {
            params = new Expr[]{};
        }
        EvalNode[] givenArgs = new EvalNode[params.length];
        TajoDataTypes.DataType[] paramTypes = new TajoDataTypes.DataType[params.length];
        for (int i = 0; i < params.length; ++i) {
            givenArgs[i] = (EvalNode)this.visit(ctx, stack, params[i]);
            paramTypes[i] = givenArgs[i].getValueType();
        }
        stack.pop();
        if (!this.catalog.containFunction(expr.getSignature(), paramTypes)) {
            throw new NoSuchFunctionException(expr.getSignature(), paramTypes);
        }
        FunctionDesc funcDesc = this.catalog.getFunction(expr.getSignature(), paramTypes);
        if (CatalogUtil.checkIfVariableLengthParamDefinition((List)TUtil.newList((Object[])funcDesc.getParamTypes()))) {
            TajoDataTypes.DataType lastDataType = funcDesc.getParamTypes()[0];
            for (int i = 0; i < givenArgs.length; ++i) {
                lastDataType = i < funcDesc.getParamTypes().length - 1 ? funcDesc.getParamTypes()[i] : CatalogUtil.newSimpleDataType((TajoDataTypes.Type)CatalogUtil.getPrimitiveTypeOf((TajoDataTypes.Type)lastDataType.getType()));
                givenArgs[i] = ExprAnnotator.convertType(ctx, givenArgs[i], lastDataType);
            }
        } else {
            ExprAnnotator.assertEval(funcDesc.getParamTypes().length == givenArgs.length, "The number of parameters is mismatched to the function definition: " + funcDesc.toString());
            for (int i = 0; i < givenArgs.length; ++i) {
                givenArgs[i] = ExprAnnotator.convertType(ctx, givenArgs[i], funcDesc.getParamTypes()[i]);
            }
        }
        try {
            CatalogProtos.FunctionType functionType = funcDesc.getFuncType();
            if (functionType == CatalogProtos.FunctionType.GENERAL || functionType == CatalogProtos.FunctionType.UDF) {
                return new GeneralFunctionEval(ctx.queryContext, funcDesc, (GeneralFunction)funcDesc.newInstance(), givenArgs);
            }
            if (functionType == CatalogProtos.FunctionType.AGGREGATION || functionType == CatalogProtos.FunctionType.UDA) {
                if (!ctx.currentBlock.hasNode(NodeType.GROUP_BY)) {
                    ctx.currentBlock.setAggregationRequire();
                }
                return new AggregationFunctionCallEval(funcDesc, (AggFunction)funcDesc.newInstance(), givenArgs);
            }
            if (functionType == CatalogProtos.FunctionType.DISTINCT_AGGREGATION || functionType == CatalogProtos.FunctionType.DISTINCT_UDA) {
                throw new PlanningException("Unsupported function: " + funcDesc.toString());
            }
            throw new PlanningException("Unsupported Function Type: " + functionType.name());
        }
        catch (InternalException e) {
            throw new PlanningException((Exception)((Object)e));
        }
    }

    @Override
    public EvalNode visitCountRowsFunction(Context ctx, Stack<Expr> stack, CountRowsFunctionExpr expr) throws PlanningException {
        FunctionDesc countRows = this.catalog.getFunction("count", CatalogProtos.FunctionType.AGGREGATION, new TajoDataTypes.DataType[0]);
        if (countRows == null) {
            throw new NoSuchFunctionException(expr.getSignature(), new TajoDataTypes.DataType[0]);
        }
        try {
            ctx.currentBlock.setAggregationRequire();
            return new AggregationFunctionCallEval(countRows, (AggFunction)countRows.newInstance(), new EvalNode[0]);
        }
        catch (InternalException e) {
            throw new NoSuchFunctionException(countRows.getFunctionName(), new TajoDataTypes.DataType[0]);
        }
    }

    @Override
    public EvalNode visitGeneralSetFunction(Context ctx, Stack<Expr> stack, GeneralSetFunctionExpr setFunction) throws PlanningException {
        Expr[] params = setFunction.getParams();
        EvalNode[] givenArgs = new EvalNode[params.length];
        TajoDataTypes.DataType[] paramTypes = new TajoDataTypes.DataType[params.length];
        CatalogProtos.FunctionType functionType = setFunction.isDistinct() ? CatalogProtos.FunctionType.DISTINCT_AGGREGATION : CatalogProtos.FunctionType.AGGREGATION;
        givenArgs[0] = (EvalNode)this.visit(ctx, stack, params[0]);
        paramTypes[0] = setFunction.getSignature().equalsIgnoreCase("count") ? CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.ANY) : givenArgs[0].getValueType();
        if (!this.catalog.containFunction(setFunction.getSignature(), functionType, paramTypes)) {
            throw new NoSuchFunctionException(setFunction.getSignature(), paramTypes);
        }
        FunctionDesc funcDesc = this.catalog.getFunction(setFunction.getSignature(), functionType, paramTypes);
        if (!ctx.currentBlock.hasNode(NodeType.GROUP_BY)) {
            ctx.currentBlock.setAggregationRequire();
        }
        try {
            return new AggregationFunctionCallEval(funcDesc, (AggFunction)funcDesc.newInstance(), givenArgs);
        }
        catch (InternalException e) {
            throw new PlanningException((Exception)((Object)e));
        }
    }

    @Override
    public EvalNode visitWindowFunction(Context ctx, Stack<Expr> stack, WindowFunctionExpr windowFunc) throws PlanningException {
        CatalogProtos.FunctionType functionType;
        Expr key;
        WindowSpec windowSpec = windowFunc.getWindowSpec();
        if (windowSpec.hasPartitionBy()) {
            for (int i = 0; i < windowSpec.getPartitionKeys().length; ++i) {
                key = windowSpec.getPartitionKeys()[i];
                this.visit(ctx, stack, key);
            }
        }
        EvalNode[] sortKeys = null;
        if (windowSpec.hasOrderBy()) {
            sortKeys = new EvalNode[windowSpec.getSortSpecs().length];
            for (int i = 0; i < windowSpec.getSortSpecs().length; ++i) {
                key = windowSpec.getSortSpecs()[i].getKey();
                sortKeys[i] = (EvalNode)this.visit(ctx, stack, key);
            }
        }
        String funcName = windowFunc.getSignature();
        boolean distinct = windowFunc.isDistinct();
        Expr[] params = windowFunc.getParams();
        EvalNode[] givenArgs = new EvalNode[params.length];
        TajoDataTypes.DataType[] paramTypes = new TajoDataTypes.DataType[params.length];
        WindowSpec.WindowFrame frame = null;
        if (params.length > 0) {
            givenArgs[0] = (EvalNode)this.visit(ctx, stack, params[0]);
            paramTypes[0] = windowFunc.getSignature().equalsIgnoreCase("count") ? CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.ANY) : (windowFunc.getSignature().equalsIgnoreCase("row_number") ? CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.INT8) : givenArgs[0].getValueType());
            for (int i = 1; i < params.length; ++i) {
                givenArgs[i] = (EvalNode)this.visit(ctx, stack, params[i]);
                paramTypes[i] = givenArgs[i].getValueType();
            }
        } else if (windowFunc.getSignature().equalsIgnoreCase("rank")) {
            EvalNode[] evalNodeArray = givenArgs = sortKeys != null ? sortKeys : new EvalNode[]{};
        }
        if (frame == null) {
            frame = windowSpec.hasOrderBy() ? new WindowSpec.WindowFrame(new WindowSpec.WindowStartBound(WindowSpec.WindowFrameStartBoundType.UNBOUNDED_PRECEDING), new WindowSpec.WindowEndBound(WindowSpec.WindowFrameEndBoundType.CURRENT_ROW)) : (windowFunc.getSignature().equalsIgnoreCase("row_number") ? new WindowSpec.WindowFrame(new WindowSpec.WindowStartBound(WindowSpec.WindowFrameStartBoundType.UNBOUNDED_PRECEDING), new WindowSpec.WindowEndBound(WindowSpec.WindowFrameEndBoundType.UNBOUNDED_FOLLOWING)) : new WindowSpec.WindowFrame());
        }
        if (WINDOW_FUNCTIONS.contains(funcName.toLowerCase())) {
            if (distinct) {
                throw new NoSuchFunctionException("row_number() does not support distinct keyword.");
            }
            functionType = CatalogProtos.FunctionType.WINDOW;
        } else {
            CatalogProtos.FunctionType functionType2 = functionType = distinct ? CatalogProtos.FunctionType.DISTINCT_AGGREGATION : CatalogProtos.FunctionType.AGGREGATION;
        }
        if (!this.catalog.containFunction(windowFunc.getSignature(), functionType, paramTypes)) {
            throw new NoSuchFunctionException(funcName, paramTypes);
        }
        FunctionDesc funcDesc = this.catalog.getFunction(funcName, functionType, paramTypes);
        try {
            return new WindowFunctionEval(funcDesc, (AggFunction)funcDesc.newInstance(), givenArgs, frame);
        }
        catch (InternalException e) {
            throw new PlanningException((Exception)((Object)e));
        }
    }

    @Override
    public EvalNode visitDataType(Context ctx, Stack<Expr> stack, DataTypeExpr expr) throws PlanningException {
        return (EvalNode)super.visitDataType(ctx, stack, expr);
    }

    @Override
    public EvalNode visitCastExpr(Context ctx, Stack<Expr> stack, CastExpr expr) throws PlanningException {
        EvalNode child = (EvalNode)super.visitCastExpr(ctx, stack, expr);
        if (child.getType() == EvalType.CONST) {
            ConstEval constEval = (ConstEval)child;
            TimeZone tz = null;
            if (ctx.queryContext.containsKey((ConfigKey)SessionVars.TIMEZONE)) {
                String tzId = ctx.queryContext.get((ConfigKey)SessionVars.TIMEZONE);
                tz = TimeZone.getTimeZone(tzId);
            }
            return new ConstEval(DatumFactory.cast((Datum)constEval.getValue(), (TajoDataTypes.DataType)LogicalPlanner.convertDataType(expr.getTarget()), (TimeZone)tz));
        }
        return new CastEval(ctx.queryContext, child, LogicalPlanner.convertDataType(expr.getTarget()));
    }

    @Override
    public EvalNode visitLiteral(Context ctx, Stack<Expr> stack, LiteralValue expr) throws PlanningException {
        switch (expr.getValueType()) {
            case Boolean: {
                return new ConstEval((Datum)DatumFactory.createBool((boolean)((BooleanLiteral)expr).isTrue()));
            }
            case String: {
                return new ConstEval((Datum)DatumFactory.createText((String)expr.getValue()));
            }
            case Unsigned_Integer: {
                return new ConstEval((Datum)DatumFactory.createInt4((String)expr.getValue()));
            }
            case Unsigned_Large_Integer: {
                return new ConstEval((Datum)DatumFactory.createInt8((String)expr.getValue()));
            }
            case Unsigned_Float: {
                return new ConstEval((Datum)DatumFactory.createFloat8((String)expr.getValue()));
            }
        }
        throw new RuntimeException("Unsupported type: " + expr.getValueType());
    }

    @Override
    public EvalNode visitNullLiteral(Context ctx, Stack<Expr> stack, NullLiteral expr) throws PlanningException {
        return new ConstEval((Datum)NullDatum.get());
    }

    @Override
    public EvalNode visitDateLiteral(Context context, Stack<Expr> stack, DateLiteral expr) throws PlanningException {
        DateValue dateValue = expr.getDate();
        int[] dates = ExprAnnotator.dateToIntArray(dateValue.getYears(), dateValue.getMonths(), dateValue.getDays());
        TimeMeta tm = new TimeMeta();
        tm.years = dates[0];
        tm.monthOfYear = dates[1];
        tm.dayOfMonth = dates[2];
        DateTimeUtil.j2date((int)DateTimeUtil.date2j((int)dates[0], (int)dates[1], (int)dates[2]), (TimeMeta)tm);
        return new ConstEval((Datum)new DateDatum(DateTimeUtil.date2j((int)tm.years, (int)tm.monthOfYear, (int)tm.dayOfMonth)));
    }

    @Override
    public EvalNode visitTimestampLiteral(Context ctx, Stack<Expr> stack, TimestampLiteral expr) throws PlanningException {
        DateValue dateValue = expr.getDate();
        TimeValue timeValue = expr.getTime();
        int[] dates = ExprAnnotator.dateToIntArray(dateValue.getYears(), dateValue.getMonths(), dateValue.getDays());
        int[] times = ExprAnnotator.timeToIntArray(timeValue.getHours(), timeValue.getMinutes(), timeValue.getSeconds(), timeValue.getSecondsFraction());
        long timestamp = timeValue.hasSecondsFraction() ? DateTimeUtil.toJulianTimestamp((int)dates[0], (int)dates[1], (int)dates[2], (int)times[0], (int)times[1], (int)times[2], (int)(times[3] * 1000)) : DateTimeUtil.toJulianTimestamp((int)dates[0], (int)dates[1], (int)dates[2], (int)times[0], (int)times[1], (int)times[2], (int)0);
        TimeMeta tm = new TimeMeta();
        DateTimeUtil.toJulianTimeMeta((long)timestamp, (TimeMeta)tm);
        if (ctx.queryContext.containsKey((ConfigKey)SessionVars.TIMEZONE)) {
            TimeZone tz = TimeZone.getTimeZone(ctx.queryContext.get((ConfigKey)SessionVars.TIMEZONE));
            DateTimeUtil.toUTCTimezone((TimeMeta)tm, (TimeZone)tz);
        }
        return new ConstEval((Datum)new TimestampDatum(DateTimeUtil.toJulianTimestamp((TimeMeta)tm)));
    }

    @Override
    public EvalNode visitIntervalLiteral(Context ctx, Stack<Expr> stack, IntervalLiteral expr) throws PlanningException {
        return new ConstEval((Datum)new IntervalDatum(expr.getExprStr()));
    }

    @Override
    public EvalNode visitTimeLiteral(Context ctx, Stack<Expr> stack, TimeLiteral expr) throws PlanningException {
        TimeValue timeValue = expr.getTime();
        int[] times = ExprAnnotator.timeToIntArray(timeValue.getHours(), timeValue.getMinutes(), timeValue.getSeconds(), timeValue.getSecondsFraction());
        long time = timeValue.hasSecondsFraction() ? DateTimeUtil.toTime((int)times[0], (int)times[1], (int)times[2], (int)(times[3] * 1000)) : DateTimeUtil.toTime((int)times[0], (int)times[1], (int)times[2], (int)0);
        TimeDatum timeDatum = new TimeDatum(time);
        TimeMeta tm = timeDatum.toTimeMeta();
        if (ctx.queryContext.containsKey((ConfigKey)SessionVars.TIMEZONE)) {
            TimeZone tz = TimeZone.getTimeZone(ctx.queryContext.get((ConfigKey)SessionVars.TIMEZONE));
            DateTimeUtil.toUTCTimezone((TimeMeta)tm, (TimeZone)tz);
        }
        return new ConstEval((Datum)new TimeDatum(DateTimeUtil.toTime((TimeMeta)tm)));
    }

    public static int[] dateToIntArray(String years, String months, String days) throws PlanningException {
        int year = Integer.valueOf(years);
        int month = Integer.valueOf(months);
        int day = Integer.valueOf(days);
        if (1 > year || year > 9999) {
            throw new PlanningException(String.format("Years (%d) must be between 1 and 9999 integer value", year));
        }
        if (1 > month || month > 12) {
            throw new PlanningException(String.format("Months (%d) must be between 1 and 12 integer value", month));
        }
        if (1 > day || day > 31) {
            throw new PlanningException(String.format("Days (%d) must be between 1 and 31 integer value", day));
        }
        int[] results = new int[]{year, month, day};
        return results;
    }

    public static int[] timeToIntArray(String hours, String minutes, String seconds, String fractionOfSecond) throws PlanningException {
        int hour = Integer.valueOf(hours);
        int minute = Integer.valueOf(minutes);
        int second = Integer.valueOf(seconds);
        int fraction = 0;
        if (fractionOfSecond != null) {
            fraction = Integer.valueOf(fractionOfSecond);
        }
        if (0 > hour || hour > 23) {
            throw new PlanningException(String.format("Hours (%d) must be between 0 and 24 integer value", hour));
        }
        if (0 > minute || minute > 59) {
            throw new PlanningException(String.format("Minutes (%d) must be between 0 and 59 integer value", minute));
        }
        if (0 > second || second > 59) {
            throw new PlanningException(String.format("Seconds (%d) must be between 0 and 59 integer value", second));
        }
        if (fraction != 0 && (0 > fraction || fraction > 999)) {
            throw new PlanningException(String.format("Seconds (%d) must be between 0 and 999 integer value", fraction));
        }
        int[] results = new int[]{hour, minute, second, fraction};
        return results;
    }

    static class Context {
        OverridableConf queryContext;
        TimeZone timeZone;
        LogicalPlan plan;
        LogicalPlan.QueryBlock currentBlock;
        NameResolvingMode columnRsvLevel;

        public Context(LogicalPlanner.PlanContext planContext, NameResolvingMode colRsvLevel) {
            this.queryContext = planContext.queryContext;
            this.timeZone = planContext.timeZone;
            this.plan = planContext.plan;
            this.currentBlock = planContext.queryBlock;
            this.columnRsvLevel = colRsvLevel;
        }
    }
}

