/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.tajo.algebra.BinaryOperator;
import org.apache.tajo.algebra.CaseWhenPredicate;
import org.apache.tajo.algebra.CastExpr;
import org.apache.tajo.algebra.ColumnReferenceExpr;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.FunctionExpr;
import org.apache.tajo.algebra.GeneralSetFunctionExpr;
import org.apache.tajo.algebra.NamedExpr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.algebra.UnaryOperator;
import org.apache.tajo.algebra.WindowFunctionExpr;
import org.apache.tajo.algebra.WindowSpec;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.exception.NoSuchColumnException;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.LogicalPlanner;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.nameresolver.NameResolver;
import org.apache.tajo.plan.nameresolver.NameResolvingMode;
import org.apache.tajo.plan.visitor.SimpleAlgebraVisitor;

class ExprNormalizer
extends SimpleAlgebraVisitor<ExprNormalizedResult, Object> {
    ExprNormalizer() {
    }

    public ExprNormalizedResult normalize(LogicalPlanner.PlanContext context, Expr expr) throws PlanningException {
        return this.normalize(context, expr, false);
    }

    public ExprNormalizedResult normalize(LogicalPlanner.PlanContext context, Expr expr, boolean subexprElimination) throws PlanningException {
        ExprNormalizedResult exprNormalizedResult = new ExprNormalizedResult(context, subexprElimination);
        Stack<Expr> stack = new Stack<Expr>();
        stack.push(expr);
        this.visit(exprNormalizedResult, new Stack<Expr>(), expr);
        exprNormalizedResult.baseExpr = (Expr)stack.pop();
        return exprNormalizedResult;
    }

    @Override
    public Object visitCaseWhen(ExprNormalizedResult ctx, Stack<Expr> stack, CaseWhenPredicate expr) throws PlanningException {
        stack.push((Expr)expr);
        for (CaseWhenPredicate.WhenExpr when : expr.getWhens()) {
            String referenceName;
            this.visit(ctx, stack, when.getCondition());
            this.visit(ctx, stack, when.getResult());
            if (OpType.isAggregationFunction((OpType)when.getCondition().getType())) {
                referenceName = ((ExprNormalizedResult)ctx).block.namedExprsMgr.addExpr(when.getCondition());
                ctx.aggExprs.add(new NamedExpr(when.getCondition(), referenceName));
                when.setCondition((Expr)new ColumnReferenceExpr(referenceName));
            }
            if (!OpType.isAggregationFunction((OpType)when.getResult().getType())) continue;
            referenceName = ((ExprNormalizedResult)ctx).block.namedExprsMgr.addExpr(when.getResult());
            ctx.aggExprs.add(new NamedExpr(when.getResult(), referenceName));
            when.setResult((Expr)new ColumnReferenceExpr(referenceName));
        }
        if (expr.hasElseResult()) {
            this.visit(ctx, stack, expr.getElseResult());
            if (OpType.isAggregationFunction((OpType)expr.getElseResult().getType())) {
                String referenceName = ((ExprNormalizedResult)ctx).block.namedExprsMgr.addExpr(expr.getElseResult());
                ctx.aggExprs.add(new NamedExpr(expr.getElseResult(), referenceName));
                expr.setElseResult((Expr)new ColumnReferenceExpr(referenceName));
            }
        }
        stack.pop();
        return expr;
    }

    @Override
    public Expr visitUnaryOperator(ExprNormalizedResult ctx, Stack<Expr> stack, UnaryOperator expr) throws PlanningException {
        super.visitUnaryOperator(ctx, stack, expr);
        if (OpType.isAggregationFunction((OpType)expr.getChild().getType())) {
            String refName = ((ExprNormalizedResult)ctx).block.namedExprsMgr.addExpr(expr.getChild());
            ctx.aggExprs.add(new NamedExpr(expr.getChild(), refName));
            expr.setChild((Expr)new ColumnReferenceExpr(refName));
        }
        return expr;
    }

    private boolean isBinaryCommonTermsElimination(ExprNormalizedResult ctx, Expr expr) {
        return ctx.isBinaryCommonTermsElimination() && expr.getType() != OpType.Column && ((ExprNormalizedResult)ctx).block.namedExprsMgr.contains(expr);
    }

    @Override
    public Expr visitBinaryOperator(ExprNormalizedResult ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        String refName;
        stack.push((Expr)expr);
        this.visit(ctx, new Stack<Expr>(), expr.getLeft());
        if (this.isBinaryCommonTermsElimination(ctx, expr.getLeft())) {
            refName = ((ExprNormalizedResult)ctx).block.namedExprsMgr.addExpr(expr.getLeft());
            expr.setLeft((Expr)new ColumnReferenceExpr(refName));
        }
        this.visit(ctx, new Stack<Expr>(), expr.getRight());
        if (this.isBinaryCommonTermsElimination(ctx, expr.getRight())) {
            refName = ((ExprNormalizedResult)ctx).block.namedExprsMgr.addExpr(expr.getRight());
            expr.setRight((Expr)new ColumnReferenceExpr(refName));
        }
        stack.pop();
        if (OpType.isAggregationFunction((OpType)expr.getLeft().getType())) {
            String leftRefName = ((ExprNormalizedResult)ctx).block.namedExprsMgr.addExpr(expr.getLeft());
            ctx.aggExprs.add(new NamedExpr(expr.getLeft(), leftRefName));
            expr.setLeft((Expr)new ColumnReferenceExpr(leftRefName));
        }
        if (OpType.isAggregationFunction((OpType)expr.getRight().getType())) {
            String rightRefName = ((ExprNormalizedResult)ctx).block.namedExprsMgr.addExpr(expr.getRight());
            ctx.aggExprs.add(new NamedExpr(expr.getRight(), rightRefName));
            expr.setRight((Expr)new ColumnReferenceExpr(rightRefName));
        }
        return expr;
    }

    @Override
    public Expr visitFunction(ExprNormalizedResult ctx, Stack<Expr> stack, FunctionExpr expr) throws PlanningException {
        stack.push((Expr)expr);
        Expr[] paramExprs = expr.getParams();
        if (paramExprs != null) {
            for (int i = 0; i < paramExprs.length; ++i) {
                Expr param = paramExprs[i];
                this.visit(ctx, stack, param);
                if (!OpType.isAggregationFunction((OpType)param.getType())) continue;
                String referenceName = ctx.plan.generateUniqueColumnName(param);
                ctx.aggExprs.add(new NamedExpr(param, referenceName));
                expr.getParams()[i] = new ColumnReferenceExpr(referenceName);
            }
        }
        stack.pop();
        return expr;
    }

    @Override
    public Expr visitGeneralSetFunction(ExprNormalizedResult ctx, Stack<Expr> stack, GeneralSetFunctionExpr expr) throws PlanningException {
        stack.push((Expr)expr);
        for (int i = 0; i < expr.getParams().length; ++i) {
            Expr param = expr.getParams()[i];
            this.visit(ctx, stack, param);
            if (OpType.isLiteralType((OpType)param.getType()) || param.getType() == OpType.Column) continue;
            String referenceName = ((ExprNormalizedResult)ctx).block.namedExprsMgr.addExpr(param);
            ctx.scalarExprs.add(new NamedExpr(param, referenceName));
            expr.getParams()[i] = new ColumnReferenceExpr(referenceName);
        }
        stack.pop();
        return expr;
    }

    @Override
    public Expr visitWindowFunction(ExprNormalizedResult ctx, Stack<Expr> stack, WindowFunctionExpr expr) throws PlanningException {
        WindowSpecReferences windowSpecReferences;
        stack.push((Expr)expr);
        WindowSpec windowSpec = expr.getWindowSpec();
        if (windowSpec.hasWindowName()) {
            windowSpecReferences = new WindowSpecReferences(windowSpec.getWindowName());
        } else {
            Expr key;
            String[] partitionKeyReferenceNames = null;
            if (windowSpec.hasPartitionBy()) {
                partitionKeyReferenceNames = new String[windowSpec.getPartitionKeys().length];
                for (int i = 0; i < windowSpec.getPartitionKeys().length; ++i) {
                    key = windowSpec.getPartitionKeys()[i];
                    this.visit(ctx, stack, key);
                    partitionKeyReferenceNames[i] = ((ExprNormalizedResult)ctx).block.namedExprsMgr.addExpr(key);
                }
            }
            String[] orderKeyReferenceNames = null;
            if (windowSpec.hasOrderBy()) {
                orderKeyReferenceNames = new String[windowSpec.getSortSpecs().length];
                for (int i = 0; i < windowSpec.getSortSpecs().length; ++i) {
                    key = windowSpec.getSortSpecs()[i].getKey();
                    this.visit(ctx, stack, key);
                    String referenceName = ((ExprNormalizedResult)ctx).block.namedExprsMgr.addExpr(key);
                    if (OpType.isAggregationFunction((OpType)key.getType())) {
                        ctx.aggExprs.add(new NamedExpr(key, referenceName));
                        windowSpec.getSortSpecs()[i].setKey((Expr)new ColumnReferenceExpr(referenceName));
                    }
                    orderKeyReferenceNames[i] = referenceName;
                }
            }
            windowSpecReferences = new WindowSpecReferences(partitionKeyReferenceNames, orderKeyReferenceNames);
        }
        ctx.windowSpecs.add(windowSpecReferences);
        String funcExprRef = ((ExprNormalizedResult)ctx).block.namedExprsMgr.addExpr((Expr)expr);
        ctx.windowAggExprs.add(new NamedExpr((Expr)expr, funcExprRef));
        stack.pop();
        ctx.block.setHasWindowFunction();
        return expr;
    }

    @Override
    public Expr visitCastExpr(ExprNormalizedResult ctx, Stack<Expr> stack, CastExpr expr) throws PlanningException {
        super.visitCastExpr(ctx, stack, expr);
        if (OpType.isAggregationFunction((OpType)expr.getType())) {
            String referenceName = ((ExprNormalizedResult)ctx).block.namedExprsMgr.addExpr(expr.getChild());
            ctx.aggExprs.add(new NamedExpr(expr.getChild(), referenceName));
            expr.setChild((Expr)new ColumnReferenceExpr(referenceName));
        }
        return expr;
    }

    @Override
    public Expr visitColumnReference(ExprNormalizedResult ctx, Stack<Expr> stack, ColumnReferenceExpr expr) throws PlanningException {
        if (ctx.block.isAliasedName(expr.getCanonicalName())) {
            String originalName = ctx.block.getOriginalName(expr.getCanonicalName());
            expr.setName(originalName);
            return expr;
        }
        if (!(expr.hasQualifier() && CatalogUtil.isFQTableName((String)expr.getQualifier()) || ((ExprNormalizedResult)ctx).block.namedExprsMgr.contains(expr.getCanonicalName()) || expr.getType() != OpType.Column)) {
            try {
                String normalized = NameResolver.resolve(ctx.plan, ctx.block, expr, NameResolvingMode.LEGACY).getQualifiedName();
                expr.setName(normalized);
            }
            catch (NoSuchColumnException nsc) {
                // empty catch block
            }
        }
        return expr;
    }

    public static class WindowSpecReferences {
        String windowName;
        String[] partitionKeys;
        String[] orderKeys;

        public WindowSpecReferences(String windowName) {
            this.windowName = windowName;
        }

        public WindowSpecReferences(String[] partitionKeys, String[] orderKeys) {
            this.partitionKeys = partitionKeys;
            this.orderKeys = orderKeys;
        }

        public String getWindowName() {
            return this.windowName;
        }

        public boolean hasPartitionKeys() {
            return this.partitionKeys != null;
        }

        public String[] getPartitionKeys() {
            return this.partitionKeys;
        }

        public boolean hasOrderBy() {
            return this.orderKeys != null;
        }

        public String[] getOrderKeys() {
            return this.orderKeys;
        }
    }

    public static class ExprNormalizedResult {
        private final LogicalPlan plan;
        private final LogicalPlan.QueryBlock block;
        private final boolean tryBinaryCommonTermsElimination;
        Expr baseExpr;
        List<NamedExpr> aggExprs = new ArrayList<NamedExpr>();
        List<NamedExpr> scalarExprs = new ArrayList<NamedExpr>();
        List<NamedExpr> windowAggExprs = new ArrayList<NamedExpr>();
        Set<WindowSpecReferences> windowSpecs = Sets.newLinkedHashSet();

        public ExprNormalizedResult(LogicalPlanner.PlanContext context, boolean tryBinaryCommonTermsElimination) {
            this.plan = context.plan;
            this.block = context.queryBlock;
            this.tryBinaryCommonTermsElimination = tryBinaryCommonTermsElimination;
        }

        public boolean isBinaryCommonTermsElimination() {
            return this.tryBinaryCommonTermsElimination;
        }

        public String toString() {
            return this.baseExpr.toString() + ", agg=" + this.aggExprs.size() + ", scalar=" + this.scalarExprs.size();
        }
    }
}

