/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tajo.ConfigKey;
import org.apache.tajo.OverridableConf;
import org.apache.tajo.SessionVars;
import org.apache.tajo.algebra.JoinType;
import org.apache.tajo.conf.TajoConf;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.expr.AlgebraicUtil;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.joinorder.FoundJoinOrder;
import org.apache.tajo.plan.joinorder.GreedyHeuristicJoinOrderAlgorithm;
import org.apache.tajo.plan.joinorder.JoinGraph;
import org.apache.tajo.plan.joinorder.JoinOrderAlgorithm;
import org.apache.tajo.plan.logical.JoinNode;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.RelationNode;
import org.apache.tajo.plan.logical.ScanNode;
import org.apache.tajo.plan.logical.SelectionNode;
import org.apache.tajo.plan.logical.TableSubQueryNode;
import org.apache.tajo.plan.rewrite.BaseLogicalPlanRewriteEngine;
import org.apache.tajo.plan.rewrite.LogicalPlanRewriteRule;
import org.apache.tajo.plan.rewrite.LogicalPlanRewriteRuleProvider;
import org.apache.tajo.plan.util.PlannerUtil;
import org.apache.tajo.plan.visitor.BasicLogicalPlanVisitor;
import org.apache.tajo.util.ReflectionUtil;
import org.apache.tajo.util.graph.DirectedGraphCursor;

@InterfaceStability.Evolving
public class LogicalOptimizer {
    private static final Log LOG = LogFactory.getLog((String)LogicalOptimizer.class.getName());
    private BaseLogicalPlanRewriteEngine rulesBeforeJoinOpt;
    private BaseLogicalPlanRewriteEngine rulesAfterToJoinOpt;
    private JoinOrderAlgorithm joinOrderAlgorithm = new GreedyHeuristicJoinOrderAlgorithm();

    public LogicalOptimizer(TajoConf conf) {
        Class clazz = conf.getClassVar(TajoConf.ConfVars.LOGICAL_PLAN_REWRITE_RULE_PROVIDER_CLASS);
        LogicalPlanRewriteRuleProvider provider = (LogicalPlanRewriteRuleProvider)ReflectionUtil.newInstance((Class)clazz, (TajoConf)conf);
        this.rulesBeforeJoinOpt = new BaseLogicalPlanRewriteEngine();
        this.rulesBeforeJoinOpt.addRewriteRule(provider.getPreRules());
        this.rulesAfterToJoinOpt = new BaseLogicalPlanRewriteEngine();
        this.rulesAfterToJoinOpt.addRewriteRule(provider.getPostRules());
    }

    public void addRuleAfterToJoinOpt(LogicalPlanRewriteRule rewriteRule) {
        if (rewriteRule != null) {
            this.rulesAfterToJoinOpt.addRewriteRule(rewriteRule);
        }
    }

    @VisibleForTesting
    public LogicalNode optimize(LogicalPlan plan) throws PlanningException {
        OverridableConf conf = new OverridableConf(new TajoConf(), new ConfigKey.ConfigType[]{ConfigKey.ConfigType.SESSION, ConfigKey.ConfigType.QUERY, ConfigKey.ConfigType.SYSTEM});
        return this.optimize(conf, plan);
    }

    public LogicalNode optimize(OverridableConf context, LogicalPlan plan) throws PlanningException {
        this.rulesBeforeJoinOpt.rewrite(context, plan);
        DirectedGraphCursor blockCursor = new DirectedGraphCursor(plan.getQueryBlockGraph(), (Object)plan.getRootBlock().getName());
        if (context == null || context.getBool((ConfigKey)SessionVars.TEST_JOIN_OPT_ENABLED)) {
            while (blockCursor.hasNext()) {
                this.optimizeJoinOrder(plan, (String)blockCursor.nextBlock());
            }
        } else {
            LOG.info((Object)"Skip Join Optimized.");
        }
        this.rulesAfterToJoinOpt.rewrite(context, plan);
        return plan.getRootBlock().getRoot();
    }

    private void optimizeJoinOrder(LogicalPlan plan, String blockName) throws PlanningException {
        LogicalPlan.QueryBlock block = plan.getBlock(blockName);
        if (block.hasNode(NodeType.JOIN)) {
            String originalOrder = JoinOrderStringBuilder.buildJoinOrderString(plan, block);
            double nonOptimizedJoinCost = JoinCostComputer.computeCost(plan, block);
            JoinGraphContext joinGraphContext = JoinGraphBuilder.buildJoinGraph(plan, block);
            FoundJoinOrder order = this.joinOrderAlgorithm.findBestOrder(plan, block, joinGraphContext.joinGraph, joinGraphContext.relationsForProduct);
            JoinNode newJoinNode = order.getOrderedJoin();
            JoinNode old = (JoinNode)PlannerUtil.findTopNode(block.getRoot(), NodeType.JOIN);
            JoinTargetCollector collector = new JoinTargetCollector();
            LinkedHashSet<Target> targets = new LinkedHashSet<Target>();
            collector.visitJoin((Set<Target>)targets, plan, block, old, new Stack<LogicalNode>());
            if (targets.size() == 0) {
                newJoinNode.setTargets(PlannerUtil.schemaToTargets(old.getOutSchema()));
            } else {
                newJoinNode.setTargets(targets.toArray(new Target[targets.size()]));
            }
            PlannerUtil.replaceNode(plan, block.getRoot(), old, newJoinNode);
            String optimizedOrder = JoinOrderStringBuilder.buildJoinOrderString(plan, block);
            block.addPlanHistory("Non-optimized join order: " + originalOrder + " (cost: " + nonOptimizedJoinCost + ")");
            block.addPlanHistory("Optimized join order    : " + optimizedOrder + " (cost: " + order.getCost() + ")");
        }
    }

    public static class JoinCostComputer
    extends BasicLogicalPlanVisitor<CostContext, LogicalNode> {
        private static final JoinCostComputer instance = new JoinCostComputer();

        public static double computeCost(LogicalPlan plan, LogicalPlan.QueryBlock block) throws PlanningException {
            CostContext costContext = new CostContext();
            instance.visit(costContext, plan, block);
            return costContext.accumulatedCost;
        }

        @Override
        public LogicalNode visitJoin(CostContext joinGraphContext, LogicalPlan plan, LogicalPlan.QueryBlock block, JoinNode joinNode, Stack<LogicalNode> stack) throws PlanningException {
            super.visitJoin(joinGraphContext, plan, block, joinNode, stack);
            double filterFactor = 1.0;
            if (joinNode.hasJoinQual()) {
                EvalNode[] quals = AlgebraicUtil.toConjunctiveNormalFormArray(joinNode.getJoinQual());
                filterFactor = Math.pow(GreedyHeuristicJoinOrderAlgorithm.DEFAULT_SELECTION_FACTOR, quals.length);
            }
            joinGraphContext.accumulatedCost = joinNode.getLeftChild() instanceof RelationNode ? GreedyHeuristicJoinOrderAlgorithm.getCost(joinNode.getLeftChild()) * GreedyHeuristicJoinOrderAlgorithm.getCost(joinNode.getRightChild()) * filterFactor : (joinGraphContext.accumulatedCost += joinGraphContext.accumulatedCost * GreedyHeuristicJoinOrderAlgorithm.getCost(joinNode.getRightChild()) * filterFactor);
            return joinNode;
        }
    }

    private static class CostContext {
        double accumulatedCost = 0.0;

        private CostContext() {
        }
    }

    public static class JoinOrderStringBuilder
    extends BasicLogicalPlanVisitor<StringBuilder, LogicalNode> {
        private static final JoinOrderStringBuilder instance = new JoinOrderStringBuilder();

        public static JoinOrderStringBuilder getInstance() {
            return instance;
        }

        public static String buildJoinOrderString(LogicalPlan plan, LogicalPlan.QueryBlock block) throws PlanningException {
            StringBuilder originalOrder = new StringBuilder();
            instance.visit(originalOrder, plan, block);
            return originalOrder.toString();
        }

        @Override
        public LogicalNode visitJoin(StringBuilder sb, LogicalPlan plan, LogicalPlan.QueryBlock block, JoinNode joinNode, Stack<LogicalNode> stack) throws PlanningException {
            stack.push(joinNode);
            sb.append("(");
            this.visit(sb, plan, block, (LogicalNode)joinNode.getLeftChild(), stack);
            sb.append(" ").append(JoinOrderStringBuilder.getJoinNotation(joinNode.getJoinType())).append(" ");
            this.visit(sb, plan, block, (LogicalNode)joinNode.getRightChild(), stack);
            sb.append(")");
            stack.pop();
            return joinNode;
        }

        private static String getJoinNotation(JoinType joinType) {
            switch (joinType) {
                case CROSS: {
                    return "\u22c8";
                }
                case INNER: {
                    return "\u22c8\u03b8";
                }
                case LEFT_OUTER: {
                    return "\u27d5";
                }
                case RIGHT_OUTER: {
                    return "\u27d6";
                }
                case FULL_OUTER: {
                    return "\u27d7";
                }
                case LEFT_SEMI: {
                    return "\u22c9";
                }
                case RIGHT_SEMI: {
                    return "\u22ca";
                }
                case LEFT_ANTI: {
                    return "\u25b7";
                }
            }
            return ",";
        }

        @Override
        public LogicalNode visitTableSubQuery(StringBuilder sb, LogicalPlan plan, LogicalPlan.QueryBlock block, TableSubQueryNode node, Stack<LogicalNode> stack) {
            sb.append(node.getTableName());
            return node;
        }

        @Override
        public LogicalNode visitScan(StringBuilder sb, LogicalPlan plan, LogicalPlan.QueryBlock block, ScanNode node, Stack<LogicalNode> stack) {
            sb.append(node.getTableName());
            return node;
        }
    }

    private static class JoinGraphBuilder
    extends BasicLogicalPlanVisitor<JoinGraphContext, LogicalNode> {
        private static final JoinGraphBuilder instance = new JoinGraphBuilder();

        private JoinGraphBuilder() {
        }

        public static JoinGraphContext buildJoinGraph(LogicalPlan plan, LogicalPlan.QueryBlock block) throws PlanningException {
            JoinGraphContext joinGraphContext = new JoinGraphContext();
            instance.visit(joinGraphContext, plan, block);
            return joinGraphContext;
        }

        @Override
        public LogicalNode visitFilter(JoinGraphContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, SelectionNode node, Stack<LogicalNode> stack) throws PlanningException {
            super.visitFilter(context, plan, block, node, stack);
            context.quals.addAll(Lists.newArrayList((Object[])AlgebraicUtil.toConjunctiveNormalFormArray(node.getQual())));
            return node;
        }

        @Override
        public LogicalNode visitJoin(JoinGraphContext joinGraphContext, LogicalPlan plan, LogicalPlan.QueryBlock block, JoinNode joinNode, Stack<LogicalNode> stack) throws PlanningException {
            super.visitJoin(joinGraphContext, plan, block, joinNode, stack);
            if (joinNode.hasJoinQual()) {
                joinGraphContext.joinGraph.addJoin(plan, block, joinNode);
            } else {
                RelationNode rel;
                Object leftChild = joinNode.getLeftChild();
                Object rightChild = joinNode.getRightChild();
                if (leftChild instanceof RelationNode) {
                    rel = (RelationNode)leftChild;
                    joinGraphContext.relationsForProduct.add(rel.getCanonicalName());
                }
                if (rightChild instanceof RelationNode) {
                    rel = (RelationNode)rightChild;
                    joinGraphContext.relationsForProduct.add(rel.getCanonicalName());
                }
            }
            return joinNode;
        }
    }

    private static class JoinGraphContext {
        JoinGraph joinGraph = new JoinGraph();
        Set<EvalNode> quals = Sets.newHashSet();
        Set<String> relationsForProduct = Sets.newHashSet();

        private JoinGraphContext() {
        }
    }

    private static class JoinTargetCollector
    extends BasicLogicalPlanVisitor<Set<Target>, LogicalNode> {
        private JoinTargetCollector() {
        }

        @Override
        public LogicalNode visitJoin(Set<Target> ctx, LogicalPlan plan, LogicalPlan.QueryBlock block, JoinNode node, Stack<LogicalNode> stack) throws PlanningException {
            super.visitJoin(ctx, plan, block, node, stack);
            if (node.hasTargets()) {
                for (Target target : node.getTargets()) {
                    ctx.add(target);
                }
            }
            return node;
        }
    }
}

