/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.tajo.algebra.ColumnReferenceExpr;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.FunctionExpr;
import org.apache.tajo.algebra.GeneralSetFunctionExpr;
import org.apache.tajo.algebra.JoinType;
import org.apache.tajo.algebra.LiteralValue;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.annotation.NotThreadSafe;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.plan.LogicalPlanner;
import org.apache.tajo.plan.NamedExprsManager;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.expr.ConstEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.LogicalRootNode;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.RelationNode;
import org.apache.tajo.plan.nameresolver.NameResolver;
import org.apache.tajo.plan.nameresolver.NameResolvingMode;
import org.apache.tajo.plan.visitor.ExplainLogicalPlanVisitor;
import org.apache.tajo.util.TUtil;
import org.apache.tajo.util.graph.DirectedGraphCursor;
import org.apache.tajo.util.graph.SimpleDirectedGraph;

@NotThreadSafe
public class LogicalPlan {
    public static final char VIRTUAL_TABLE_PREFIX = '#';
    public static final char NONAMED_COLUMN_PREFIX = '?';
    public static final String ROOT_BLOCK = "#ROOT";
    public static final String NONAME_BLOCK_PREFIX = "#QB_";
    private static final int NO_SEQUENCE_PID = -1;
    private int nextPid = 0;
    private Integer noNameBlockId = 0;
    private Integer noNameColumnId = 0;
    private Map<String, QueryBlock> queryBlocks = new LinkedHashMap<String, QueryBlock>();
    private Map<Integer, LogicalNode> nodeMap = new HashMap<Integer, LogicalNode>();
    private Map<Integer, QueryBlock> queryBlockByPID = new HashMap<Integer, QueryBlock>();
    private Map<String, String> exprToBlockNameMap = TUtil.newHashMap();
    private SimpleDirectedGraph<String, BlockEdge> queryBlockGraph = new SimpleDirectedGraph();
    private List<String> planingHistory = Lists.newArrayList();
    LogicalPlanner planner;
    private boolean isExplain;

    public LogicalPlan(LogicalPlanner planner) {
        this.planner = planner;
    }

    public <T extends LogicalNode> T createNode(Class<T> theClass) {
        try {
            Constructor<T> ctor = theClass.getConstructor(Integer.TYPE);
            return (T)((LogicalNode)ctor.newInstance(this.newPID()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends LogicalNode> T createNodeWithoutPID(Class<T> theClass) {
        try {
            Constructor<T> ctor = theClass.getConstructor(Integer.TYPE);
            return (T)((LogicalNode)ctor.newInstance(-1));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setExplain() {
        this.isExplain = true;
    }

    public boolean isExplain() {
        return this.isExplain;
    }

    public QueryBlock newAndGetBlock(String blockName) {
        QueryBlock block = new QueryBlock(blockName);
        this.queryBlocks.put(blockName, block);
        return block;
    }

    public int newPID() {
        return this.nextPid++;
    }

    public QueryBlock newQueryBlock() {
        Integer n = this.noNameBlockId;
        Integer n2 = this.noNameBlockId = Integer.valueOf(this.noNameBlockId + 1);
        return this.newAndGetBlock(NONAME_BLOCK_PREFIX + n);
    }

    public void resetGeneratedId() {
        this.noNameColumnId = 0;
    }

    public String generateUniqueColumnName(EvalNode evalNode) {
        String prefix = evalNode.getName();
        return this.attachSeqIdToGeneratedColumnName(prefix).toLowerCase();
    }

    public String generateUniqueColumnName(Expr expr) {
        String generatedName = expr.getType() == OpType.Column ? ((ColumnReferenceExpr)expr).getCanonicalName() : this.attachSeqIdToGeneratedColumnName(LogicalPlan.getGeneratedPrefixFromExpr(expr));
        return generatedName;
    }

    private String attachSeqIdToGeneratedColumnName(String prefix) {
        Integer n = this.noNameColumnId;
        Integer n2 = this.noNameColumnId = Integer.valueOf(this.noNameColumnId + 1);
        int sequence = n;
        return '?' + prefix.toLowerCase() + (sequence > 0 ? "_" + sequence : "");
    }

    private static String getGeneratedPrefixFromExpr(Expr expr) {
        String prefix;
        block0 : switch (expr.getType()) {
            case Column: {
                prefix = ((ColumnReferenceExpr)expr).getCanonicalName();
                break;
            }
            case CountRowsFunction: {
                prefix = "count";
                break;
            }
            case GeneralSetFunction: {
                GeneralSetFunctionExpr setFunction = (GeneralSetFunctionExpr)expr;
                prefix = setFunction.getSignature();
                break;
            }
            case Function: {
                FunctionExpr function = (FunctionExpr)expr;
                prefix = function.getSignature();
                break;
            }
            case Literal: {
                LiteralValue literal = (LiteralValue)expr;
                switch (literal.getValueType()) {
                    case Boolean: {
                        prefix = "bool";
                        break block0;
                    }
                    case String: {
                        prefix = "text";
                        break block0;
                    }
                    case Unsigned_Integer: 
                    case Unsigned_Large_Integer: {
                        prefix = "number";
                        break block0;
                    }
                    case Unsigned_Float: {
                        prefix = "real";
                        break block0;
                    }
                }
                throw new IllegalStateException(literal.getValueType() + " is not implemented");
            }
            case DateLiteral: {
                prefix = "date";
                break;
            }
            case TimeLiteral: {
                prefix = "time";
                break;
            }
            case TimestampLiteral: {
                prefix = "timestamp";
                break;
            }
            default: {
                prefix = expr.getType().name();
            }
        }
        return prefix;
    }

    public QueryBlock getRootBlock() {
        return this.queryBlocks.get(ROOT_BLOCK);
    }

    public QueryBlock getBlock(String blockName) {
        return this.queryBlocks.get(blockName);
    }

    public QueryBlock getBlock(LogicalNode node) {
        return this.queryBlockByPID.get(node.getPID());
    }

    public void removeBlock(QueryBlock block) {
        this.queryBlocks.remove(block.getName());
        ArrayList<Integer> tobeRemoved = new ArrayList<Integer>();
        for (Map.Entry<Integer, QueryBlock> entry : this.queryBlockByPID.entrySet()) {
            tobeRemoved.add(entry.getKey());
        }
        for (Integer rn : tobeRemoved) {
            this.queryBlockByPID.remove(rn);
        }
    }

    public void disconnectBlocks(QueryBlock srcBlock, QueryBlock targetBlock) {
        this.queryBlockGraph.removeEdge((Object)srcBlock.getName(), (Object)targetBlock.getName());
    }

    public void connectBlocks(QueryBlock srcBlock, QueryBlock targetBlock, BlockType type) {
        this.queryBlockGraph.addEdge((Object)srcBlock.getName(), (Object)targetBlock.getName(), (Object)new BlockEdge(srcBlock, targetBlock, type));
    }

    public QueryBlock getParentBlock(QueryBlock block) {
        return this.queryBlocks.get(this.queryBlockGraph.getParent((Object)block.getName(), 0));
    }

    public List<QueryBlock> getChildBlocks(QueryBlock block) {
        List childBlocks = TUtil.newList();
        for (String blockName : this.queryBlockGraph.getChilds((Object)block.getName())) {
            childBlocks.add(this.queryBlocks.get(blockName));
        }
        return childBlocks;
    }

    public void mapExprToBlock(Expr expr, String blockName) {
        this.exprToBlockNameMap.put(ObjectUtils.identityToString((Object)expr), blockName);
    }

    public QueryBlock getBlockByExpr(Expr expr) {
        return this.getBlock(this.exprToBlockNameMap.get(ObjectUtils.identityToString((Object)expr)));
    }

    public String getBlockNameByExpr(Expr expr) {
        return this.exprToBlockNameMap.get(ObjectUtils.identityToString((Object)expr));
    }

    public Collection<QueryBlock> getQueryBlocks() {
        return this.queryBlocks.values();
    }

    public SimpleDirectedGraph<String, BlockEdge> getQueryBlockGraph() {
        return this.queryBlockGraph;
    }

    public Column resolveColumn(QueryBlock block, ColumnReferenceExpr columnRef) throws PlanningException {
        return NameResolver.resolve(this, block, columnRef, NameResolvingMode.LEGACY);
    }

    public String getQueryGraphAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n-----------------------------\n");
        sb.append("Query Block Graph\n");
        sb.append("-----------------------------\n");
        sb.append(this.queryBlockGraph.toStringGraph((Object)this.getRootBlock().getName()));
        sb.append("-----------------------------\n");
        sb.append("Optimization Log:\n");
        if (!this.planingHistory.isEmpty()) {
            sb.append("[LogicalPlan]\n");
            for (String eachHistory : this.planingHistory) {
                sb.append("\t> ").append(eachHistory).append("\n");
            }
        }
        DirectedGraphCursor cursor = new DirectedGraphCursor(this.queryBlockGraph, (Object)this.getRootBlock().getName());
        while (cursor.hasNext()) {
            QueryBlock block = this.getBlock((String)cursor.nextBlock());
            if (block.getPlanHistory().size() <= 0) continue;
            sb.append("[").append(block.getName()).append("]\n");
            for (String log : block.getPlanHistory()) {
                sb.append("\t> ").append(log).append("\n");
            }
        }
        sb.append("-----------------------------\n");
        sb.append("\n");
        sb.append(this.getLogicalPlanAsString());
        return sb.toString();
    }

    public String getLogicalPlanAsString() {
        ExplainLogicalPlanVisitor explain = new ExplainLogicalPlanVisitor();
        StringBuilder explains = new StringBuilder();
        try {
            ExplainLogicalPlanVisitor.Context explainContext = explain.getBlockPlanStrings(this, (LogicalNode)this.getRootBlock().getRoot());
            while (!explainContext.explains.empty()) {
                explains.append(ExplainLogicalPlanVisitor.printDepthString(explainContext.getMaxDepth(), explainContext.explains.pop()));
            }
        }
        catch (PlanningException e) {
            throw new RuntimeException(e);
        }
        return explains.toString();
    }

    public void addHistory(String string) {
        this.planingHistory.add(string);
    }

    public List<String> getHistory() {
        return this.planingHistory;
    }

    public String toString() {
        return this.getQueryGraphAsString();
    }

    public class QueryBlock {
        private final String blockName;
        private LogicalNode rootNode;
        private NodeType rootType;
        private final Map<String, RelationNode> canonicalNameToRelationMap = TUtil.newHashMap();
        private final Map<String, List<String>> relationAliasMap = TUtil.newHashMap();
        private final Map<String, String> columnAliasMap = TUtil.newHashMap();
        private final Map<OpType, List<Expr>> operatorToExprMap = TUtil.newHashMap();
        private final List<RelationNode> relationList = TUtil.newList();
        private boolean hasWindowFunction = false;
        private final Map<String, ConstEval> constantPoolByRef = Maps.newHashMap();
        private final Map<Expr, String> constantPool = Maps.newHashMap();
        private final Map<NodeType, LogicalNode> nodeTypeToNodeMap = TUtil.newHashMap();
        private final Map<String, LogicalNode> exprToNodeMap = TUtil.newHashMap();
        final NamedExprsManager namedExprsMgr;
        private LogicalNode currentNode;
        private LogicalNode latestNode;
        private final Set<JoinType> includedJoinTypes = TUtil.newHashSet();
        private boolean aggregationRequired = false;
        private Schema schema;
        private final List<String> planingHistory = Lists.newArrayList();
        private Target[] rawTargets;

        public QueryBlock(String blockName) {
            this.blockName = blockName;
            this.namedExprsMgr = new NamedExprsManager(LogicalPlan.this, this);
        }

        public String getName() {
            return this.blockName;
        }

        public void refresh() {
            this.setRoot(this.rootNode);
        }

        public void setRoot(LogicalNode blockRoot) {
            this.rootNode = blockRoot;
            if (blockRoot instanceof LogicalRootNode) {
                LogicalRootNode rootNode = (LogicalRootNode)blockRoot;
                this.rootType = ((LogicalNode)rootNode.getChild()).getType();
            }
        }

        public <NODE extends LogicalNode> NODE getRoot() {
            return (NODE)this.rootNode;
        }

        public NodeType getRootType() {
            return this.rootType;
        }

        public Target[] getRawTargets() {
            return this.rawTargets;
        }

        public void setRawTargets(Target[] rawTargets) {
            this.rawTargets = rawTargets;
        }

        public boolean existsRelation(String name) {
            return this.canonicalNameToRelationMap.containsKey(name);
        }

        public boolean isAlreadyRenamedTableName(String name) {
            return this.relationAliasMap.containsKey(name);
        }

        public RelationNode getRelation(String name) {
            if (this.canonicalNameToRelationMap.containsKey(name)) {
                return this.canonicalNameToRelationMap.get(name);
            }
            if (this.relationAliasMap.containsKey(name)) {
                return this.canonicalNameToRelationMap.get(this.relationAliasMap.get(name).get(0));
            }
            return null;
        }

        public void addRelation(RelationNode relation) {
            if (relation.hasAlias()) {
                TUtil.putToNestedList(this.relationAliasMap, (Object)relation.getTableName(), (Object)relation.getCanonicalName());
            }
            this.canonicalNameToRelationMap.put(relation.getCanonicalName(), relation);
            this.relationList.add(relation);
        }

        public Collection<RelationNode> getRelations() {
            return Collections.unmodifiableList(this.relationList);
        }

        public boolean hasTableExpression() {
            return this.canonicalNameToRelationMap.size() > 0;
        }

        public void addConstReference(String refName, Expr expr, ConstEval value) {
            this.constantPoolByRef.put(refName, value);
            this.constantPool.put(expr, refName);
        }

        public boolean isConstReference(String refName) {
            return this.constantPoolByRef.containsKey(refName);
        }

        public boolean isRegisteredConst(Expr expr) {
            return this.constantPool.containsKey(expr);
        }

        public String getConstReference(Expr expr) {
            return this.constantPool.get(expr);
        }

        public ConstEval getConstByReference(String refName) {
            return this.constantPoolByRef.get(refName);
        }

        public void addColumnAlias(String original, String alias) {
            this.columnAliasMap.put(alias, original);
        }

        public boolean isAliasedName(String alias) {
            return this.columnAliasMap.containsKey(alias);
        }

        public String getOriginalName(String alias) {
            return this.columnAliasMap.get(alias);
        }

        public void setSchema(Schema schema) {
            this.schema = schema;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public NamedExprsManager getNamedExprsManager() {
            return this.namedExprsMgr;
        }

        public void updateCurrentNode(Expr expr) throws PlanningException {
            if (expr.getType() != OpType.RelationList) {
                this.currentNode = this.exprToNodeMap.get(ObjectUtils.identityToString((Object)expr));
                if (this.currentNode == null) {
                    throw new PlanningException("Unregistered Algebra Expression: " + expr.getType());
                }
            }
        }

        public <T extends LogicalNode> T getCurrentNode() {
            return (T)this.currentNode;
        }

        public void updateLatestNode(LogicalNode node) {
            this.latestNode = node;
        }

        public <T extends LogicalNode> T getLatestNode() {
            return (T)this.latestNode;
        }

        public void setAlgebraicExpr(Expr expr) {
            TUtil.putToNestedList(this.operatorToExprMap, (Object)expr.getType(), (Object)expr);
        }

        public boolean hasAlgebraicExpr(OpType opType) {
            return this.operatorToExprMap.containsKey(opType);
        }

        public <T extends Expr> List<T> getAlgebraicExpr(OpType opType) {
            return this.operatorToExprMap.get(opType);
        }

        public <T extends Expr> T getSingletonExpr(OpType opType) {
            if (this.hasAlgebraicExpr(opType)) {
                return (T)this.operatorToExprMap.get(opType).get(0);
            }
            return null;
        }

        public boolean hasNode(NodeType nodeType) {
            return this.nodeTypeToNodeMap.containsKey((Object)nodeType);
        }

        public void registerNode(LogicalNode node) {
            LogicalPlan.this.nodeMap.put(node.getPID(), node);
            this.nodeTypeToNodeMap.put(node.getType(), node);
            LogicalPlan.this.queryBlockByPID.put(node.getPID(), this);
        }

        public void unregisterNode(LogicalNode node) {
            LogicalPlan.this.nodeMap.remove(node.getPID());
            this.nodeTypeToNodeMap.remove((Object)node.getType());
            LogicalPlan.this.queryBlockByPID.remove(node.getPID());
        }

        public <T extends LogicalNode> T getNode(NodeType nodeType) {
            return (T)this.nodeTypeToNodeMap.get((Object)nodeType);
        }

        public void registerExprWithNode(Expr expr, LogicalNode node) {
            this.exprToNodeMap.put(ObjectUtils.identityToString((Object)expr), node);
        }

        public <T extends LogicalNode> T getNodeFromExpr(Expr expr) {
            return (T)this.exprToNodeMap.get(ObjectUtils.identityToString((Object)expr));
        }

        public void setHasWindowFunction() {
            this.hasWindowFunction = true;
        }

        public boolean hasWindowSpecs() {
            return this.hasWindowFunction;
        }

        public boolean isAggregationRequired() {
            return this.aggregationRequired;
        }

        public void unsetAggregationRequire() {
            this.aggregationRequired = false;
        }

        public void setAggregationRequire() {
            this.aggregationRequired = true;
        }

        public boolean containsJoinType(JoinType joinType) {
            return this.includedJoinTypes.contains(joinType);
        }

        public void addJoinType(JoinType joinType) {
            this.includedJoinTypes.add(joinType);
        }

        public List<String> getPlanHistory() {
            return this.planingHistory;
        }

        public void addPlanHistory(String history) {
            this.planingHistory.add(history);
        }

        public String toString() {
            return this.blockName;
        }
    }

    public static class BlockEdge {
        private String childName;
        private String parentName;
        private BlockType blockType;

        public BlockEdge(String childName, String parentName, BlockType blockType) {
            this.childName = childName;
            this.parentName = parentName;
            this.blockType = blockType;
        }

        public BlockEdge(QueryBlock child, QueryBlock parent, BlockType blockType) {
            this(child.getName(), parent.getName(), blockType);
        }

        public String getParentName() {
            return this.parentName;
        }

        public String getChildName() {
            return this.childName;
        }

        public BlockType getBlockType() {
            return this.blockType;
        }
    }

    public static enum BlockType {
        TableSubQuery,
        ScalarSubQuery;

    }
}

