/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.tajo.ConfigKey;
import org.apache.tajo.OverridableConf;
import org.apache.tajo.SessionVars;
import org.apache.tajo.algebra.Aggregation;
import org.apache.tajo.algebra.AlterTable;
import org.apache.tajo.algebra.AlterTablespace;
import org.apache.tajo.algebra.ColumnDefinition;
import org.apache.tajo.algebra.ColumnReferenceExpr;
import org.apache.tajo.algebra.CreateDatabase;
import org.apache.tajo.algebra.CreateTable;
import org.apache.tajo.algebra.DataTypeExpr;
import org.apache.tajo.algebra.DropDatabase;
import org.apache.tajo.algebra.DropTable;
import org.apache.tajo.algebra.Explain;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.Having;
import org.apache.tajo.algebra.Insert;
import org.apache.tajo.algebra.Join;
import org.apache.tajo.algebra.JoinType;
import org.apache.tajo.algebra.Limit;
import org.apache.tajo.algebra.NamedExpr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.algebra.Projection;
import org.apache.tajo.algebra.Relation;
import org.apache.tajo.algebra.RelationList;
import org.apache.tajo.algebra.Selection;
import org.apache.tajo.algebra.SetOperation;
import org.apache.tajo.algebra.SetSession;
import org.apache.tajo.algebra.Sort;
import org.apache.tajo.algebra.TablePrimarySubQuery;
import org.apache.tajo.algebra.TruncateTable;
import org.apache.tajo.algebra.WindowFunctionExpr;
import org.apache.tajo.algebra.WindowSpec;
import org.apache.tajo.catalog.CatalogService;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.SchemaUtil;
import org.apache.tajo.catalog.SortSpec;
import org.apache.tajo.catalog.TableDesc;
import org.apache.tajo.catalog.partition.PartitionMethodDesc;
import org.apache.tajo.catalog.proto.CatalogProtos;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.plan.ExprAnnotator;
import org.apache.tajo.plan.ExprNormalizer;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.LogicalPlanPreprocessor;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.algebra.BaseAlgebraVisitor;
import org.apache.tajo.plan.expr.AggregationFunctionCallEval;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.ConstEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalTreeUtil;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.FieldEval;
import org.apache.tajo.plan.expr.WindowFunctionEval;
import org.apache.tajo.plan.exprrewrite.EvalTreeOptimizer;
import org.apache.tajo.plan.logical.AlterTableNode;
import org.apache.tajo.plan.logical.AlterTablespaceNode;
import org.apache.tajo.plan.logical.BinaryNode;
import org.apache.tajo.plan.logical.CreateDatabaseNode;
import org.apache.tajo.plan.logical.CreateTableNode;
import org.apache.tajo.plan.logical.DropDatabaseNode;
import org.apache.tajo.plan.logical.DropTableNode;
import org.apache.tajo.plan.logical.EvalExprNode;
import org.apache.tajo.plan.logical.GroupbyNode;
import org.apache.tajo.plan.logical.HavingNode;
import org.apache.tajo.plan.logical.InsertNode;
import org.apache.tajo.plan.logical.JoinNode;
import org.apache.tajo.plan.logical.LimitNode;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.LogicalRootNode;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.Projectable;
import org.apache.tajo.plan.logical.ProjectionNode;
import org.apache.tajo.plan.logical.RelationNode;
import org.apache.tajo.plan.logical.ScanNode;
import org.apache.tajo.plan.logical.SelectionNode;
import org.apache.tajo.plan.logical.SetSessionNode;
import org.apache.tajo.plan.logical.SortNode;
import org.apache.tajo.plan.logical.TableSubQueryNode;
import org.apache.tajo.plan.logical.TruncateTableNode;
import org.apache.tajo.plan.logical.UnaryNode;
import org.apache.tajo.plan.logical.UnionNode;
import org.apache.tajo.plan.logical.WindowAggNode;
import org.apache.tajo.plan.nameresolver.NameResolvingMode;
import org.apache.tajo.plan.rewrite.rules.ProjectionPushDownRule;
import org.apache.tajo.plan.util.ExprFinder;
import org.apache.tajo.plan.util.PlannerUtil;
import org.apache.tajo.plan.verifier.VerifyException;
import org.apache.tajo.util.KeyValueSet;
import org.apache.tajo.util.Pair;
import org.apache.tajo.util.TUtil;

public class LogicalPlanner
extends BaseAlgebraVisitor<PlanContext, LogicalNode> {
    private static Log LOG = LogFactory.getLog(LogicalPlanner.class);
    private final CatalogService catalog;
    private final LogicalPlanPreprocessor preprocessor;
    private final EvalTreeOptimizer evalOptimizer;
    private final ExprAnnotator exprAnnotator;
    private final ExprNormalizer normalizer;
    private static final Column[] ALL = Lists.newArrayList().toArray(new Column[0]);

    public LogicalPlanner(CatalogService catalog) {
        this.catalog = catalog;
        this.exprAnnotator = new ExprAnnotator(catalog);
        this.preprocessor = new LogicalPlanPreprocessor(catalog, this.exprAnnotator);
        this.normalizer = new ExprNormalizer();
        this.evalOptimizer = new EvalTreeOptimizer();
    }

    public LogicalPlan createPlan(OverridableConf context, Expr expr) throws PlanningException {
        return this.createPlan(context, expr, false);
    }

    @VisibleForTesting
    public LogicalPlan createPlan(OverridableConf queryContext, Expr expr, boolean debug) throws PlanningException {
        LogicalPlan plan = new LogicalPlan(this);
        LogicalPlan.QueryBlock rootBlock = plan.newAndGetBlock("#ROOT");
        PlanContext context = new PlanContext(queryContext, plan, rootBlock, this.evalOptimizer, debug);
        this.preprocessor.visit(context, new Stack<Expr>(), expr);
        plan.resetGeneratedId();
        LogicalNode topMostNode = (LogicalNode)this.visit(context, new Stack<Expr>(), expr);
        LogicalRootNode root = plan.createNode(LogicalRootNode.class);
        root.setInSchema(topMostNode.getOutSchema());
        root.setChild(topMostNode);
        root.setOutSchema(topMostNode.getOutSchema());
        plan.getRootBlock().setRoot(root);
        return plan;
    }

    public ExprAnnotator getExprAnnotator() {
        return this.exprAnnotator;
    }

    @Override
    public void preHook(PlanContext context, Stack<Expr> stack, Expr expr) throws PlanningException {
        context.queryBlock.updateCurrentNode(expr);
    }

    @Override
    public LogicalNode postHook(PlanContext context, Stack<Expr> stack, Expr expr, LogicalNode current) throws PlanningException {
        if (expr != null && expr.getType() == OpType.RelationList && current.getType() == NodeType.SCAN) {
            return current;
        }
        LogicalPlan.QueryBlock queryBlock = context.queryBlock;
        queryBlock.updateLatestNode(current);
        if (stack.size() == 0) {
            queryBlock.setRoot(current);
        }
        if (!stack.empty()) {
            queryBlock.updateCurrentNode(stack.peek());
        }
        return current;
    }

    @Override
    public LogicalNode visitSetSession(PlanContext context, Stack<Expr> stack, SetSession expr) throws PlanningException {
        LogicalPlan.QueryBlock block = context.queryBlock;
        SetSessionNode setSessionNode = (SetSessionNode)block.getNodeFromExpr((Expr)expr);
        setSessionNode.init(expr.getName(), expr.getValue());
        return setSessionNode;
    }

    @Override
    public LogicalNode visitExplain(PlanContext ctx, Stack<Expr> stack, Explain expr) throws PlanningException {
        ctx.plan.setExplain();
        return (LogicalNode)this.visit(ctx, stack, expr.getChild());
    }

    @Override
    public LogicalNode visitProjection(PlanContext context, Stack<Expr> stack, Projection projection) throws PlanningException {
        LogicalNode windowAggNode;
        LogicalPlan plan = context.plan;
        LogicalPlan.QueryBlock block = context.queryBlock;
        if (!projection.hasChild()) {
            return this.buildPlanForNoneFromStatement(context, stack, projection);
        }
        Pair<String[], ExprNormalizer.WindowSpecReferences[]> referencesPair = this.doProjectionPrephase(context, projection);
        String[] referenceNames = (String[])referencesPair.getFirst();
        stack.push((Expr)projection);
        LogicalNode child = (LogicalNode)this.visit(context, stack, projection.getChild());
        if (block.isAggregationRequired()) {
            child = this.insertGroupbyNode(context, child, stack);
        }
        if (block.hasWindowSpecs() && (windowAggNode = this.insertWindowAggNode(context, child, stack, referenceNames, (ExprNormalizer.WindowSpecReferences[])referencesPair.getSecond())) != null) {
            child = windowAggNode;
        }
        stack.pop();
        Target[] targets = this.buildTargets(context, referenceNames);
        ProjectionNode projectionNode = (ProjectionNode)context.queryBlock.getNodeFromExpr((Expr)projection);
        projectionNode.init(projection.isDistinct(), targets);
        projectionNode.setChild(child);
        projectionNode.setInSchema(child.getOutSchema());
        if (projection.isDistinct() && block.hasNode(NodeType.GROUP_BY)) {
            throw new VerifyException("Cannot support grouping and distinct at the same time yet");
        }
        if (projection.isDistinct()) {
            this.insertDistinctOperator(context, projectionNode, child, stack);
        }
        if (context.debugOrUnitTests) {
            this.setRawTargets(context, targets, referenceNames, projection);
        }
        LogicalPlanner.verifyProjectedFields(block, projectionNode);
        return projectionNode;
    }

    private void setRawTargets(PlanContext context, Target[] targets, String[] referenceNames, Projection projection) throws PlanningException {
        LogicalPlan plan = context.plan;
        LogicalPlan.QueryBlock block = context.queryBlock;
        Target[] rawTargets = new Target[projection.getNamedExprs().length];
        for (int i = 0; i < projection.getNamedExprs().length; ++i) {
            NamedExpr namedExpr = projection.getNamedExprs()[i];
            EvalNode evalNode = this.exprAnnotator.createEvalNode(context, namedExpr.getExpr(), NameResolvingMode.RELS_AND_SUBEXPRS);
            rawTargets[i] = new Target(evalNode, referenceNames[i]);
        }
        block.setRawTargets(rawTargets);
    }

    private void insertDistinctOperator(PlanContext context, ProjectionNode projectionNode, LogicalNode child, Stack<Expr> stack) throws PlanningException {
        LogicalPlan plan = context.plan;
        LogicalPlan.QueryBlock block = context.queryBlock;
        Schema outSchema = projectionNode.getOutSchema();
        GroupbyNode dupRemoval = context.plan.createNode(GroupbyNode.class);
        dupRemoval.setChild(child);
        dupRemoval.setInSchema(projectionNode.getInSchema());
        dupRemoval.setTargets(PlannerUtil.schemaToTargets(outSchema));
        dupRemoval.setGroupingColumns(outSchema.toArray());
        block.registerNode(dupRemoval);
        this.postHook(context, stack, (Expr)null, dupRemoval);
        projectionNode.setChild(dupRemoval);
        projectionNode.setInSchema(dupRemoval.getOutSchema());
    }

    private Pair<String[], ExprNormalizer.WindowSpecReferences[]> doProjectionPrephase(PlanContext context, Projection projection) throws PlanningException {
        LogicalPlan.QueryBlock block = context.queryBlock;
        int finalTargetNum = projection.size();
        String[] referenceNames = new String[finalTargetNum];
        ExprNormalizer.ExprNormalizedResult[] normalizedExprList = new ExprNormalizer.ExprNormalizedResult[finalTargetNum];
        List windowSpecReferencesList = TUtil.newList();
        List<Integer> targetsIds = this.normalize(context, projection, normalizedExprList, new Matcher(){

            @Override
            public boolean isMatch(Expr expr) {
                return ExprFinder.finds(expr, OpType.WindowFunction).size() == 0;
            }
        });
        this.addNamedExprs(block, referenceNames, normalizedExprList, windowSpecReferencesList, projection, targetsIds);
        targetsIds = this.normalize(context, projection, normalizedExprList, new Matcher(){

            @Override
            public boolean isMatch(Expr expr) {
                return ExprFinder.finds(expr, OpType.WindowFunction).size() > 0;
            }
        });
        this.addNamedExprs(block, referenceNames, normalizedExprList, windowSpecReferencesList, projection, targetsIds);
        return new Pair((Object)referenceNames, (Object)windowSpecReferencesList.toArray(new ExprNormalizer.WindowSpecReferences[windowSpecReferencesList.size()]));
    }

    public List<Integer> normalize(PlanContext context, Projection projection, ExprNormalizer.ExprNormalizedResult[] normalizedExprList, Matcher matcher) throws PlanningException {
        ArrayList<Integer> targetIds = new ArrayList<Integer>();
        for (int i = 0; i < projection.size(); ++i) {
            NamedExpr namedExpr = projection.getNamedExprs()[i];
            if (PlannerUtil.existsAggregationFunction((Expr)namedExpr)) {
                context.queryBlock.setAggregationRequire();
            }
            if (!matcher.isMatch(namedExpr.getExpr())) continue;
            if (!namedExpr.hasAlias() && OpType.isLiteralType((OpType)namedExpr.getExpr().getType())) {
                String generatedName = context.plan.generateUniqueColumnName(namedExpr.getExpr());
                ConstEval constEval = (ConstEval)this.exprAnnotator.createEvalNode(context, namedExpr.getExpr(), NameResolvingMode.RELS_ONLY);
                context.getQueryBlock().addConstReference(generatedName, namedExpr.getExpr(), constEval);
                normalizedExprList[i] = new ExprNormalizer.ExprNormalizedResult(context, false);
                normalizedExprList[i].baseExpr = new ColumnReferenceExpr(generatedName);
            } else {
                normalizedExprList[i] = this.normalizer.normalize(context, namedExpr.getExpr());
            }
            targetIds.add(i);
        }
        return targetIds;
    }

    private void addNamedExprs(LogicalPlan.QueryBlock block, String[] referenceNames, ExprNormalizer.ExprNormalizedResult[] normalizedExprList, List<ExprNormalizer.WindowSpecReferences> windowSpecReferencesList, Projection projection, List<Integer> targetIds) throws PlanningException {
        for (int i : targetIds) {
            NamedExpr namedExpr = projection.getNamedExprs()[i];
            if (namedExpr.hasAlias()) {
                NamedExpr aliasedExpr = new NamedExpr(normalizedExprList[i].baseExpr, namedExpr.getAlias());
                referenceNames[i] = block.namedExprsMgr.addNamedExpr(aliasedExpr);
            } else {
                referenceNames[i] = block.namedExprsMgr.addExpr(normalizedExprList[i].baseExpr);
            }
            block.namedExprsMgr.addNamedExprArray(normalizedExprList[i].aggExprs);
            block.namedExprsMgr.addNamedExprArray(normalizedExprList[i].scalarExprs);
            block.namedExprsMgr.addNamedExprArray(normalizedExprList[i].windowAggExprs);
            windowSpecReferencesList.addAll(normalizedExprList[i].windowSpecs);
        }
    }

    private EvalExprNode buildPlanForNoneFromStatement(PlanContext context, Stack<Expr> stack, Projection projection) throws PlanningException {
        LogicalPlan plan = context.plan;
        LogicalPlan.QueryBlock block = context.queryBlock;
        int finalTargetNum = projection.getNamedExprs().length;
        Target[] targets = new Target[finalTargetNum];
        for (int i = 0; i < targets.length; ++i) {
            NamedExpr namedExpr = projection.getNamedExprs()[i];
            EvalNode evalNode = this.exprAnnotator.createEvalNode(context, namedExpr.getExpr(), NameResolvingMode.RELS_ONLY);
            targets[i] = namedExpr.hasAlias() ? new Target(evalNode, namedExpr.getAlias()) : new Target(evalNode, context.plan.generateUniqueColumnName(namedExpr.getExpr()));
        }
        EvalExprNode evalExprNode = (EvalExprNode)context.queryBlock.getNodeFromExpr((Expr)projection);
        evalExprNode.setTargets(targets);
        evalExprNode.setOutSchema(PlannerUtil.targetToSchema(targets));
        block.setRawTargets(targets);
        return evalExprNode;
    }

    private Target[] buildTargets(PlanContext context, String[] referenceNames) throws PlanningException {
        LogicalPlan.QueryBlock block = context.queryBlock;
        Target[] targets = new Target[referenceNames.length];
        for (int i = 0; i < referenceNames.length; ++i) {
            String refName = referenceNames[i];
            if (block.isConstReference(refName)) {
                targets[i] = new Target(block.getConstByReference(refName), refName);
                continue;
            }
            if (block.namedExprsMgr.isEvaluated(refName)) {
                targets[i] = block.namedExprsMgr.getTarget(refName);
                continue;
            }
            NamedExpr namedExpr = block.namedExprsMgr.getNamedExpr(refName);
            EvalNode evalNode = this.exprAnnotator.createEvalNode(context, namedExpr.getExpr(), NameResolvingMode.RELS_AND_SUBEXPRS);
            block.namedExprsMgr.markAsEvaluated(refName, evalNode);
            targets[i] = new Target(evalNode, refName);
        }
        return targets;
    }

    public static void verifyProjectedFields(LogicalPlan.QueryBlock block, Projectable projectable) throws PlanningException {
        if (projectable instanceof GroupbyNode) {
            GroupbyNode groupbyNode = (GroupbyNode)projectable;
            if (!groupbyNode.isEmptyGrouping()) {
                int groupingKeyNum = groupbyNode.getGroupingColumns().length;
                for (int i = 0; i < groupingKeyNum; ++i) {
                    Target target = groupbyNode.getTargets()[i];
                    if (((EvalNode)groupbyNode.getTargets()[i].getEvalTree()).getType() != EvalType.FIELD) continue;
                    FieldEval grpKeyEvalNode = (FieldEval)target.getEvalTree();
                    if (groupbyNode.getInSchema().contains(grpKeyEvalNode.getColumnRef())) continue;
                    LogicalPlanner.throwCannotEvaluateException(projectable, grpKeyEvalNode.getName());
                }
            }
            if (groupbyNode.hasAggFunctions()) {
                LogicalPlanner.verifyIfEvalNodesCanBeEvaluated(projectable, groupbyNode.getAggFunctions());
            }
        } else if (projectable instanceof WindowAggNode) {
            WindowAggNode windowAggNode = (WindowAggNode)projectable;
            if (windowAggNode.hasPartitionKeys()) {
                LogicalPlanner.verifyIfColumnCanBeEvaluated(projectable.getInSchema(), projectable, windowAggNode.getPartitionKeys());
            }
            if (windowAggNode.hasAggFunctions()) {
                LogicalPlanner.verifyIfEvalNodesCanBeEvaluated(projectable, windowAggNode.getWindowFunctions());
            }
            if (windowAggNode.hasSortSpecs()) {
                Column[] sortKeys = PlannerUtil.sortSpecsToSchema(windowAggNode.getSortSpecs()).toArray();
                LogicalPlanner.verifyIfColumnCanBeEvaluated(projectable.getInSchema(), projectable, sortKeys);
            }
            for (int i = 0; i < windowAggNode.getTargets().length - windowAggNode.getWindowFunctions().length; ++i) {
                Target target = windowAggNode.getTargets()[i];
                LinkedHashSet<Column> columns = EvalTreeUtil.findUniqueColumns(target.getEvalTree());
                for (Column c : columns) {
                    if (windowAggNode.getInSchema().contains(c)) continue;
                    LogicalPlanner.throwCannotEvaluateException(projectable, c.getQualifiedName());
                }
            }
        } else if (projectable instanceof RelationNode) {
            RelationNode relationNode = (RelationNode)((Object)projectable);
            LogicalPlanner.verifyIfTargetsCanBeEvaluated(relationNode.getLogicalSchema(), (Projectable)((Object)relationNode));
        } else {
            LogicalPlanner.verifyIfTargetsCanBeEvaluated(projectable.getInSchema(), projectable);
        }
    }

    public static void verifyIfEvalNodesCanBeEvaluated(Projectable projectable, EvalNode[] evalNodes) throws PlanningException {
        for (EvalNode e : evalNodes) {
            LinkedHashSet<Column> columns = EvalTreeUtil.findUniqueColumns(e);
            for (Column c : columns) {
                if (projectable.getInSchema().contains(c)) continue;
                LogicalPlanner.throwCannotEvaluateException(projectable, c.getQualifiedName());
            }
        }
    }

    public static void verifyIfTargetsCanBeEvaluated(Schema baseSchema, Projectable projectable) throws PlanningException {
        for (Target target : projectable.getTargets()) {
            LinkedHashSet<Column> columns = EvalTreeUtil.findUniqueColumns(target.getEvalTree());
            for (Column c : columns) {
                if (baseSchema.contains(c)) continue;
                LogicalPlanner.throwCannotEvaluateException(projectable, c.getQualifiedName());
            }
        }
    }

    public static void verifyIfColumnCanBeEvaluated(Schema baseSchema, Projectable projectable, Column[] columns) throws PlanningException {
        for (Column c : columns) {
            if (baseSchema.contains(c)) continue;
            LogicalPlanner.throwCannotEvaluateException(projectable, c.getQualifiedName());
        }
    }

    public static void throwCannotEvaluateException(Projectable projectable, String columnName) throws PlanningException {
        if (projectable instanceof UnaryNode && ((LogicalNode)((UnaryNode)((Object)projectable)).getChild()).getType() == NodeType.GROUP_BY) {
            throw new PlanningException(columnName + " must appear in the GROUP BY clause or be used in an aggregate function at node (" + projectable.getPID() + ")");
        }
        throw new PlanningException(String.format("Cannot evaluate the field \"%s\" at node (%d)", columnName, projectable.getPID()));
    }

    private LogicalNode insertWindowAggNode(PlanContext context, LogicalNode child, Stack<Expr> stack, String[] referenceNames, ExprNormalizer.WindowSpecReferences[] windowSpecReferenceses) throws PlanningException {
        int i;
        LogicalPlan plan = context.plan;
        LogicalPlan.QueryBlock block = context.queryBlock;
        WindowAggNode windowAggNode = context.plan.createNode(WindowAggNode.class);
        if (child.getType() == NodeType.LIMIT) {
            LimitNode limitNode = (LimitNode)child;
            windowAggNode.setChild((LogicalNode)limitNode.getChild());
            windowAggNode.setInSchema(((LogicalNode)limitNode.getChild()).getOutSchema());
            limitNode.setChild(windowAggNode);
        } else if (child.getType() == NodeType.SORT) {
            SortNode sortNode = (SortNode)child;
            windowAggNode.setChild((LogicalNode)sortNode.getChild());
            windowAggNode.setInSchema(((LogicalNode)sortNode.getChild()).getOutSchema());
            sortNode.setChild(windowAggNode);
        } else {
            windowAggNode.setChild(child);
            windowAggNode.setInSchema(child.getOutSchema());
        }
        ArrayList<String> winFuncRefs = new ArrayList<String>();
        ArrayList<WindowFunctionEval> winFuncs = new ArrayList<WindowFunctionEval>();
        ArrayList rawWindowSpecs = Lists.newArrayList();
        Iterator<NamedExpr> it = block.namedExprsMgr.getIteratorForUnevaluatedExprs();
        while (it.hasNext()) {
            NamedExpr rawTarget = it.next();
            try {
                EvalNode evalNode = this.exprAnnotator.createEvalNode(context, rawTarget.getExpr(), NameResolvingMode.SUBEXPRS_AND_RELS);
                if (evalNode.getType() != EvalType.WINDOW_FUNCTION) continue;
                winFuncRefs.add(rawTarget.getAlias());
                winFuncs.add((WindowFunctionEval)evalNode);
                block.namedExprsMgr.markAsEvaluated(rawTarget.getAlias(), evalNode);
                rawWindowSpecs.add(((WindowFunctionExpr)rawTarget.getExpr()).getWindowSpec());
            }
            catch (VerifyException ve) {}
        }
        if (windowSpecReferenceses[0].hasPartitionKeys()) {
            Column[] partitionKeyColumns = new Column[windowSpecReferenceses[0].getPartitionKeys().length];
            int i2 = 0;
            for (String partitionKey : windowSpecReferenceses[0].getPartitionKeys()) {
                if (!block.namedExprsMgr.isEvaluated(partitionKey)) {
                    throw new PlanningException("Each grouping column expression must be a scalar expression.");
                }
                partitionKeyColumns[i2++] = block.namedExprsMgr.getTarget(partitionKey).getNamedColumn();
            }
            windowAggNode.setPartitionKeys(partitionKeyColumns);
        }
        SortSpec[][] sortGroups = new SortSpec[rawWindowSpecs.size()][];
        for (int winSpecIdx = 0; winSpecIdx < rawWindowSpecs.size(); ++winSpecIdx) {
            WindowSpec spec = (WindowSpec)rawWindowSpecs.get(winSpecIdx);
            if (spec.hasOrderBy()) {
                Object[] sortSpecs = spec.getSortSpecs();
                int sortNum = sortSpecs.length;
                String[] sortKeyRefNames = windowSpecReferenceses[winSpecIdx].getOrderKeys();
                SortSpec[] annotatedSortSpecs = new SortSpec[sortNum];
                for (int i3 = 0; i3 < sortNum; ++i3) {
                    if (!block.namedExprsMgr.isEvaluated(sortKeyRefNames[i3])) {
                        throw new IllegalStateException("Unexpected State: " + TUtil.arrayToString((Object[])sortSpecs));
                    }
                    Column column = block.namedExprsMgr.getTarget(sortKeyRefNames[i3]).getNamedColumn();
                    annotatedSortSpecs[i3] = new SortSpec(column, sortSpecs[i3].isAscending(), sortSpecs[i3].isNullFirst());
                }
                sortGroups[winSpecIdx] = annotatedSortSpecs;
                continue;
            }
            sortGroups[winSpecIdx] = null;
        }
        for (int i4 = 0; i4 < winFuncRefs.size(); ++i4) {
            WindowFunctionEval winFunc = (WindowFunctionEval)winFuncs.get(i4);
            if (sortGroups[i4] == null) continue;
            winFunc.setSortSpecs(sortGroups[i4]);
        }
        Target[] targets = new Target[referenceNames.length];
        ArrayList windowFuncIndices = Lists.newArrayList();
        Projection projection = (Projection)stack.peek();
        int windowFuncIdx = 0;
        for (NamedExpr expr : projection.getNamedExprs()) {
            if (expr.getExpr().getType() == OpType.WindowFunction) {
                windowFuncIndices.add(windowFuncIdx);
            }
            ++windowFuncIdx;
        }
        windowAggNode.setWindowFunctions(winFuncs.toArray(new WindowFunctionEval[winFuncs.size()]));
        int targetIdx = 0;
        for (i = 0; i < referenceNames.length; ++i) {
            if (windowFuncIndices.contains(i)) continue;
            targets[targetIdx++] = block.isConstReference(referenceNames[i]) ? new Target(block.getConstByReference(referenceNames[i]), referenceNames[i]) : block.namedExprsMgr.getTarget(referenceNames[i]);
        }
        for (i = 0; i < winFuncRefs.size(); ++i) {
            targets[targetIdx++] = block.namedExprsMgr.getTarget((String)winFuncRefs.get(i));
        }
        windowAggNode.setTargets(targets);
        LogicalPlanner.verifyProjectedFields(block, windowAggNode);
        block.registerNode(windowAggNode);
        this.postHook(context, stack, (Expr)null, windowAggNode);
        if (child.getType() == NodeType.LIMIT) {
            LimitNode limitNode = (LimitNode)child;
            limitNode.setInSchema(windowAggNode.getOutSchema());
            limitNode.setOutSchema(windowAggNode.getOutSchema());
            return null;
        }
        if (child.getType() == NodeType.SORT) {
            SortNode sortNode = (SortNode)child;
            sortNode.setInSchema(windowAggNode.getOutSchema());
            sortNode.setOutSchema(windowAggNode.getOutSchema());
            return null;
        }
        return windowAggNode;
    }

    private LogicalNode insertGroupbyNode(PlanContext context, LogicalNode child, Stack<Expr> stack) throws PlanningException {
        LogicalPlan plan = context.plan;
        LogicalPlan.QueryBlock block = context.queryBlock;
        if (child.getType() == NodeType.LIMIT) {
            child = ((LimitNode)child).getChild();
        }
        GroupbyNode groupbyNode = context.plan.createNode(GroupbyNode.class);
        groupbyNode.setChild(child);
        groupbyNode.setInSchema(child.getOutSchema());
        groupbyNode.setGroupingColumns(new Column[0]);
        LinkedHashSet<String> aggEvalNames = new LinkedHashSet<String>();
        LinkedHashSet<AggregationFunctionCallEval> aggEvals = new LinkedHashSet<AggregationFunctionCallEval>();
        boolean includeDistinctFunction = false;
        Iterator<NamedExpr> it = block.namedExprsMgr.getIteratorForUnevaluatedExprs();
        while (it.hasNext()) {
            NamedExpr rawTarget = it.next();
            try {
                includeDistinctFunction |= PlannerUtil.existsDistinctAggregationFunction(rawTarget.getExpr());
                EvalNode evalNode = this.exprAnnotator.createEvalNode(context, rawTarget.getExpr(), NameResolvingMode.SUBEXPRS_AND_RELS);
                if (evalNode.getType() != EvalType.AGG_FUNCTION) continue;
                aggEvalNames.add(rawTarget.getAlias());
                aggEvals.add((AggregationFunctionCallEval)evalNode);
                block.namedExprsMgr.markAsEvaluated(rawTarget.getAlias(), evalNode);
            }
            catch (VerifyException ve) {}
        }
        groupbyNode.setDistinct(includeDistinctFunction);
        groupbyNode.setAggFunctions(aggEvals.toArray(new AggregationFunctionCallEval[aggEvals.size()]));
        Target[] targets = ProjectionPushDownRule.buildGroupByTarget(groupbyNode, null, aggEvalNames.toArray(new String[aggEvalNames.size()]));
        groupbyNode.setTargets(targets);
        block.registerNode(groupbyNode);
        this.postHook(context, stack, (Expr)null, groupbyNode);
        LogicalPlanner.verifyProjectedFields(block, groupbyNode);
        return groupbyNode;
    }

    @Override
    public LimitNode visitLimit(PlanContext context, Stack<Expr> stack, Limit limit) throws PlanningException {
        LogicalNode child;
        EvalNode firstFetNum;
        LogicalPlan.QueryBlock block = context.queryBlock;
        if (limit.getFetchFirstNum().getType() == OpType.Literal) {
            firstFetNum = this.exprAnnotator.createEvalNode(context, limit.getFetchFirstNum(), NameResolvingMode.RELS_ONLY);
            stack.push((Expr)limit);
            child = (LogicalNode)this.visit(context, stack, limit.getChild());
            stack.pop();
        } else {
            ExprNormalizer.ExprNormalizedResult normalizedResult = this.normalizer.normalize(context, limit.getFetchFirstNum());
            String referName = block.namedExprsMgr.addExpr(normalizedResult.baseExpr);
            block.namedExprsMgr.addNamedExprArray(normalizedResult.aggExprs);
            block.namedExprsMgr.addNamedExprArray(normalizedResult.scalarExprs);
            stack.push((Expr)limit);
            child = (LogicalNode)this.visit(context, stack, limit.getChild());
            stack.pop();
            if (block.namedExprsMgr.isEvaluated(referName)) {
                firstFetNum = block.namedExprsMgr.getTarget(referName).getEvalTree();
            } else {
                NamedExpr namedExpr = block.namedExprsMgr.getNamedExpr(referName);
                firstFetNum = this.exprAnnotator.createEvalNode(context, namedExpr.getExpr(), NameResolvingMode.SUBEXPRS_AND_RELS);
                block.namedExprsMgr.markAsEvaluated(referName, firstFetNum);
            }
        }
        LimitNode limitNode = (LimitNode)block.getNodeFromExpr((Expr)limit);
        limitNode.setChild(child);
        limitNode.setInSchema(child.getOutSchema());
        limitNode.setOutSchema(child.getOutSchema());
        limitNode.setFetchFirst(firstFetNum.eval(null, null).asInt8());
        return limitNode;
    }

    @Override
    public LogicalNode visitSort(PlanContext context, Stack<Expr> stack, Sort sort) throws PlanningException {
        int i;
        LogicalPlan.QueryBlock block = context.queryBlock;
        int sortKeyNum = sort.getSortSpecs().length;
        Object[] sortSpecs = sort.getSortSpecs();
        String[] referNames = new String[sortKeyNum];
        ExprNormalizer.ExprNormalizedResult[] normalizedExprList = new ExprNormalizer.ExprNormalizedResult[sortKeyNum];
        for (i = 0; i < sortKeyNum; ++i) {
            normalizedExprList[i] = this.normalizer.normalize(context, sortSpecs[i].getKey());
        }
        for (i = 0; i < sortKeyNum; ++i) {
            referNames[i] = block.namedExprsMgr.addExpr(normalizedExprList[i].baseExpr);
            block.namedExprsMgr.addNamedExprArray(normalizedExprList[i].aggExprs);
            block.namedExprsMgr.addNamedExprArray(normalizedExprList[i].scalarExprs);
        }
        stack.push((Expr)sort);
        LogicalNode child = (LogicalNode)this.visit(context, stack, sort.getChild());
        if (block.isAggregationRequired()) {
            child = this.insertGroupbyNode(context, child, stack);
        }
        stack.pop();
        SortNode sortNode = (SortNode)block.getNodeFromExpr((Expr)sort);
        sortNode.setChild(child);
        sortNode.setInSchema(child.getOutSchema());
        sortNode.setOutSchema(child.getOutSchema());
        ArrayList annotatedSortSpecs = Lists.newArrayList();
        for (int i2 = 0; i2 < sortKeyNum; ++i2) {
            String refName = referNames[i2];
            if (block.isConstReference(refName)) continue;
            if (!block.namedExprsMgr.isEvaluated(refName)) {
                throw new IllegalStateException("Unexpected State: " + TUtil.arrayToString((Object[])sortSpecs));
            }
            Column column = block.namedExprsMgr.getTarget(refName).getNamedColumn();
            annotatedSortSpecs.add(new SortSpec(column, sortSpecs[i2].isAscending(), sortSpecs[i2].isNullFirst()));
        }
        if (annotatedSortSpecs.size() == 0) {
            return child;
        }
        sortNode.setSortSpecs(annotatedSortSpecs.toArray(new SortSpec[annotatedSortSpecs.size()]));
        return sortNode;
    }

    @Override
    public LogicalNode visitHaving(PlanContext context, Stack<Expr> stack, Having expr) throws PlanningException {
        Object havingCondition;
        LogicalPlan.QueryBlock block = context.queryBlock;
        ExprNormalizer.ExprNormalizedResult normalizedResult = this.normalizer.normalize(context, expr.getQual());
        String referName = block.namedExprsMgr.addExpr(normalizedResult.baseExpr);
        block.namedExprsMgr.addNamedExprArray(normalizedResult.aggExprs);
        block.namedExprsMgr.addNamedExprArray(normalizedResult.scalarExprs);
        stack.push((Expr)expr);
        LogicalNode child = (LogicalNode)this.visit(context, stack, expr.getChild());
        stack.pop();
        HavingNode having = (HavingNode)context.queryBlock.getNodeFromExpr((Expr)expr);
        having.setChild(child);
        having.setInSchema(child.getOutSchema());
        having.setOutSchema(child.getOutSchema());
        if (block.namedExprsMgr.isEvaluated(referName)) {
            havingCondition = block.namedExprsMgr.getTarget(referName).getEvalTree();
        } else {
            NamedExpr namedExpr = block.namedExprsMgr.getNamedExpr(referName);
            havingCondition = this.exprAnnotator.createEvalNode(context, namedExpr.getExpr(), NameResolvingMode.SUBEXPRS_AND_RELS);
            block.namedExprsMgr.markAsEvaluated(referName, (EvalNode)havingCondition);
        }
        having.setQual((EvalNode)havingCondition);
        return having;
    }

    @Override
    public LogicalNode visitGroupBy(PlanContext context, Stack<Expr> stack, Aggregation aggregation) throws PlanningException {
        int i;
        LogicalPlan plan = context.plan;
        LogicalPlan.QueryBlock block = context.queryBlock;
        int groupingKeyNum = aggregation.getGroupSet()[0].getGroupingSets().length;
        ExprNormalizer.ExprNormalizedResult[] normalizedResults = new ExprNormalizer.ExprNormalizedResult[groupingKeyNum];
        for (int i2 = 0; i2 < groupingKeyNum; ++i2) {
            Expr groupingKey = aggregation.getGroupSet()[0].getGroupingSets()[i2];
            normalizedResults[i2] = this.normalizer.normalize(context, groupingKey);
        }
        String[] groupingKeyRefNames = new String[groupingKeyNum];
        for (int i3 = 0; i3 < groupingKeyNum; ++i3) {
            groupingKeyRefNames[i3] = block.namedExprsMgr.addExpr(normalizedResults[i3].baseExpr);
            block.namedExprsMgr.addNamedExprArray(normalizedResults[i3].aggExprs);
            block.namedExprsMgr.addNamedExprArray(normalizedResults[i3].scalarExprs);
        }
        stack.push((Expr)aggregation);
        LogicalNode child = (LogicalNode)this.visit(context, stack, aggregation.getChild());
        stack.pop();
        GroupbyNode groupingNode = (GroupbyNode)context.queryBlock.getNodeFromExpr((Expr)aggregation);
        groupingNode.setChild(child);
        groupingNode.setInSchema(child.getOutSchema());
        ArrayList groupingColumns = Lists.newArrayList();
        for (int i4 = 0; i4 < groupingKeyRefNames.length; ++i4) {
            String refName = groupingKeyRefNames[i4];
            if (context.getQueryBlock().isConstReference(refName)) continue;
            if (block.namedExprsMgr.isEvaluated(groupingKeyRefNames[i4])) {
                groupingColumns.add(block.namedExprsMgr.getTarget(groupingKeyRefNames[i4]).getNamedColumn());
                continue;
            }
            throw new PlanningException("Each grouping column expression must be a scalar expression.");
        }
        int effectiveGroupingKeyNum = groupingColumns.size();
        groupingNode.setGroupingColumns(groupingColumns.toArray(new Column[effectiveGroupingKeyNum]));
        List aggEvalNames = TUtil.newList();
        List aggEvalNodes = TUtil.newList();
        boolean includeDistinctFunction = false;
        Iterator<NamedExpr> iterator = block.namedExprsMgr.getIteratorForUnevaluatedExprs();
        while (iterator.hasNext()) {
            NamedExpr namedExpr = iterator.next();
            try {
                includeDistinctFunction |= PlannerUtil.existsDistinctAggregationFunction(namedExpr.getExpr());
                EvalNode evalNode = this.exprAnnotator.createEvalNode(context, namedExpr.getExpr(), NameResolvingMode.SUBEXPRS_AND_RELS);
                if (evalNode.getType() != EvalType.AGG_FUNCTION) continue;
                block.namedExprsMgr.markAsEvaluated(namedExpr.getAlias(), evalNode);
                aggEvalNames.add(namedExpr.getAlias());
                aggEvalNodes.add((AggregationFunctionCallEval)evalNode);
            }
            catch (VerifyException ve) {}
        }
        groupingNode.setDistinct(includeDistinctFunction);
        groupingNode.setAggFunctions(aggEvalNodes.toArray(new AggregationFunctionCallEval[aggEvalNodes.size()]));
        Target[] targets = new Target[effectiveGroupingKeyNum + aggEvalNames.size()];
        for (i = 0; i < effectiveGroupingKeyNum; ++i) {
            Target target;
            targets[i] = target = block.namedExprsMgr.getTarget(groupingNode.getGroupingColumns()[i].getQualifiedName());
        }
        i = 0;
        int targetIdx = effectiveGroupingKeyNum;
        while (i < aggEvalNodes.size()) {
            targets[targetIdx] = block.namedExprsMgr.getTarget((String)aggEvalNames.get(i));
            ++i;
            ++targetIdx;
        }
        groupingNode.setTargets(targets);
        block.unsetAggregationRequire();
        LogicalPlanner.verifyProjectedFields(block, groupingNode);
        return groupingNode;
    }

    public static List<Column[]> generateCuboids(Column[] columns) {
        int numCuboids = (int)Math.pow(2.0, columns.length);
        int maxBits = columns.length;
        ArrayList cube = Lists.newArrayList();
        cube.add(ALL);
        for (int cuboidId = 1; cuboidId < numCuboids; ++cuboidId) {
            ArrayList cuboidCols = Lists.newArrayList();
            for (int j = 0; j < maxBits; ++j) {
                int bit = 1 << j;
                if ((cuboidId & bit) != bit) continue;
                cuboidCols.add(columns[j]);
            }
            cube.add(cuboidCols.toArray(new Column[cuboidCols.size()]));
        }
        return cube;
    }

    @Override
    public SelectionNode visitFilter(PlanContext context, Stack<Expr> stack, Selection selection) throws PlanningException {
        LogicalPlan.QueryBlock block = context.queryBlock;
        ExprNormalizer.ExprNormalizedResult normalizedResult = this.normalizer.normalize(context, selection.getQual());
        block.namedExprsMgr.addExpr(normalizedResult.baseExpr);
        if (normalizedResult.aggExprs.size() > 0 || normalizedResult.scalarExprs.size() > 0) {
            throw new VerifyException("Filter condition cannot include aggregation function");
        }
        stack.push((Expr)selection);
        LogicalNode child = (LogicalNode)this.visit(context, stack, selection.getChild());
        stack.pop();
        SelectionNode selectionNode = (SelectionNode)context.queryBlock.getNodeFromExpr((Expr)selection);
        selectionNode.setChild(child);
        selectionNode.setInSchema(child.getOutSchema());
        selectionNode.setOutSchema(child.getOutSchema());
        EvalNode searchCondition = this.exprAnnotator.createEvalNode(context, selection.getQual(), NameResolvingMode.RELS_AND_SUBEXPRS);
        EvalNode simplified = context.evalOptimizer.optimize(context, searchCondition);
        selectionNode.setQual(simplified);
        return selectionNode;
    }

    @Override
    public LogicalNode visitJoin(PlanContext context, Stack<Expr> stack, Join join) throws PlanningException {
        LogicalPlan plan = context.plan;
        LogicalPlan.QueryBlock block = context.queryBlock;
        if (join.hasQual()) {
            ExprNormalizer.ExprNormalizedResult normalizedResult = this.normalizer.normalize(context, join.getQual(), true);
            block.namedExprsMgr.addExpr(normalizedResult.baseExpr);
            if (normalizedResult.aggExprs.size() > 0 || normalizedResult.scalarExprs.size() > 0) {
                throw new VerifyException("Filter condition cannot include aggregation function");
            }
        }
        stack.push((Expr)join);
        LogicalNode left = (LogicalNode)this.visit(context, stack, join.getLeft());
        LogicalNode right = (LogicalNode)this.visit(context, stack, join.getRight());
        stack.pop();
        JoinNode joinNode = (JoinNode)context.queryBlock.getNodeFromExpr((Expr)join);
        joinNode.setJoinType(join.getJoinType());
        joinNode.setLeftChild(left);
        joinNode.setRightChild(right);
        Schema merged = join.isNatural() ? LogicalPlanner.getNaturalJoinSchema(left, right) : SchemaUtil.merge((Schema)left.getOutSchema(), (Schema)right.getOutSchema());
        joinNode.setInSchema(merged);
        EvalNode joinCondition = null;
        if (join.hasQual()) {
            EvalNode evalNode = this.exprAnnotator.createEvalNode(context, join.getQual(), NameResolvingMode.LEGACY);
            joinCondition = context.evalOptimizer.optimize(context, evalNode);
        }
        List<String> newlyEvaluatedExprs = this.getNewlyEvaluatedExprsForJoin(context, joinNode, stack);
        List targets = TUtil.newList((Object[])PlannerUtil.schemaToTargets(merged));
        for (String newAddedExpr : newlyEvaluatedExprs) {
            targets.add(block.namedExprsMgr.getTarget(newAddedExpr, true));
        }
        joinNode.setTargets(targets.toArray(new Target[targets.size()]));
        if (join.isNatural()) {
            EvalNode njCond = LogicalPlanner.getNaturalJoinCondition(joinNode);
            joinNode.setJoinQual(njCond);
        } else if (join.hasQual()) {
            joinNode.setJoinQual(joinCondition);
        }
        return joinNode;
    }

    private List<String> getNewlyEvaluatedExprsForJoin(PlanContext context, JoinNode joinNode, Stack<Expr> stack) {
        LogicalPlan.QueryBlock block = context.queryBlock;
        List newlyEvaluatedExprs = TUtil.newList();
        Iterator<NamedExpr> it = block.namedExprsMgr.getIteratorForUnevaluatedExprs();
        while (it.hasNext()) {
            NamedExpr namedExpr = it.next();
            try {
                EvalNode evalNode = this.exprAnnotator.createEvalNode(context, namedExpr.getExpr(), NameResolvingMode.LEGACY);
                if (!LogicalPlanner.checkIfBeEvaluatedAtJoin(block, evalNode, joinNode, stack.peek().getType() != OpType.Join)) continue;
                block.namedExprsMgr.markAsEvaluated(namedExpr.getAlias(), evalNode);
                newlyEvaluatedExprs.add(namedExpr.getAlias());
            }
            catch (VerifyException ve) {
            }
            catch (PlanningException e) {}
        }
        return newlyEvaluatedExprs;
    }

    private static Schema getNaturalJoinSchema(LogicalNode left, LogicalNode right) {
        Schema joinSchema = new Schema();
        Schema commons = SchemaUtil.getNaturalJoinColumns((Schema)left.getOutSchema(), (Schema)right.getOutSchema());
        joinSchema.addColumns(commons);
        for (Column c : left.getOutSchema().getColumns()) {
            if (joinSchema.contains(c.getQualifiedName())) continue;
            joinSchema.addColumn(c);
        }
        for (Column c : right.getOutSchema().getColumns()) {
            if (joinSchema.contains(c.getQualifiedName())) continue;
            joinSchema.addColumn(c);
        }
        return joinSchema;
    }

    private static EvalNode getNaturalJoinCondition(JoinNode joinNode) {
        Schema leftSchema = ((LogicalNode)joinNode.getLeftChild()).getInSchema();
        Schema rightSchema = ((LogicalNode)joinNode.getRightChild()).getInSchema();
        Schema commons = SchemaUtil.getNaturalJoinColumns((Schema)leftSchema, (Schema)rightSchema);
        BinaryEval njQual = null;
        for (Column common : commons.getColumns()) {
            Column leftJoinKey = leftSchema.getColumn(common.getQualifiedName());
            Column rightJoinKey = rightSchema.getColumn(common.getQualifiedName());
            BinaryEval equiQual = new BinaryEval(EvalType.EQUAL, new FieldEval(leftJoinKey), new FieldEval(rightJoinKey));
            if (njQual == null) {
                njQual = equiQual;
                continue;
            }
            njQual = new BinaryEval(EvalType.AND, njQual, equiQual);
        }
        return njQual;
    }

    private LogicalNode createCartesianProduct(PlanContext context, LogicalNode left, LogicalNode right) throws PlanningException {
        LogicalPlan plan = context.plan;
        LogicalPlan.QueryBlock block = context.queryBlock;
        Schema merged = SchemaUtil.merge((Schema)left.getOutSchema(), (Schema)right.getOutSchema());
        JoinNode join = plan.createNode(JoinNode.class);
        join.init(JoinType.CROSS, left, right);
        join.setInSchema(merged);
        List newlyEvaluatedExprs = TUtil.newList();
        Iterator<NamedExpr> it = block.namedExprsMgr.getIteratorForUnevaluatedExprs();
        while (it.hasNext()) {
            NamedExpr namedExpr = it.next();
            try {
                EvalNode evalNode = this.exprAnnotator.createEvalNode(context, namedExpr.getExpr(), NameResolvingMode.LEGACY);
                if (EvalTreeUtil.findDistinctAggFunction(evalNode).size() != 0 || EvalTreeUtil.findWindowFunction(evalNode).size() != 0) continue;
                block.namedExprsMgr.markAsEvaluated(namedExpr.getAlias(), evalNode);
                newlyEvaluatedExprs.add(namedExpr.getAlias());
            }
            catch (VerifyException ve) {}
        }
        List targets = TUtil.newList((Object[])PlannerUtil.schemaToTargets(merged));
        for (String newAddedExpr : newlyEvaluatedExprs) {
            targets.add(block.namedExprsMgr.getTarget(newAddedExpr, true));
        }
        join.setTargets(targets.toArray(new Target[targets.size()]));
        return join;
    }

    @Override
    public LogicalNode visitRelationList(PlanContext context, Stack<Expr> stack, RelationList relations) throws PlanningException {
        LogicalNode current = (LogicalNode)this.visit(context, stack, relations.getRelations()[0]);
        if (relations.size() > 1) {
            for (int i = 1; i < relations.size(); ++i) {
                LogicalNode left = current;
                LogicalNode right = (LogicalNode)this.visit(context, stack, relations.getRelations()[i]);
                current = this.createCartesianProduct(context, left, right);
            }
        }
        context.queryBlock.registerNode(current);
        return current;
    }

    @Override
    public ScanNode visitRelation(PlanContext context, Stack<Expr> stack, Relation expr) throws PlanningException {
        LogicalPlan.QueryBlock block = context.queryBlock;
        ScanNode scanNode = (ScanNode)block.getNodeFromExpr((Expr)expr);
        this.updatePhysicalInfo(scanNode.getTableDesc());
        LinkedHashSet<String> newlyEvaluatedExprsReferences = new LinkedHashSet<String>();
        Iterator<NamedExpr> iterator = block.namedExprsMgr.getIteratorForUnevaluatedExprs();
        while (iterator.hasNext()) {
            NamedExpr rawTarget = iterator.next();
            try {
                EvalNode evalNode = this.exprAnnotator.createEvalNode(context, rawTarget.getExpr(), NameResolvingMode.RELS_ONLY);
                if (!LogicalPlanner.checkIfBeEvaluatedAtRelation(block, evalNode, scanNode)) continue;
                block.namedExprsMgr.markAsEvaluated(rawTarget.getAlias(), evalNode);
                newlyEvaluatedExprsReferences.add(rawTarget.getAlias());
            }
            catch (VerifyException ve) {}
        }
        LinkedHashSet<Target> targets = LogicalPlanner.createFieldTargetsFromRelation(block, scanNode, newlyEvaluatedExprsReferences);
        for (String reference : newlyEvaluatedExprsReferences) {
            NamedExpr refrer = block.namedExprsMgr.getNamedExpr(reference);
            EvalNode evalNode = this.exprAnnotator.createEvalNode(context, refrer.getExpr(), NameResolvingMode.RELS_ONLY);
            targets.add(new Target(evalNode, reference));
        }
        scanNode.setTargets(targets.toArray(new Target[targets.size()]));
        LogicalPlanner.verifyProjectedFields(block, scanNode);
        return scanNode;
    }

    private static LinkedHashSet<Target> createFieldTargetsFromRelation(LogicalPlan.QueryBlock block, RelationNode relationNode, Set<String> newlyEvaluatedRefNames) {
        LinkedHashSet targets = Sets.newLinkedHashSet();
        for (Column column : relationNode.getLogicalSchema().getColumns()) {
            String aliasName = block.namedExprsMgr.checkAndGetIfAliasedColumn(column.getQualifiedName());
            if (aliasName != null) {
                targets.add(new Target(new FieldEval(column), aliasName));
                newlyEvaluatedRefNames.remove(aliasName);
                continue;
            }
            targets.add(new Target(new FieldEval(column)));
        }
        return targets;
    }

    private void updatePhysicalInfo(TableDesc desc) {
        if (desc.getPath() != null && desc.getMeta().getStoreType() != CatalogProtos.StoreType.SYSTEM) {
            try {
                ContentSummary summary;
                Path path = new Path(desc.getPath());
                FileSystem fs = path.getFileSystem(new Configuration());
                FileStatus status = fs.getFileStatus(path);
                if (desc.getStats() != null && (status.isDirectory() || status.isFile()) && (summary = fs.getContentSummary(path)) != null) {
                    long volume = summary.getLength();
                    desc.getStats().setNumBytes(volume);
                }
            }
            catch (Throwable t) {
                LOG.warn((Object)t);
            }
        }
    }

    @Override
    public TableSubQueryNode visitTableSubQuery(PlanContext context, Stack<Expr> stack, TablePrimarySubQuery expr) throws PlanningException {
        LogicalPlan.QueryBlock block = context.queryBlock;
        LogicalPlan.QueryBlock childBlock = context.plan.getBlock(context.plan.getBlockNameByExpr(expr.getSubQuery()));
        PlanContext newContext = new PlanContext(context, childBlock);
        LogicalNode child = (LogicalNode)this.visit(newContext, new Stack<Expr>(), expr.getSubQuery());
        TableSubQueryNode subQueryNode = (TableSubQueryNode)context.queryBlock.getNodeFromExpr((Expr)expr);
        context.plan.connectBlocks(childBlock, context.queryBlock, LogicalPlan.BlockType.TableSubQuery);
        subQueryNode.setSubQuery(child);
        Set newlyEvaluatedExprs = TUtil.newHashSet();
        for (NamedExpr rawTarget : block.namedExprsMgr.getAllNamedExprs()) {
            try {
                EvalNode evalNode = this.exprAnnotator.createEvalNode(context, rawTarget.getExpr(), NameResolvingMode.RELS_ONLY);
                if (!LogicalPlanner.checkIfBeEvaluatedAtRelation(block, evalNode, subQueryNode)) continue;
                block.namedExprsMgr.markAsEvaluated(rawTarget.getAlias(), evalNode);
                newlyEvaluatedExprs.add(rawTarget.getAlias());
            }
            catch (VerifyException ve) {}
        }
        LinkedHashSet<Target> targets = LogicalPlanner.createFieldTargetsFromRelation(block, subQueryNode, newlyEvaluatedExprs);
        for (String newAddedExpr : newlyEvaluatedExprs) {
            targets.add(block.namedExprsMgr.getTarget(newAddedExpr, true));
        }
        subQueryNode.setTargets(targets.toArray(new Target[targets.size()]));
        return subQueryNode;
    }

    @Override
    public LogicalNode visitUnion(PlanContext context, Stack<Expr> stack, SetOperation setOperation) throws PlanningException {
        return this.buildSetPlan(context, stack, setOperation);
    }

    @Override
    public LogicalNode visitExcept(PlanContext context, Stack<Expr> stack, SetOperation setOperation) throws PlanningException {
        return this.buildSetPlan(context, stack, setOperation);
    }

    @Override
    public LogicalNode visitIntersect(PlanContext context, Stack<Expr> stack, SetOperation setOperation) throws PlanningException {
        return this.buildSetPlan(context, stack, setOperation);
    }

    private LogicalNode buildSetPlan(PlanContext context, Stack<Expr> stack, SetOperation setOperation) throws PlanningException {
        BinaryNode setOp;
        LogicalPlan plan = context.plan;
        LogicalPlan.QueryBlock block = context.queryBlock;
        LogicalPlan.QueryBlock leftBlock = context.plan.getBlockByExpr(setOperation.getLeft());
        PlanContext leftContext = new PlanContext(context, leftBlock);
        stack.push((Expr)setOperation);
        LogicalNode leftChild = (LogicalNode)this.visit(leftContext, new Stack<Expr>(), setOperation.getLeft());
        stack.pop();
        context.plan.connectBlocks(leftContext.queryBlock, context.queryBlock, LogicalPlan.BlockType.TableSubQuery);
        LogicalPlan.QueryBlock rightBlock = context.plan.getBlockByExpr(setOperation.getRight());
        PlanContext rightContext = new PlanContext(context, rightBlock);
        stack.push((Expr)setOperation);
        LogicalNode rightChild = (LogicalNode)this.visit(rightContext, new Stack<Expr>(), setOperation.getRight());
        stack.pop();
        context.plan.connectBlocks(rightContext.queryBlock, context.queryBlock, LogicalPlan.BlockType.TableSubQuery);
        if (setOperation.getType() == OpType.Union) {
            setOp = (BinaryNode)block.getNodeFromExpr((Expr)setOperation);
        } else if (setOperation.getType() == OpType.Except) {
            setOp = (BinaryNode)block.getNodeFromExpr((Expr)setOperation);
        } else if (setOperation.getType() == OpType.Intersect) {
            setOp = (BinaryNode)block.getNodeFromExpr((Expr)setOperation);
        } else {
            throw new VerifyException("Invalid Type: " + setOperation.getType());
        }
        setOp.setLeftChild(leftChild);
        setOp.setRightChild(rightChild);
        Target[] leftStrippedTargets = PlannerUtil.stripTarget(PlannerUtil.schemaToTargets(((LogicalNode)leftBlock.getRoot()).getOutSchema()));
        setOp.setInSchema(leftChild.getOutSchema());
        Schema outSchema = PlannerUtil.targetToSchema(leftStrippedTargets);
        setOp.setOutSchema(outSchema);
        return setOp;
    }

    @Override
    public LogicalNode visitInsert(PlanContext context, Stack<Expr> stack, Insert expr) throws PlanningException {
        stack.push((Expr)expr);
        LogicalNode subQuery = (LogicalNode)super.visitInsert(context, stack, expr);
        stack.pop();
        InsertNode insertNode = (InsertNode)context.queryBlock.getNodeFromExpr((Expr)expr);
        insertNode.setOverwrite(expr.isOverwrite());
        insertNode.setSubQuery(subQuery);
        if (expr.hasTableName()) {
            return this.buildInsertIntoTablePlan(context, insertNode, expr);
        }
        if (expr.hasLocation()) {
            return this.buildInsertIntoLocationPlan(context, insertNode, expr);
        }
        throw new IllegalStateException("Invalid Query");
    }

    private InsertNode buildInsertIntoTablePlan(PlanContext context, InsertNode insertNode, Insert expr) throws PlanningException {
        String tableName;
        String databaseName;
        if (CatalogUtil.isFQTableName((String)expr.getTableName())) {
            databaseName = CatalogUtil.extractQualifier((String)expr.getTableName());
            tableName = CatalogUtil.extractSimpleName((String)expr.getTableName());
        } else {
            databaseName = context.queryContext.get((ConfigKey)SessionVars.CURRENT_DATABASE);
            tableName = expr.getTableName();
        }
        TableDesc desc = this.catalog.getTableDesc(databaseName, tableName);
        insertNode.setTargetTable(desc);
        if (expr.hasTargetColumns()) {
            if (expr.getTargetColumns().length > ((LogicalNode)insertNode.getChild()).getOutSchema().size()) {
                throw new PlanningException("Target columns and projected columns are mismatched to each other");
            }
            String[] targets = expr.getTargetColumns();
            Schema targetColumns = new Schema();
            for (int i = 0; i < targets.length; ++i) {
                Column targetColumn = desc.getLogicalSchema().getColumn(targets[i]);
                targetColumns.addColumn(targetColumn);
            }
            insertNode.setTargetSchema(targetColumns);
            insertNode.setOutSchema(targetColumns);
            this.buildProjectedInsert(context, insertNode);
        } else {
            Schema tableSchema = desc.getLogicalSchema();
            Schema projectedSchema = ((LogicalNode)insertNode.getChild()).getOutSchema();
            Schema targetColumns = new Schema();
            for (int i = 0; i < projectedSchema.size(); ++i) {
                targetColumns.addColumn(tableSchema.getColumn(i));
            }
            insertNode.setTargetSchema(targetColumns);
            this.buildProjectedInsert(context, insertNode);
        }
        if (desc.hasPartition()) {
            insertNode.setPartitionMethod(desc.getPartitionMethod());
        }
        return insertNode;
    }

    private void buildProjectedInsert(PlanContext context, InsertNode insertNode) {
        List targets;
        Projectable projectionNode;
        Schema tableSchema = insertNode.getTableSchema();
        Schema targetColumns = insertNode.getTargetSchema();
        Object child = insertNode.getChild();
        if (((LogicalNode)child).getType() == NodeType.UNION) {
            child = this.makeProjectionForInsertUnion(context, insertNode);
        }
        if (child instanceof Projectable) {
            projectionNode = (Projectable)insertNode.getChild();
            targets = TUtil.newList();
            int j = 0;
            for (int i = 0; i < tableSchema.size(); ++i) {
                Column column = tableSchema.getColumn(i);
                if (targetColumns.contains(column) && j < projectionNode.getTargets().length) {
                    targets.add(projectionNode.getTargets()[j++]);
                    continue;
                }
                targets.add(new Target(new ConstEval((Datum)NullDatum.get()), column.getSimpleName()));
            }
        } else {
            throw new RuntimeException("Wrong child node type: " + (Object)((Object)((LogicalNode)child).getType()) + " for insert");
        }
        projectionNode.setTargets(targets.toArray(new Target[targets.size()]));
        insertNode.setInSchema(projectionNode.getOutSchema());
        insertNode.setOutSchema(projectionNode.getOutSchema());
        insertNode.setProjectedSchema(PlannerUtil.targetToSchema(targets));
    }

    private ProjectionNode makeProjectionForInsertUnion(PlanContext context, InsertNode insertNode) {
        Object child = insertNode.getChild();
        TableSubQueryNode subQueryNode = context.plan.createNode(TableSubQueryNode.class);
        subQueryNode.init(context.queryBlock.getName(), (LogicalNode)child);
        subQueryNode.setTargets(PlannerUtil.schemaToTargets(subQueryNode.getOutSchema()));
        ProjectionNode projectionNode = context.plan.createNode(ProjectionNode.class);
        projectionNode.setChild(subQueryNode);
        projectionNode.setInSchema(subQueryNode.getInSchema());
        projectionNode.setTargets(subQueryNode.getTargets());
        context.queryBlock.registerNode(projectionNode);
        context.queryBlock.registerNode(subQueryNode);
        UnionNode unionNode = (UnionNode)child;
        context.queryBlock.unregisterNode(unionNode);
        LogicalPlan.QueryBlock unionBlock = context.plan.newQueryBlock();
        unionBlock.registerNode(unionNode);
        unionBlock.setRoot(unionNode);
        LogicalPlan.QueryBlock leftBlock = context.plan.getBlock((LogicalNode)unionNode.getLeftChild());
        LogicalPlan.QueryBlock rightBlock = context.plan.getBlock((LogicalNode)unionNode.getRightChild());
        context.plan.disconnectBlocks(leftBlock, context.queryBlock);
        context.plan.disconnectBlocks(rightBlock, context.queryBlock);
        context.plan.connectBlocks(unionBlock, context.queryBlock, LogicalPlan.BlockType.TableSubQuery);
        context.plan.connectBlocks(leftBlock, unionBlock, LogicalPlan.BlockType.TableSubQuery);
        context.plan.connectBlocks(rightBlock, unionBlock, LogicalPlan.BlockType.TableSubQuery);
        insertNode.setChild(projectionNode);
        return projectionNode;
    }

    private InsertNode buildInsertIntoLocationPlan(PlanContext context, InsertNode insertNode, Insert expr) {
        Object child = insertNode.getChild();
        if (((LogicalNode)child).getType() == NodeType.UNION) {
            child = this.makeProjectionForInsertUnion(context, insertNode);
        }
        Schema childSchema = ((LogicalNode)child).getOutSchema();
        insertNode.setInSchema(childSchema);
        insertNode.setOutSchema(childSchema);
        insertNode.setTableSchema(childSchema);
        insertNode.setTargetLocation(new Path(expr.getLocation()));
        if (expr.hasStorageType()) {
            insertNode.setStorageType(CatalogUtil.getStoreType((String)expr.getStorageType()));
        }
        if (expr.hasParams()) {
            KeyValueSet options = new KeyValueSet();
            options.putAll(expr.getParams());
            insertNode.setOptions(options);
        }
        return insertNode;
    }

    @Override
    public LogicalNode visitCreateDatabase(PlanContext context, Stack<Expr> stack, CreateDatabase expr) throws PlanningException {
        CreateDatabaseNode createDatabaseNode = (CreateDatabaseNode)context.queryBlock.getNodeFromExpr((Expr)expr);
        createDatabaseNode.init(expr.getDatabaseName(), expr.isIfNotExists());
        return createDatabaseNode;
    }

    @Override
    public LogicalNode visitDropDatabase(PlanContext context, Stack<Expr> stack, DropDatabase expr) throws PlanningException {
        DropDatabaseNode dropDatabaseNode = (DropDatabaseNode)context.queryBlock.getNodeFromExpr((Expr)expr);
        dropDatabaseNode.init(expr.getDatabaseName(), expr.isIfExists());
        return dropDatabaseNode;
    }

    public LogicalNode handleCreateTableLike(PlanContext context, CreateTable expr, CreateTableNode createTableNode) throws PlanningException {
        TableDesc parentTableDesc;
        String parentTableName = expr.getLikeParentTableName();
        if (!CatalogUtil.isFQTableName((String)parentTableName)) {
            parentTableName = CatalogUtil.buildFQName((String[])new String[]{context.queryContext.get((ConfigKey)SessionVars.CURRENT_DATABASE), parentTableName});
        }
        if ((parentTableDesc = this.catalog.getTableDesc(parentTableName)) == null) {
            throw new PlanningException("Table '" + parentTableName + "' does not exist");
        }
        PartitionMethodDesc partitionDesc = parentTableDesc.getPartitionMethod();
        createTableNode.setTableSchema(parentTableDesc.getSchema());
        createTableNode.setPartitionMethod(partitionDesc);
        createTableNode.setStorageType(parentTableDesc.getMeta().getStoreType());
        createTableNode.setOptions(parentTableDesc.getMeta().getOptions());
        createTableNode.setExternal(parentTableDesc.isExternal());
        if (parentTableDesc.isExternal()) {
            createTableNode.setPath(new Path(parentTableDesc.getPath()));
        }
        return createTableNode;
    }

    @Override
    public LogicalNode visitCreateTable(PlanContext context, Stack<Expr> stack, CreateTable expr) throws PlanningException {
        CreateTableNode createTableNode = (CreateTableNode)context.queryBlock.getNodeFromExpr((Expr)expr);
        createTableNode.setIfNotExists(expr.isIfNotExists());
        if (CatalogUtil.isFQTableName((String)expr.getTableName())) {
            createTableNode.setTableName(expr.getTableName());
        } else {
            createTableNode.setTableName(CatalogUtil.buildFQName((String[])new String[]{context.queryContext.get((ConfigKey)SessionVars.CURRENT_DATABASE), expr.getTableName()}));
        }
        if (expr.getLikeParentTableName() != null) {
            return this.handleCreateTableLike(context, expr, createTableNode);
        }
        if (expr.hasStorageType()) {
            createTableNode.setStorageType(CatalogUtil.getStoreType((String)expr.getStorageType()));
        } else {
            createTableNode.setStorageType(CatalogProtos.StoreType.CSV);
        }
        KeyValueSet properties = CatalogUtil.newPhysicalProperties((CatalogProtos.StoreType)createTableNode.getStorageType());
        PlannerUtil.applySessionToTableProperties(context.queryContext, createTableNode.getStorageType(), properties);
        if (expr.hasParams()) {
            properties.putAll(expr.getParams());
        }
        createTableNode.setOptions(properties);
        if (expr.hasPartition()) {
            if (expr.getPartitionMethod().getPartitionType().equals((Object)CreateTable.PartitionType.COLUMN)) {
                createTableNode.setPartitionMethod(this.getPartitionMethod(context, expr.getTableName(), expr.getPartitionMethod()));
            } else {
                throw new PlanningException(String.format("Not supported PartitonType: %s", expr.getPartitionMethod().getPartitionType()));
            }
        }
        if (expr.hasSubQuery()) {
            stack.add((Expr)expr);
            LogicalNode subQuery = (LogicalNode)this.visit(context, stack, expr.getSubQuery());
            stack.pop();
            createTableNode.setChild(subQuery);
            createTableNode.setInSchema(subQuery.getOutSchema());
            if (expr.hasTableElements()) {
                createTableNode.setOutSchema(this.convertTableElementsSchema(expr.getTableElements()));
                createTableNode.setTableSchema(this.convertTableElementsSchema(expr.getTableElements()));
            } else if (expr.hasPartition()) {
                PartitionMethodDesc partitionMethod = createTableNode.getPartitionMethod();
                Schema queryOutputSchema = subQuery.getOutSchema();
                Schema partitionExpressionSchema = partitionMethod.getExpressionSchema();
                if (partitionMethod.getPartitionType() == CatalogProtos.PartitionType.COLUMN && queryOutputSchema.size() < partitionExpressionSchema.size()) {
                    throw new VerifyException("Partition columns cannot be more than table columns.");
                }
                Schema tableSchema = new Schema();
                for (int i = 0; i < queryOutputSchema.size() - partitionExpressionSchema.size(); ++i) {
                    tableSchema.addColumn(queryOutputSchema.getColumn(i));
                }
                createTableNode.setOutSchema(tableSchema);
                createTableNode.setTableSchema(tableSchema);
            } else {
                Schema schema = new Schema(subQuery.getOutSchema());
                schema.setQualifier(createTableNode.getTableName());
                createTableNode.setOutSchema(schema);
                createTableNode.setTableSchema(schema);
            }
            return createTableNode;
        }
        Schema tableSchema = this.convertColumnsToSchema(expr.getTableElements());
        createTableNode.setTableSchema(tableSchema);
        if (expr.isExternal()) {
            createTableNode.setExternal(true);
        }
        if (expr.hasLocation()) {
            createTableNode.setPath(new Path(expr.getLocation()));
        }
        return createTableNode;
    }

    private PartitionMethodDesc getPartitionMethod(PlanContext context, String tableName, CreateTable.PartitionMethodDescExpr expr) throws PlanningException {
        if (expr.getPartitionType() != CreateTable.PartitionType.COLUMN) {
            throw new PlanningException(String.format("Not supported PartitonType: %s", expr.getPartitionType()));
        }
        CreateTable.ColumnPartition partition = (CreateTable.ColumnPartition)expr;
        String partitionExpression = Joiner.on((char)',').join((Object[])partition.getColumns());
        PartitionMethodDesc partitionMethodDesc = new PartitionMethodDesc(context.queryContext.get((ConfigKey)SessionVars.CURRENT_DATABASE), tableName, CatalogProtos.PartitionType.COLUMN, partitionExpression, this.convertColumnsToSchema(partition.getColumns()));
        return partitionMethodDesc;
    }

    private Schema convertColumnsToSchema(ColumnDefinition[] elements) {
        Schema schema = new Schema();
        for (ColumnDefinition columnDefinition : elements) {
            schema.addColumn(this.convertColumn(columnDefinition));
        }
        return schema;
    }

    private Schema convertTableElementsSchema(ColumnDefinition[] elements) {
        Schema schema = new Schema();
        for (ColumnDefinition columnDefinition : elements) {
            schema.addColumn(this.convertColumn(columnDefinition));
        }
        return schema;
    }

    private Column convertColumn(ColumnDefinition columnDefinition) {
        return new Column(columnDefinition.getColumnName(), LogicalPlanner.convertDataType((DataTypeExpr)columnDefinition));
    }

    public static TajoDataTypes.DataType convertDataType(DataTypeExpr dataType) {
        TajoDataTypes.Type type = TajoDataTypes.Type.valueOf((String)dataType.getTypeName());
        TajoDataTypes.DataType.Builder builder = TajoDataTypes.DataType.newBuilder();
        builder.setType(type);
        if (dataType.hasLengthOrPrecision()) {
            builder.setLength(dataType.getLengthOrPrecision().intValue());
        }
        return builder.build();
    }

    @Override
    public LogicalNode visitDropTable(PlanContext context, Stack<Expr> stack, DropTable dropTable) {
        DropTableNode dropTableNode = (DropTableNode)context.queryBlock.getNodeFromExpr((Expr)dropTable);
        String qualified = CatalogUtil.isFQTableName((String)dropTable.getTableName()) ? dropTable.getTableName() : CatalogUtil.buildFQName((String[])new String[]{context.queryContext.get((ConfigKey)SessionVars.CURRENT_DATABASE), dropTable.getTableName()});
        dropTableNode.init(qualified, dropTable.isIfExists(), dropTable.isPurge());
        return dropTableNode;
    }

    @Override
    public LogicalNode visitAlterTablespace(PlanContext context, Stack<Expr> stack, AlterTablespace alterTablespace) {
        AlterTablespaceNode alter = (AlterTablespaceNode)context.queryBlock.getNodeFromExpr((Expr)alterTablespace);
        alter.setTablespaceName(alterTablespace.getTablespaceName());
        alter.setLocation(alterTablespace.getLocation());
        return alter;
    }

    @Override
    public LogicalNode visitAlterTable(PlanContext context, Stack<Expr> stack, AlterTable alterTable) {
        AlterTableNode alterTableNode = (AlterTableNode)context.queryBlock.getNodeFromExpr((Expr)alterTable);
        alterTableNode.setTableName(alterTable.getTableName());
        alterTableNode.setNewTableName(alterTable.getNewTableName());
        alterTableNode.setColumnName(alterTable.getColumnName());
        alterTableNode.setNewColumnName(alterTable.getNewColumnName());
        if (null != alterTable.getAddNewColumn()) {
            alterTableNode.setAddNewColumn(this.convertColumn(alterTable.getAddNewColumn()));
        }
        alterTableNode.setAlterTableOpType(alterTable.getAlterTableOpType());
        return alterTableNode;
    }

    @Override
    public LogicalNode visitTruncateTable(PlanContext context, Stack<Expr> stack, TruncateTable truncateTable) throws PlanningException {
        TruncateTableNode truncateTableNode = (TruncateTableNode)context.queryBlock.getNodeFromExpr((Expr)truncateTable);
        truncateTableNode.setTableNames(truncateTable.getTableNames());
        return truncateTableNode;
    }

    public static boolean checkIfBeEvaluatedAtWindowAgg(EvalNode evalNode, WindowAggNode node) {
        LinkedHashSet<Column> columnRefs = EvalTreeUtil.findUniqueColumns(evalNode);
        if (columnRefs.size() > 0 && !node.getInSchema().containsAll(columnRefs)) {
            return false;
        }
        return EvalTreeUtil.findDistinctAggFunction(evalNode).size() <= 0;
    }

    public static boolean checkIfBeEvaluatedAtGroupBy(EvalNode evalNode, GroupbyNode node) {
        LinkedHashSet<Column> columnRefs = EvalTreeUtil.findUniqueColumns(evalNode);
        if (columnRefs.size() > 0 && !node.getInSchema().containsAll(columnRefs)) {
            return false;
        }
        return EvalTreeUtil.findEvalsByType(evalNode, EvalType.WINDOW_FUNCTION).size() <= 0;
    }

    public static boolean checkIfBeEvaluatedAtJoin(LogicalPlan.QueryBlock block, EvalNode evalNode, JoinNode node, boolean isTopMostJoin) {
        Collection found;
        LinkedHashSet<Column> columnRefs = EvalTreeUtil.findUniqueColumns(evalNode);
        if (EvalTreeUtil.findDistinctAggFunction(evalNode).size() > 0) {
            return false;
        }
        if (EvalTreeUtil.findEvalsByType(evalNode, EvalType.WINDOW_FUNCTION).size() > 0) {
            return false;
        }
        if (columnRefs.size() > 0 && !node.getInSchema().containsAll(columnRefs)) {
            return false;
        }
        return !LogicalPlanner.containsOuterJoin(block) || isTopMostJoin || (found = EvalTreeUtil.findOuterJoinSensitiveEvals(evalNode)).size() <= 0;
    }

    public static boolean isOuterJoin(JoinType joinType) {
        return joinType == JoinType.LEFT_OUTER || joinType == JoinType.RIGHT_OUTER || joinType == JoinType.FULL_OUTER;
    }

    public static boolean containsOuterJoin(LogicalPlan.QueryBlock block) {
        return block.containsJoinType(JoinType.LEFT_OUTER) || block.containsJoinType(JoinType.RIGHT_OUTER) || block.containsJoinType(JoinType.FULL_OUTER);
    }

    public static boolean checkIfBeEvaluatedAtRelation(LogicalPlan.QueryBlock block, EvalNode evalNode, RelationNode node) {
        Collection found;
        LinkedHashSet<Column> columnRefs = EvalTreeUtil.findUniqueColumns(evalNode);
        if (EvalTreeUtil.findDistinctAggFunction(evalNode).size() > 0) {
            return false;
        }
        if (EvalTreeUtil.findEvalsByType(evalNode, EvalType.WINDOW_FUNCTION).size() > 0) {
            return false;
        }
        if (columnRefs.size() > 0 && !node.getLogicalSchema().containsAll(columnRefs)) {
            return false;
        }
        return !LogicalPlanner.containsOuterJoin(block) || (found = EvalTreeUtil.findOuterJoinSensitiveEvals(evalNode)).size() <= 0;
    }

    public static boolean checkIfBeEvaluatedAtThis(EvalNode evalNode, LogicalNode node) {
        LinkedHashSet<Column> columnRefs = EvalTreeUtil.findUniqueColumns(evalNode);
        return columnRefs.size() <= 0 || node.getInSchema().containsAll(columnRefs);
    }

    private static interface Matcher {
        public boolean isMatch(Expr var1);
    }

    public static class PlanContext {
        OverridableConf queryContext;
        LogicalPlan plan;
        LogicalPlan.QueryBlock queryBlock;
        EvalTreeOptimizer evalOptimizer;
        TimeZone timeZone;
        boolean debugOrUnitTests;

        public PlanContext(OverridableConf context, LogicalPlan plan, LogicalPlan.QueryBlock block, EvalTreeOptimizer evalOptimizer, boolean debugOrUnitTests) {
            this.queryContext = context;
            this.plan = plan;
            this.queryBlock = block;
            this.evalOptimizer = evalOptimizer;
            if (context.containsKey((ConfigKey)SessionVars.TIMEZONE)) {
                String timezoneId = context.get((ConfigKey)SessionVars.TIMEZONE);
                this.timeZone = TimeZone.getTimeZone(timezoneId);
            }
            this.debugOrUnitTests = debugOrUnitTests;
        }

        public PlanContext(PlanContext context, LogicalPlan.QueryBlock block) {
            this.queryContext = context.queryContext;
            this.plan = context.plan;
            this.queryBlock = block;
            this.evalOptimizer = context.evalOptimizer;
            this.debugOrUnitTests = context.debugOrUnitTests;
        }

        public LogicalPlan.QueryBlock getQueryBlock() {
            return this.queryBlock;
        }

        public String toString() {
            return "block=" + this.queryBlock.getName() + ", relNum=" + this.queryBlock.getRelations().size() + ", " + this.queryBlock.namedExprsMgr.toString();
        }
    }
}

