/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tajo.algebra.ColumnReferenceExpr;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.NamedExpr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.annotation.Nullable;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.FieldEval;
import org.apache.tajo.util.TUtil;

public class NamedExprsManager {
    private int sequenceId = 0;
    private LinkedHashMap<String, Integer> nameToIdMap = Maps.newLinkedHashMap();
    private BiMap<Integer, EvalNode> idToEvalMap = HashBiMap.create();
    private LinkedHashMap<Integer, List<String>> idToNamesMap = Maps.newLinkedHashMap();
    private BiMap<Integer, Expr> idToExprBiMap = HashBiMap.create();
    private LinkedHashMap<Integer, Boolean> evaluationStateMap = Maps.newLinkedHashMap();
    private BiMap<String, String> aliasedColumnMap = HashBiMap.create();
    private final LogicalPlan plan;
    private final LogicalPlan.QueryBlock block;

    public NamedExprsManager(LogicalPlan plan, LogicalPlan.QueryBlock block) {
        this.plan = plan;
        this.block = block;
    }

    private int getNextId() {
        return this.sequenceId++;
    }

    public boolean isEvaluated(String name) {
        if (this.nameToIdMap.containsKey(name)) {
            int refId = this.nameToIdMap.get(name);
            return this.evaluationStateMap.containsKey(refId) && this.evaluationStateMap.get(refId) != false;
        }
        return false;
    }

    public boolean contains(String name) {
        return this.nameToIdMap.containsKey(name);
    }

    public boolean contains(Expr expr) {
        return this.idToExprBiMap.inverse().containsKey((Object)expr);
    }

    private Expr getExpr(String name) {
        return (Expr)this.idToExprBiMap.get((Object)this.nameToIdMap.get(name));
    }

    public NamedExpr getNamedExpr(String name) {
        String normalized = name;
        return new NamedExpr(this.getExpr(name), normalized);
    }

    public boolean isAliased(String name) {
        return this.aliasedColumnMap.containsKey((Object)name);
    }

    public String getAlias(String originalName) {
        return (String)this.aliasedColumnMap.get((Object)originalName);
    }

    public boolean isAliasedName(String aliasName) {
        return this.aliasedColumnMap.inverse().containsKey((Object)aliasName);
    }

    public String getOriginalName(String aliasName) {
        return (String)this.aliasedColumnMap.inverse().get((Object)aliasName);
    }

    public String addExpr(Expr expr) throws PlanningException {
        if (this.idToExprBiMap.inverse().containsKey((Object)expr)) {
            int refId = (Integer)this.idToExprBiMap.inverse().get((Object)expr);
            return this.idToNamesMap.get(refId).get(0);
        }
        if (this.block.isRegisteredConst(expr)) {
            return this.block.getConstReference(expr);
        }
        String generatedName = this.plan.generateUniqueColumnName(expr);
        return this.addExpr(expr, generatedName);
    }

    public String addExpr(Expr expr, String alias) throws PlanningException {
        int refId;
        if (OpType.isLiteralType((OpType)expr.getType())) {
            return alias;
        }
        if (this.nameToIdMap.containsKey(alias)) {
            return alias;
        }
        if (this.idToExprBiMap.inverse().containsKey((Object)expr)) {
            refId = (Integer)this.idToExprBiMap.inverse().get((Object)expr);
        } else {
            refId = this.getNextId();
            this.idToExprBiMap.put((Object)refId, (Object)expr);
        }
        this.nameToIdMap.put(alias, refId);
        this.evaluationStateMap.put(refId, false);
        TUtil.putToNestedList(this.idToNamesMap, (Object)refId, (Object)alias);
        return alias;
    }

    public String addNamedExpr(NamedExpr namedExpr) throws PlanningException {
        if (namedExpr.hasAlias()) {
            return this.addExpr(namedExpr.getExpr(), namedExpr.getAlias());
        }
        return this.addExpr(namedExpr.getExpr());
    }

    public String[] addNamedExprArray(@Nullable Collection<NamedExpr> namedExprs) throws PlanningException {
        if (namedExprs != null && namedExprs.size() > 0) {
            String[] names = new String[namedExprs.size()];
            int i = 0;
            for (NamedExpr target : namedExprs) {
                names[i++] = this.addNamedExpr(target);
            }
            return names;
        }
        return null;
    }

    public Collection<NamedExpr> getAllNamedExprs() {
        ArrayList namedExprList = Lists.newArrayList();
        for (Map.Entry entry : this.idToExprBiMap.entrySet()) {
            namedExprList.add(new NamedExpr((Expr)entry.getValue(), this.idToNamesMap.get(entry.getKey()).get(0)));
        }
        return namedExprList;
    }

    public void markAsEvaluated(String referenceName, EvalNode evalNode) throws PlanningException {
        String normalized = referenceName;
        int refId = this.nameToIdMap.get(normalized);
        this.evaluationStateMap.put(refId, true);
        this.idToEvalMap.put((Object)refId, (Object)evalNode);
        String originalName = this.checkAndGetIfAliasedColumn(normalized);
        if (originalName != null) {
            this.aliasedColumnMap.put((Object)originalName, (Object)normalized);
        }
    }

    public String checkAndGetIfAliasedColumn(String name) {
        ColumnReferenceExpr column;
        Expr expr = this.getExpr(name);
        if (expr != null && expr.getType() == OpType.Column && !(column = (ColumnReferenceExpr)expr).getCanonicalName().equals(name)) {
            return column.getCanonicalName();
        }
        return null;
    }

    public Target getTarget(String name) {
        return this.getTarget(name, false);
    }

    private boolean isPrimaryName(int id, String name) {
        return this.idToNamesMap.get(id).get(0).equals(name);
    }

    private String getPrimaryName(int id) {
        return this.idToNamesMap.get(id).get(0);
    }

    public Target getTarget(String referenceName, boolean unevaluatedForm) {
        String normalized = referenceName;
        int refId = this.nameToIdMap.get(normalized);
        if (!unevaluatedForm && this.evaluationStateMap.containsKey(refId) && this.evaluationStateMap.get(refId).booleanValue()) {
            EvalNode evalNode = (EvalNode)this.idToEvalMap.get((Object)refId);
            if (evalNode.getType() != EvalType.CONST && this.isEvaluated(normalized) && !this.isPrimaryName(refId, referenceName)) {
                return new Target(new FieldEval(this.getPrimaryName(refId), evalNode.getValueType()), referenceName);
            }
            EvalNode referredEval = evalNode.getType() == EvalType.CONST ? evalNode : new FieldEval(this.idToNamesMap.get(refId).get(0), evalNode.getValueType());
            return new Target(referredEval, referenceName);
        }
        if (this.idToEvalMap.containsKey((Object)refId)) {
            return new Target((EvalNode)this.idToEvalMap.get((Object)refId), referenceName);
        }
        return null;
    }

    public String toString() {
        return "unevaluated=" + this.nameToIdMap.size() + ", evaluated=" + this.idToEvalMap.size() + ", renamed=" + this.aliasedColumnMap.size();
    }

    public Iterator<NamedExpr> getIteratorForUnevaluatedExprs() {
        return new UnevaluatedIterator();
    }

    public class UnevaluatedIterator
    implements Iterator<NamedExpr> {
        private final Iterator<NamedExpr> iterator;

        public UnevaluatedIterator() {
            List unEvaluatedList = TUtil.newList();
            for (Integer refId : NamedExprsManager.this.idToNamesMap.keySet()) {
                String name = (String)((List)NamedExprsManager.this.idToNamesMap.get(refId)).get(0);
                if (NamedExprsManager.this.isEvaluated(name)) continue;
                Expr expr = (Expr)NamedExprsManager.this.idToExprBiMap.get((Object)refId);
                unEvaluatedList.add(new NamedExpr(expr, name));
            }
            this.iterator = unEvaluatedList.size() == 0 ? null : unEvaluatedList.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator != null && this.iterator.hasNext();
        }

        @Override
        public NamedExpr next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
        }
    }
}

