/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan;

import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.common.ProtoObject;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.json.GsonObject;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.FieldEval;
import org.apache.tajo.plan.serder.LogicalNodeSerializer;
import org.apache.tajo.plan.serder.PlanGsonHelper;
import org.apache.tajo.plan.serder.PlanProto;
import org.apache.tajo.util.TUtil;

public class Target
implements Cloneable,
GsonObject,
ProtoObject<PlanProto.Target> {
    @Expose
    private EvalNode expr;
    @Expose
    private Column column;
    @Expose
    private String alias = null;

    public Target(FieldEval fieldEval) {
        this.expr = fieldEval;
        this.column = fieldEval.getColumnRef();
    }

    public Target(EvalNode eval, String alias) {
        this.expr = eval;
        String normalized = alias;
        if (eval instanceof FieldEval && eval.getName().equals(normalized)) {
            this.column = ((FieldEval)eval).getColumnRef();
        } else {
            this.column = new Column(normalized, eval.getValueType());
            this.setAlias(alias);
        }
    }

    public String getCanonicalName() {
        return !this.hasAlias() ? this.column.getQualifiedName() : this.alias;
    }

    public final void setExpr(EvalNode expr) {
        this.expr = expr;
    }

    public final void setAlias(String alias) {
        this.alias = alias;
        this.column = new Column(alias, this.expr.getValueType());
    }

    public final String getAlias() {
        return this.alias;
    }

    public final boolean hasAlias() {
        return this.alias != null;
    }

    public TajoDataTypes.DataType getDataType() {
        return this.column.getDataType();
    }

    public <T extends EvalNode> T getEvalTree() {
        return (T)this.expr;
    }

    public Column getNamedColumn() {
        return this.column;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.expr.toString());
        if (this.hasAlias()) {
            sb.append(" as ").append(this.alias);
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Target) {
            Target other = (Target)obj;
            boolean b1 = this.expr.equals(other.expr);
            boolean b2 = this.column.equals((Object)other.column);
            boolean b3 = TUtil.checkEquals((Object)this.alias, (Object)other.alias);
            return b1 && b2 && b3;
        }
        return false;
    }

    public int hashCode() {
        return this.expr.getName().hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        Target target = (Target)super.clone();
        target.expr = (EvalNode)this.expr.clone();
        target.column = this.column;
        target.alias = this.alias != null ? this.alias : null;
        return target;
    }

    public String toJson() {
        return PlanGsonHelper.toJson(this, Target.class);
    }

    public PlanProto.Target getProto() {
        return LogicalNodeSerializer.convertTarget(this);
    }
}

