/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan;

import com.google.common.base.Preconditions;
import java.util.Stack;
import org.apache.tajo.DataTypeUtil;
import org.apache.tajo.algebra.BetweenPredicate;
import org.apache.tajo.algebra.BinaryOperator;
import org.apache.tajo.algebra.CaseWhenPredicate;
import org.apache.tajo.algebra.CastExpr;
import org.apache.tajo.algebra.ColumnReferenceExpr;
import org.apache.tajo.algebra.CountRowsFunctionExpr;
import org.apache.tajo.algebra.DataTypeExpr;
import org.apache.tajo.algebra.DateLiteral;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.FunctionExpr;
import org.apache.tajo.algebra.GeneralSetFunctionExpr;
import org.apache.tajo.algebra.IntervalLiteral;
import org.apache.tajo.algebra.LiteralValue;
import org.apache.tajo.algebra.NullLiteral;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.algebra.TimeLiteral;
import org.apache.tajo.algebra.TimestampLiteral;
import org.apache.tajo.algebra.UnaryOperator;
import org.apache.tajo.algebra.WindowFunctionExpr;
import org.apache.tajo.catalog.CatalogService;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.FunctionDesc;
import org.apache.tajo.catalog.exception.NoSuchFunctionException;
import org.apache.tajo.catalog.proto.CatalogProtos;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.plan.ExprAnnotator;
import org.apache.tajo.plan.LogicalPlanner;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.visitor.SimpleAlgebraVisitor;

public class TypeDeterminant
extends SimpleAlgebraVisitor<LogicalPlanner.PlanContext, TajoDataTypes.DataType> {
    private TajoDataTypes.DataType BOOL_TYPE = CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.BOOLEAN);
    private CatalogService catalog;

    public TypeDeterminant(CatalogService catalog) {
        this.catalog = catalog;
    }

    public TajoDataTypes.DataType determineDataType(LogicalPlanner.PlanContext ctx, Expr expr) throws PlanningException {
        return (TajoDataTypes.DataType)this.visit(ctx, new Stack<Expr>(), expr);
    }

    @Override
    public TajoDataTypes.DataType visitUnaryOperator(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, UnaryOperator expr) throws PlanningException {
        stack.push((Expr)expr);
        TajoDataTypes.DataType dataType = null;
        switch (expr.getType()) {
            case IsNullPredicate: 
            case ExistsPredicate: {
                dataType = this.BOOL_TYPE;
                break;
            }
            case Cast: {
                dataType = LogicalPlanner.convertDataType(((CastExpr)expr).getTarget());
                break;
            }
            default: {
                dataType = (TajoDataTypes.DataType)this.visit(ctx, stack, expr.getChild());
            }
        }
        return dataType;
    }

    @Override
    public TajoDataTypes.DataType visitBinaryOperator(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        stack.push((Expr)expr);
        TajoDataTypes.DataType lhsType = (TajoDataTypes.DataType)this.visit(ctx, stack, expr.getLeft());
        TajoDataTypes.DataType rhsType = (TajoDataTypes.DataType)this.visit(ctx, stack, expr.getRight());
        stack.pop();
        return this.computeBinaryType(expr.getType(), lhsType, rhsType);
    }

    public TajoDataTypes.DataType computeBinaryType(OpType type, TajoDataTypes.DataType lhsDataType, TajoDataTypes.DataType rhsDataType) throws PlanningException {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)lhsDataType);
        Preconditions.checkNotNull((Object)rhsDataType);
        if (OpType.isLogicalType((OpType)type) || OpType.isComparisonType((OpType)type)) {
            return this.BOOL_TYPE;
        }
        if (OpType.isArithmeticType((OpType)type)) {
            return DataTypeUtil.determineType((TajoDataTypes.DataType)lhsDataType, (TajoDataTypes.DataType)rhsDataType);
        }
        if (type == OpType.Concatenate) {
            return CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.TEXT);
        }
        if (type == OpType.InPredicate) {
            return this.BOOL_TYPE;
        }
        if (type == OpType.LikePredicate || type == OpType.SimilarToPredicate || type == OpType.Regexp) {
            return this.BOOL_TYPE;
        }
        throw new PlanningException(type.name() + "is not binary type");
    }

    @Override
    public TajoDataTypes.DataType visitBetween(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, BetweenPredicate expr) throws PlanningException {
        return CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.BOOLEAN);
    }

    @Override
    public TajoDataTypes.DataType visitCaseWhen(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, CaseWhenPredicate caseWhen) throws PlanningException {
        TajoDataTypes.DataType lastDataType = null;
        for (CaseWhenPredicate.WhenExpr when : caseWhen.getWhens()) {
            TajoDataTypes.DataType resultType = (TajoDataTypes.DataType)this.visit(ctx, stack, when.getResult());
            if (lastDataType != null) {
                lastDataType = CatalogUtil.getWidestType((TajoDataTypes.DataType[])new TajoDataTypes.DataType[]{lastDataType, resultType});
                continue;
            }
            lastDataType = resultType;
        }
        if (caseWhen.hasElseResult()) {
            TajoDataTypes.DataType elseResultType = (TajoDataTypes.DataType)this.visit(ctx, stack, caseWhen.getElseResult());
            lastDataType = CatalogUtil.getWidestType((TajoDataTypes.DataType[])new TajoDataTypes.DataType[]{lastDataType, elseResultType});
        }
        return lastDataType;
    }

    @Override
    public TajoDataTypes.DataType visitColumnReference(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, ColumnReferenceExpr expr) throws PlanningException {
        stack.push((Expr)expr);
        Column column = ctx.plan.resolveColumn(ctx.queryBlock, expr);
        stack.pop();
        return column.getDataType();
    }

    @Override
    public TajoDataTypes.DataType visitFunction(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, FunctionExpr expr) throws PlanningException {
        stack.push((Expr)expr);
        Expr[] params = expr.getParams();
        if (params == null) {
            params = new Expr[]{};
        }
        TajoDataTypes.DataType[] givenArgs = new TajoDataTypes.DataType[params.length];
        TajoDataTypes.DataType[] paramTypes = new TajoDataTypes.DataType[params.length];
        for (int i = 0; i < params.length; ++i) {
            givenArgs[i] = (TajoDataTypes.DataType)this.visit(ctx, stack, params[i]);
            paramTypes[i] = givenArgs[i];
        }
        stack.pop();
        if (!this.catalog.containFunction(expr.getSignature(), paramTypes)) {
            throw new NoSuchFunctionException(expr.getSignature(), paramTypes);
        }
        FunctionDesc funcDesc = this.catalog.getFunction(expr.getSignature(), paramTypes);
        return funcDesc.getReturnType();
    }

    @Override
    public TajoDataTypes.DataType visitCountRowsFunction(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, CountRowsFunctionExpr expr) throws PlanningException {
        FunctionDesc countRows = this.catalog.getFunction("count", CatalogProtos.FunctionType.AGGREGATION, new TajoDataTypes.DataType[0]);
        return countRows.getReturnType();
    }

    @Override
    public TajoDataTypes.DataType visitGeneralSetFunction(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, GeneralSetFunctionExpr setFunction) throws PlanningException {
        stack.push((Expr)setFunction);
        Expr[] params = setFunction.getParams();
        TajoDataTypes.DataType[] givenArgs = new TajoDataTypes.DataType[params.length];
        TajoDataTypes.DataType[] paramTypes = new TajoDataTypes.DataType[params.length];
        CatalogProtos.FunctionType functionType = setFunction.isDistinct() ? CatalogProtos.FunctionType.DISTINCT_AGGREGATION : CatalogProtos.FunctionType.AGGREGATION;
        givenArgs[0] = (TajoDataTypes.DataType)this.visit(ctx, stack, params[0]);
        paramTypes[0] = setFunction.getSignature().equalsIgnoreCase("count") ? CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.ANY) : givenArgs[0];
        stack.pop();
        if (!this.catalog.containFunction(setFunction.getSignature(), functionType, paramTypes)) {
            throw new NoSuchFunctionException(setFunction.getSignature(), paramTypes);
        }
        FunctionDesc funcDesc = this.catalog.getFunction(setFunction.getSignature(), functionType, paramTypes);
        return funcDesc.getReturnType();
    }

    @Override
    public TajoDataTypes.DataType visitWindowFunction(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, WindowFunctionExpr windowFunc) throws PlanningException {
        CatalogProtos.FunctionType functionType;
        stack.push((Expr)windowFunc);
        String funcName = windowFunc.getSignature();
        boolean distinct = windowFunc.isDistinct();
        Expr[] params = windowFunc.getParams();
        TajoDataTypes.DataType[] givenArgs = new TajoDataTypes.DataType[params.length];
        TajoDataTypes.DataType[] paramTypes = new TajoDataTypes.DataType[params.length];
        if (params.length > 0) {
            givenArgs[0] = (TajoDataTypes.DataType)this.visit(ctx, stack, params[0]);
            paramTypes[0] = windowFunc.getSignature().equalsIgnoreCase("count") ? CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.ANY) : (windowFunc.getSignature().equalsIgnoreCase("row_number") ? CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.INT8) : givenArgs[0]);
            for (int i = 1; i < params.length; ++i) {
                givenArgs[i] = (TajoDataTypes.DataType)this.visit(ctx, stack, params[i]);
                paramTypes[i] = givenArgs[i];
            }
        }
        stack.pop();
        if (ExprAnnotator.WINDOW_FUNCTIONS.contains(funcName.toLowerCase())) {
            if (distinct) {
                throw new NoSuchFunctionException("row_number() does not support distinct keyword.");
            }
            functionType = CatalogProtos.FunctionType.WINDOW;
        } else {
            CatalogProtos.FunctionType functionType2 = functionType = distinct ? CatalogProtos.FunctionType.DISTINCT_AGGREGATION : CatalogProtos.FunctionType.AGGREGATION;
        }
        if (!this.catalog.containFunction(windowFunc.getSignature(), functionType, paramTypes)) {
            throw new NoSuchFunctionException(funcName, paramTypes);
        }
        FunctionDesc funcDesc = this.catalog.getFunction(funcName, functionType, paramTypes);
        return funcDesc.getReturnType();
    }

    @Override
    public TajoDataTypes.DataType visitDataType(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, DataTypeExpr expr) throws PlanningException {
        return LogicalPlanner.convertDataType(expr);
    }

    @Override
    public TajoDataTypes.DataType visitLiteral(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, LiteralValue expr) throws PlanningException {
        switch (expr.getValueType()) {
            case Boolean: {
                return CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.BOOLEAN);
            }
            case String: {
                return CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.TEXT);
            }
            case Unsigned_Integer: {
                return CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.INT4);
            }
            case Unsigned_Large_Integer: {
                return CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.INT8);
            }
            case Unsigned_Float: {
                return CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.FLOAT8);
            }
        }
        throw new RuntimeException("Unsupported type: " + expr.getValueType());
    }

    @Override
    public TajoDataTypes.DataType visitNullLiteral(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, NullLiteral expr) throws PlanningException {
        return CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.NULL_TYPE);
    }

    @Override
    public TajoDataTypes.DataType visitTimestampLiteral(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, TimestampLiteral expr) throws PlanningException {
        return CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.TIMESTAMP);
    }

    @Override
    public TajoDataTypes.DataType visitTimeLiteral(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, TimeLiteral expr) throws PlanningException {
        return CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.TIME);
    }

    @Override
    public TajoDataTypes.DataType visitDateLiteral(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, DateLiteral expr) throws PlanningException {
        return CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.DATE);
    }

    @Override
    public TajoDataTypes.DataType visitIntervalLiteral(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, IntervalLiteral expr) throws PlanningException {
        return CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.INTERVAL);
    }
}

