/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.algebra;

import java.util.Stack;
import org.apache.tajo.algebra.Aggregation;
import org.apache.tajo.algebra.AlterTable;
import org.apache.tajo.algebra.AlterTablespace;
import org.apache.tajo.algebra.BetweenPredicate;
import org.apache.tajo.algebra.BinaryOperator;
import org.apache.tajo.algebra.CaseWhenPredicate;
import org.apache.tajo.algebra.CastExpr;
import org.apache.tajo.algebra.ColumnReferenceExpr;
import org.apache.tajo.algebra.CountRowsFunctionExpr;
import org.apache.tajo.algebra.CreateDatabase;
import org.apache.tajo.algebra.CreateTable;
import org.apache.tajo.algebra.DataTypeExpr;
import org.apache.tajo.algebra.DateLiteral;
import org.apache.tajo.algebra.DropDatabase;
import org.apache.tajo.algebra.DropTable;
import org.apache.tajo.algebra.ExistsPredicate;
import org.apache.tajo.algebra.Explain;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.FunctionExpr;
import org.apache.tajo.algebra.GeneralSetFunctionExpr;
import org.apache.tajo.algebra.Having;
import org.apache.tajo.algebra.InPredicate;
import org.apache.tajo.algebra.Insert;
import org.apache.tajo.algebra.IntervalLiteral;
import org.apache.tajo.algebra.IsNullPredicate;
import org.apache.tajo.algebra.Join;
import org.apache.tajo.algebra.Limit;
import org.apache.tajo.algebra.LiteralValue;
import org.apache.tajo.algebra.NamedExpr;
import org.apache.tajo.algebra.NotExpr;
import org.apache.tajo.algebra.NullLiteral;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.algebra.PatternMatchPredicate;
import org.apache.tajo.algebra.Projection;
import org.apache.tajo.algebra.QualifiedAsteriskExpr;
import org.apache.tajo.algebra.Relation;
import org.apache.tajo.algebra.RelationList;
import org.apache.tajo.algebra.ScalarSubQuery;
import org.apache.tajo.algebra.Selection;
import org.apache.tajo.algebra.SetOperation;
import org.apache.tajo.algebra.SetSession;
import org.apache.tajo.algebra.SignedExpr;
import org.apache.tajo.algebra.SimpleTableSubQuery;
import org.apache.tajo.algebra.Sort;
import org.apache.tajo.algebra.TablePrimarySubQuery;
import org.apache.tajo.algebra.TimeLiteral;
import org.apache.tajo.algebra.TimestampLiteral;
import org.apache.tajo.algebra.TruncateTable;
import org.apache.tajo.algebra.UnaryOperator;
import org.apache.tajo.algebra.ValueListExpr;
import org.apache.tajo.algebra.WindowFunctionExpr;
import org.apache.tajo.algebra.WindowSpec;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.algebra.AlgebraVisitor;

public class BaseAlgebraVisitor<CONTEXT, RESULT>
implements AlgebraVisitor<CONTEXT, RESULT> {
    public void preHook(CONTEXT ctx, Stack<Expr> stack, Expr expr) throws PlanningException {
    }

    public RESULT postHook(CONTEXT ctx, Stack<Expr> stack, Expr expr, RESULT current) throws PlanningException {
        return current;
    }

    public RESULT visit(CONTEXT ctx, Stack<Expr> stack, Expr expr) throws PlanningException {
        RelationList relationList;
        RESULT current;
        this.preHook(ctx, stack, expr);
        switch (expr.getType()) {
            case SetSession: {
                current = this.visitSetSession(ctx, stack, (SetSession)expr);
                break;
            }
            case Projection: {
                current = this.visitProjection(ctx, stack, (Projection)expr);
                break;
            }
            case Limit: {
                current = this.visitLimit(ctx, stack, (Limit)expr);
                break;
            }
            case Sort: {
                current = this.visitSort(ctx, stack, (Sort)expr);
                break;
            }
            case Having: {
                current = this.visitHaving(ctx, stack, (Having)expr);
                break;
            }
            case Aggregation: {
                current = this.visitGroupBy(ctx, stack, (Aggregation)expr);
                break;
            }
            case Join: {
                current = this.visitJoin(ctx, stack, (Join)expr);
                break;
            }
            case Filter: {
                current = this.visitFilter(ctx, stack, (Selection)expr);
                break;
            }
            case Union: {
                current = this.visitUnion(ctx, stack, (SetOperation)expr);
                break;
            }
            case Except: {
                current = this.visitExcept(ctx, stack, (SetOperation)expr);
                break;
            }
            case Intersect: {
                current = this.visitIntersect(ctx, stack, (SetOperation)expr);
                break;
            }
            case SimpleTableSubQuery: {
                current = this.visitSimpleTableSubQuery(ctx, stack, (SimpleTableSubQuery)expr);
                break;
            }
            case TablePrimaryTableSubQuery: {
                current = this.visitTableSubQuery(ctx, stack, (TablePrimarySubQuery)expr);
                break;
            }
            case RelationList: {
                current = this.visitRelationList(ctx, stack, (RelationList)expr);
                break;
            }
            case Relation: {
                current = this.visitRelation(ctx, stack, (Relation)expr);
                break;
            }
            case ScalarSubQuery: {
                current = this.visitScalarSubQuery(ctx, stack, (ScalarSubQuery)expr);
                break;
            }
            case Explain: {
                current = this.visitExplain(ctx, stack, (Explain)expr);
                break;
            }
            case CreateDatabase: {
                current = this.visitCreateDatabase(ctx, stack, (CreateDatabase)expr);
                break;
            }
            case DropDatabase: {
                current = this.visitDropDatabase(ctx, stack, (DropDatabase)expr);
                break;
            }
            case CreateTable: {
                current = this.visitCreateTable(ctx, stack, (CreateTable)expr);
                break;
            }
            case DropTable: {
                current = this.visitDropTable(ctx, stack, (DropTable)expr);
                break;
            }
            case AlterTablespace: {
                current = this.visitAlterTablespace(ctx, stack, (AlterTablespace)expr);
                break;
            }
            case AlterTable: {
                current = this.visitAlterTable(ctx, stack, (AlterTable)expr);
                break;
            }
            case TruncateTable: {
                current = this.visitTruncateTable(ctx, stack, (TruncateTable)expr);
                break;
            }
            case Insert: {
                current = this.visitInsert(ctx, stack, (Insert)expr);
                break;
            }
            case And: {
                current = this.visitAnd(ctx, stack, (BinaryOperator)expr);
                break;
            }
            case Or: {
                current = this.visitOr(ctx, stack, (BinaryOperator)expr);
                break;
            }
            case Not: {
                current = this.visitNot(ctx, stack, (NotExpr)expr);
                break;
            }
            case Equals: {
                current = this.visitEquals(ctx, stack, (BinaryOperator)expr);
                break;
            }
            case NotEquals: {
                current = this.visitNotEquals(ctx, stack, (BinaryOperator)expr);
                break;
            }
            case LessThan: {
                current = this.visitLessThan(ctx, stack, (BinaryOperator)expr);
                break;
            }
            case LessThanOrEquals: {
                current = this.visitLessThanOrEquals(ctx, stack, (BinaryOperator)expr);
                break;
            }
            case GreaterThan: {
                current = this.visitGreaterThan(ctx, stack, (BinaryOperator)expr);
                break;
            }
            case GreaterThanOrEquals: {
                current = this.visitGreaterThanOrEquals(ctx, stack, (BinaryOperator)expr);
                break;
            }
            case Between: {
                current = this.visitBetween(ctx, stack, (BetweenPredicate)expr);
                break;
            }
            case CaseWhen: {
                current = this.visitCaseWhen(ctx, stack, (CaseWhenPredicate)expr);
                break;
            }
            case IsNullPredicate: {
                current = this.visitIsNullPredicate(ctx, stack, (IsNullPredicate)expr);
                break;
            }
            case InPredicate: {
                current = this.visitInPredicate(ctx, stack, (InPredicate)expr);
                break;
            }
            case ValueList: {
                current = this.visitValueListExpr(ctx, stack, (ValueListExpr)expr);
                break;
            }
            case ExistsPredicate: {
                current = this.visitExistsPredicate(ctx, stack, (ExistsPredicate)expr);
                break;
            }
            case LikePredicate: {
                current = this.visitLikePredicate(ctx, stack, (PatternMatchPredicate)expr);
                break;
            }
            case SimilarToPredicate: {
                current = this.visitSimilarToPredicate(ctx, stack, (PatternMatchPredicate)expr);
                break;
            }
            case Regexp: {
                current = this.visitRegexpPredicate(ctx, stack, (PatternMatchPredicate)expr);
                break;
            }
            case Concatenate: {
                current = this.visitConcatenate(ctx, stack, (BinaryOperator)expr);
                break;
            }
            case Plus: {
                current = this.visitPlus(ctx, stack, (BinaryOperator)expr);
                break;
            }
            case Minus: {
                current = this.visitMinus(ctx, stack, (BinaryOperator)expr);
                break;
            }
            case Multiply: {
                current = this.visitMultiply(ctx, stack, (BinaryOperator)expr);
                break;
            }
            case Divide: {
                current = this.visitDivide(ctx, stack, (BinaryOperator)expr);
                break;
            }
            case Modular: {
                current = this.visitModular(ctx, stack, (BinaryOperator)expr);
                break;
            }
            case Sign: {
                current = this.visitSign(ctx, stack, (SignedExpr)expr);
                break;
            }
            case Column: {
                current = this.visitColumnReference(ctx, stack, (ColumnReferenceExpr)expr);
                break;
            }
            case Target: {
                current = this.visitTargetExpr(ctx, stack, (NamedExpr)expr);
                break;
            }
            case Function: {
                current = this.visitFunction(ctx, stack, (FunctionExpr)expr);
                break;
            }
            case Asterisk: {
                current = this.visitQualifiedAsterisk(ctx, stack, (QualifiedAsteriskExpr)expr);
                break;
            }
            case CountRowsFunction: {
                current = this.visitCountRowsFunction(ctx, stack, (CountRowsFunctionExpr)expr);
                break;
            }
            case GeneralSetFunction: {
                current = this.visitGeneralSetFunction(ctx, stack, (GeneralSetFunctionExpr)expr);
                break;
            }
            case WindowFunction: {
                current = this.visitWindowFunction(ctx, stack, (WindowFunctionExpr)expr);
                break;
            }
            case DataType: {
                current = this.visitDataType(ctx, stack, (DataTypeExpr)expr);
                break;
            }
            case Cast: {
                current = this.visitCastExpr(ctx, stack, (CastExpr)expr);
                break;
            }
            case Literal: {
                current = this.visitLiteral(ctx, stack, (LiteralValue)expr);
                break;
            }
            case NullLiteral: {
                current = this.visitNullLiteral(ctx, stack, (NullLiteral)expr);
                break;
            }
            case DateLiteral: {
                current = this.visitDateLiteral(ctx, stack, (DateLiteral)expr);
                break;
            }
            case TimeLiteral: {
                current = this.visitTimeLiteral(ctx, stack, (TimeLiteral)expr);
                break;
            }
            case TimestampLiteral: {
                current = this.visitTimestampLiteral(ctx, stack, (TimestampLiteral)expr);
                break;
            }
            case IntervalLiteral: {
                current = this.visitIntervalLiteral(ctx, stack, (IntervalLiteral)expr);
                break;
            }
            default: {
                throw new PlanningException("Cannot support this type algebra \"" + expr.getType() + "\"");
            }
        }
        if (expr.getType() == OpType.RelationList && (relationList = (RelationList)expr).size() == 1 && relationList.getRelations()[0].getType() == OpType.Relation) {
            return current;
        }
        this.postHook(ctx, stack, expr, current);
        return current;
    }

    private RESULT visitDefaultUnaryExpr(CONTEXT ctx, Stack<Expr> stack, UnaryOperator expr) throws PlanningException {
        stack.push((Expr)expr);
        RESULT child = this.visit(ctx, stack, expr.getChild());
        stack.pop();
        return child;
    }

    private RESULT visitDefaultBinaryExpr(CONTEXT ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        stack.push((Expr)expr);
        RESULT child = this.visit(ctx, stack, expr.getLeft());
        this.visit(ctx, stack, expr.getRight());
        stack.pop();
        return child;
    }

    @Override
    public RESULT visitSetSession(CONTEXT ctx, Stack<Expr> stack, SetSession expr) throws PlanningException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RESULT visitProjection(CONTEXT ctx, Stack<Expr> stack, Projection expr) throws PlanningException {
        stack.push((Expr)expr);
        try {
            for (NamedExpr target : expr.getNamedExprs()) {
                this.visit(ctx, stack, (Expr)target);
            }
            if (expr.hasChild()) {
                RESULT RESULT = this.visit(ctx, stack, expr.getChild());
                return RESULT;
            }
        }
        finally {
            stack.pop();
        }
        return null;
    }

    @Override
    public RESULT visitLimit(CONTEXT ctx, Stack<Expr> stack, Limit expr) throws PlanningException {
        stack.push((Expr)expr);
        this.visit(ctx, stack, expr.getFetchFirstNum());
        RESULT result = this.visit(ctx, stack, expr.getChild());
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitSort(CONTEXT ctx, Stack<Expr> stack, Sort expr) throws PlanningException {
        stack.push((Expr)expr);
        for (Sort.SortSpec sortSpec : expr.getSortSpecs()) {
            this.visit(ctx, stack, sortSpec.getKey());
        }
        RESULT result = this.visit(ctx, stack, expr.getChild());
        return result;
    }

    @Override
    public RESULT visitHaving(CONTEXT ctx, Stack<Expr> stack, Having expr) throws PlanningException {
        stack.push((Expr)expr);
        this.visit(ctx, stack, expr.getQual());
        RESULT result = this.visit(ctx, stack, expr.getChild());
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitGroupBy(CONTEXT ctx, Stack<Expr> stack, Aggregation expr) throws PlanningException {
        stack.push((Expr)expr);
        for (Aggregation.GroupElement groupElement : expr.getGroupSet()) {
            for (Expr groupingSet : groupElement.getGroupingSets()) {
                this.visit(ctx, stack, groupingSet);
            }
        }
        RESULT result = this.visit(ctx, stack, expr.getChild());
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitJoin(CONTEXT ctx, Stack<Expr> stack, Join expr) throws PlanningException {
        stack.push((Expr)expr);
        this.visit(ctx, stack, expr.getQual());
        this.visit(ctx, stack, expr.getLeft());
        RESULT result = this.visit(ctx, stack, expr.getRight());
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitFilter(CONTEXT ctx, Stack<Expr> stack, Selection expr) throws PlanningException {
        stack.push((Expr)expr);
        this.visit(ctx, stack, expr.getQual());
        RESULT result = this.visit(ctx, stack, expr.getChild());
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitUnion(CONTEXT ctx, Stack<Expr> stack, SetOperation expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, (BinaryOperator)expr);
    }

    @Override
    public RESULT visitExcept(CONTEXT ctx, Stack<Expr> stack, SetOperation expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, (BinaryOperator)expr);
    }

    @Override
    public RESULT visitIntersect(CONTEXT ctx, Stack<Expr> stack, SetOperation expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, (BinaryOperator)expr);
    }

    @Override
    public RESULT visitSimpleTableSubQuery(CONTEXT ctx, Stack<Expr> stack, SimpleTableSubQuery expr) throws PlanningException {
        return this.visitDefaultUnaryExpr(ctx, stack, (UnaryOperator)expr);
    }

    @Override
    public RESULT visitTableSubQuery(CONTEXT ctx, Stack<Expr> stack, TablePrimarySubQuery expr) throws PlanningException {
        stack.push((Expr)expr);
        RESULT child = this.visit(ctx, stack, expr.getSubQuery());
        stack.pop();
        return child;
    }

    @Override
    public RESULT visitRelationList(CONTEXT ctx, Stack<Expr> stack, RelationList expr) throws PlanningException {
        stack.push((Expr)expr);
        RESULT child = null;
        for (Expr e : expr.getRelations()) {
            child = this.visit(ctx, stack, e);
        }
        stack.pop();
        return child;
    }

    @Override
    public RESULT visitRelation(CONTEXT ctx, Stack<Expr> stack, Relation expr) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitScalarSubQuery(CONTEXT ctx, Stack<Expr> stack, ScalarSubQuery expr) throws PlanningException {
        return this.visitDefaultUnaryExpr(ctx, stack, (UnaryOperator)expr);
    }

    @Override
    public RESULT visitExplain(CONTEXT ctx, Stack<Expr> stack, Explain expr) throws PlanningException {
        stack.push((Expr)expr);
        RESULT child = this.visit(ctx, stack, expr.getChild());
        stack.pop();
        return child;
    }

    @Override
    public RESULT visitCreateDatabase(CONTEXT ctx, Stack<Expr> stack, CreateDatabase expr) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitDropDatabase(CONTEXT ctx, Stack<Expr> stack, DropDatabase expr) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitCreateTable(CONTEXT ctx, Stack<Expr> stack, CreateTable expr) throws PlanningException {
        stack.push((Expr)expr);
        RESULT child = null;
        if (expr.hasSubQuery()) {
            child = this.visit(ctx, stack, expr.getSubQuery());
        }
        stack.pop();
        return child;
    }

    @Override
    public RESULT visitDropTable(CONTEXT ctx, Stack<Expr> stack, DropTable expr) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitAlterTablespace(CONTEXT ctx, Stack<Expr> stack, AlterTablespace expr) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitAlterTable(CONTEXT ctx, Stack<Expr> stack, AlterTable expr) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitTruncateTable(CONTEXT ctx, Stack<Expr> stack, TruncateTable expr) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitInsert(CONTEXT ctx, Stack<Expr> stack, Insert expr) throws PlanningException {
        stack.push((Expr)expr);
        RESULT child = this.visit(ctx, stack, expr.getSubQuery());
        stack.pop();
        return child;
    }

    @Override
    public RESULT visitAnd(CONTEXT ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, expr);
    }

    @Override
    public RESULT visitOr(CONTEXT ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, expr);
    }

    @Override
    public RESULT visitNot(CONTEXT ctx, Stack<Expr> stack, NotExpr expr) throws PlanningException {
        return this.visitDefaultUnaryExpr(ctx, stack, (UnaryOperator)expr);
    }

    @Override
    public RESULT visitEquals(CONTEXT ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, expr);
    }

    @Override
    public RESULT visitNotEquals(CONTEXT ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, expr);
    }

    @Override
    public RESULT visitLessThan(CONTEXT ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, expr);
    }

    @Override
    public RESULT visitLessThanOrEquals(CONTEXT ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, expr);
    }

    @Override
    public RESULT visitGreaterThan(CONTEXT ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, expr);
    }

    @Override
    public RESULT visitGreaterThanOrEquals(CONTEXT ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, expr);
    }

    @Override
    public RESULT visitBetween(CONTEXT ctx, Stack<Expr> stack, BetweenPredicate expr) throws PlanningException {
        stack.push((Expr)expr);
        RESULT result = this.visit(ctx, stack, expr.predicand());
        this.visit(ctx, stack, expr.begin());
        this.visit(ctx, stack, expr.end());
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitCaseWhen(CONTEXT ctx, Stack<Expr> stack, CaseWhenPredicate expr) throws PlanningException {
        stack.push((Expr)expr);
        RESULT result = null;
        for (CaseWhenPredicate.WhenExpr when : expr.getWhens()) {
            result = this.visit(ctx, stack, when.getCondition());
            this.visit(ctx, stack, when.getResult());
        }
        if (expr.hasElseResult()) {
            this.visit(ctx, stack, expr.getElseResult());
        }
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitIsNullPredicate(CONTEXT ctx, Stack<Expr> stack, IsNullPredicate expr) throws PlanningException {
        return this.visitDefaultUnaryExpr(ctx, stack, (UnaryOperator)expr);
    }

    @Override
    public RESULT visitInPredicate(CONTEXT ctx, Stack<Expr> stack, InPredicate expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, (BinaryOperator)expr);
    }

    @Override
    public RESULT visitValueListExpr(CONTEXT ctx, Stack<Expr> stack, ValueListExpr expr) throws PlanningException {
        stack.push((Expr)expr);
        RESULT result = null;
        for (Expr value : expr.getValues()) {
            result = this.visit(ctx, stack, value);
        }
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitExistsPredicate(CONTEXT ctx, Stack<Expr> stack, ExistsPredicate expr) throws PlanningException {
        return this.visitDefaultUnaryExpr(ctx, stack, (UnaryOperator)expr);
    }

    @Override
    public RESULT visitLikePredicate(CONTEXT ctx, Stack<Expr> stack, PatternMatchPredicate expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, (BinaryOperator)expr);
    }

    @Override
    public RESULT visitSimilarToPredicate(CONTEXT ctx, Stack<Expr> stack, PatternMatchPredicate expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, (BinaryOperator)expr);
    }

    @Override
    public RESULT visitRegexpPredicate(CONTEXT ctx, Stack<Expr> stack, PatternMatchPredicate expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, (BinaryOperator)expr);
    }

    @Override
    public RESULT visitConcatenate(CONTEXT ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, expr);
    }

    @Override
    public RESULT visitPlus(CONTEXT ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, expr);
    }

    @Override
    public RESULT visitMinus(CONTEXT ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, expr);
    }

    @Override
    public RESULT visitMultiply(CONTEXT ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, expr);
    }

    @Override
    public RESULT visitDivide(CONTEXT ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, expr);
    }

    @Override
    public RESULT visitModular(CONTEXT ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        return this.visitDefaultBinaryExpr(ctx, stack, expr);
    }

    @Override
    public RESULT visitSign(CONTEXT ctx, Stack<Expr> stack, SignedExpr expr) throws PlanningException {
        return this.visitDefaultUnaryExpr(ctx, stack, (UnaryOperator)expr);
    }

    @Override
    public RESULT visitColumnReference(CONTEXT ctx, Stack<Expr> stack, ColumnReferenceExpr expr) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitTargetExpr(CONTEXT ctx, Stack<Expr> stack, NamedExpr expr) throws PlanningException {
        return this.visitDefaultUnaryExpr(ctx, stack, (UnaryOperator)expr);
    }

    @Override
    public RESULT visitFunction(CONTEXT ctx, Stack<Expr> stack, FunctionExpr expr) throws PlanningException {
        stack.push((Expr)expr);
        RESULT result = null;
        if (expr.hasParams()) {
            for (Expr param : expr.getParams()) {
                result = this.visit(ctx, stack, param);
            }
        }
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitQualifiedAsterisk(CONTEXT ctx, Stack<Expr> stack, QualifiedAsteriskExpr expr) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitCountRowsFunction(CONTEXT ctx, Stack<Expr> stack, CountRowsFunctionExpr expr) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitGeneralSetFunction(CONTEXT ctx, Stack<Expr> stack, GeneralSetFunctionExpr expr) throws PlanningException {
        stack.push((Expr)expr);
        RESULT result = null;
        for (Expr param : expr.getParams()) {
            result = this.visit(ctx, stack, param);
        }
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitWindowFunction(CONTEXT ctx, Stack<Expr> stack, WindowFunctionExpr expr) throws PlanningException {
        stack.push((Expr)expr);
        RESULT result = null;
        for (Expr param : expr.getParams()) {
            result = this.visit(ctx, stack, param);
        }
        WindowSpec windowSpec = expr.getWindowSpec();
        if (windowSpec.hasPartitionBy()) {
            for (Expr partitionKey : windowSpec.getPartitionKeys()) {
                this.visit(ctx, stack, partitionKey);
            }
        }
        if (windowSpec.hasOrderBy()) {
            for (Sort.SortSpec sortKey : windowSpec.getSortSpecs()) {
                this.visit(ctx, stack, sortKey.getKey());
            }
        }
        if (windowSpec.hasWindowFrame()) {
            if (windowSpec.getWindowFrame().getStartBound().hasNumber()) {
                this.visit(ctx, stack, windowSpec.getWindowFrame().getStartBound().getNumber());
            }
            if (windowSpec.getWindowFrame().getEndBound().hasNumber()) {
                this.visit(ctx, stack, windowSpec.getWindowFrame().getEndBound().getNumber());
            }
        }
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitDataType(CONTEXT ctx, Stack<Expr> stack, DataTypeExpr expr) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitCastExpr(CONTEXT ctx, Stack<Expr> stack, CastExpr expr) throws PlanningException {
        stack.push((Expr)expr);
        RESULT result = this.visit(ctx, stack, expr.getOperand());
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitLiteral(CONTEXT ctx, Stack<Expr> stack, LiteralValue expr) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitNullLiteral(CONTEXT ctx, Stack<Expr> stack, NullLiteral expr) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitTimestampLiteral(CONTEXT ctx, Stack<Expr> stack, TimestampLiteral expr) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitIntervalLiteral(CONTEXT ctx, Stack<Expr> stack, IntervalLiteral expr) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitTimeLiteral(CONTEXT ctx, Stack<Expr> stack, TimeLiteral expr) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitDateLiteral(CONTEXT ctx, Stack<Expr> stack, DateLiteral expr) throws PlanningException {
        return null;
    }
}

