/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.FunctionDesc;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.FunctionEval;
import org.apache.tajo.plan.function.AggFunction;
import org.apache.tajo.plan.function.FunctionContext;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.storage.VTuple;
import org.apache.tajo.util.TUtil;

public class AggregationFunctionCallEval
extends FunctionEval
implements Cloneable {
    @Expose
    boolean intermediatePhase = false;
    @Expose
    boolean finalPhase = true;
    @Expose
    String alias;
    protected AggFunction instance;
    private Tuple params;

    protected AggregationFunctionCallEval(EvalType type, FunctionDesc desc, AggFunction instance, EvalNode[] givenArgs) {
        super(type, desc, givenArgs);
        this.instance = instance;
    }

    public AggregationFunctionCallEval(FunctionDesc desc, AggFunction instance, EvalNode[] givenArgs) {
        super(EvalType.AGG_FUNCTION, desc, givenArgs);
        this.instance = instance;
    }

    public FunctionContext newContext() {
        return this.instance.newContext();
    }

    public void merge(FunctionContext context, Schema schema, Tuple tuple) {
        if (this.params == null) {
            this.params = new VTuple(this.argEvals.length);
        }
        if (this.argEvals != null) {
            for (int i = 0; i < this.argEvals.length; ++i) {
                this.params.put(i, this.argEvals[i].eval(schema, tuple));
            }
        }
        if (!this.intermediatePhase && !this.finalPhase) {
            this.instance.eval(context, this.params);
        } else {
            this.instance.merge(context, this.params);
        }
    }

    @Override
    public Datum eval(Schema schema, Tuple tuple) {
        throw new UnsupportedOperationException("Cannot execute eval() of aggregation function");
    }

    public Datum terminate(FunctionContext context) {
        if (!this.finalPhase) {
            return this.instance.getPartialResult(context);
        }
        return this.instance.terminate(context);
    }

    @Override
    public TajoDataTypes.DataType getValueType() {
        if (!this.finalPhase) {
            return this.instance.getPartialResultType();
        }
        return this.funcDesc.getReturnType();
    }

    public boolean hasAlias() {
        return this.alias != null;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AggregationFunctionCallEval clone = (AggregationFunctionCallEval)super.clone();
        clone.finalPhase = this.finalPhase;
        clone.intermediatePhase = this.intermediatePhase;
        clone.alias = this.alias;
        clone.instance = (AggFunction)((Object)this.instance.clone());
        return clone;
    }

    public boolean isIntermediatePhase() {
        return this.intermediatePhase;
    }

    public void setIntermediatePhase(boolean flag) {
        this.intermediatePhase = flag;
    }

    public void setFinalPhase(boolean flag) {
        this.finalPhase = flag;
    }

    public boolean isFinalPhase() {
        return this.finalPhase;
    }

    public void setFirstPhase() {
        this.finalPhase = false;
        this.intermediatePhase = false;
    }

    public void setFinalPhase() {
        this.finalPhase = true;
        this.intermediatePhase = false;
    }

    public void setIntermediatePhase() {
        this.finalPhase = false;
        this.intermediatePhase = true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AggregationFunctionCallEval) {
            AggregationFunctionCallEval other = (AggregationFunctionCallEval)obj;
            boolean eq = super.equals(other);
            eq &= this.instance.equals((Object)other.instance);
            eq &= this.intermediatePhase == other.intermediatePhase;
            eq &= this.finalPhase == other.finalPhase;
            return eq &= TUtil.checkEquals((Object)this.alias, (Object)other.alias);
        }
        return false;
    }
}

