/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import java.util.Stack;
import org.apache.tajo.exception.UnsupportedException;
import org.apache.tajo.plan.expr.AggregationFunctionCallEval;
import org.apache.tajo.plan.expr.BetweenPredicateEval;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.CaseWhenEval;
import org.apache.tajo.plan.expr.CastEval;
import org.apache.tajo.plan.expr.ConstEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalNodeVisitor2;
import org.apache.tajo.plan.expr.FieldEval;
import org.apache.tajo.plan.expr.FunctionEval;
import org.apache.tajo.plan.expr.GeneralFunctionEval;
import org.apache.tajo.plan.expr.InEval;
import org.apache.tajo.plan.expr.IsNullEval;
import org.apache.tajo.plan.expr.LikePredicateEval;
import org.apache.tajo.plan.expr.NotEval;
import org.apache.tajo.plan.expr.RegexPredicateEval;
import org.apache.tajo.plan.expr.RowConstantEval;
import org.apache.tajo.plan.expr.SignedEval;
import org.apache.tajo.plan.expr.SimilarToPredicateEval;
import org.apache.tajo.plan.expr.UnaryEval;
import org.apache.tajo.plan.expr.WindowFunctionEval;

public class BasicEvalNodeVisitor<CONTEXT, RESULT>
implements EvalNodeVisitor2<CONTEXT, RESULT> {
    @Override
    public RESULT visitChild(CONTEXT context, EvalNode evalNode, Stack<EvalNode> stack) {
        RESULT result;
        switch (evalNode.getType()) {
            case CONST: {
                result = this.visitConst(context, (ConstEval)evalNode, stack);
                break;
            }
            case ROW_CONSTANT: {
                result = this.visitRowConstant(context, (RowConstantEval)evalNode, stack);
                break;
            }
            case FIELD: {
                result = this.visitField(context, stack, (FieldEval)evalNode);
                break;
            }
            case PLUS: {
                result = this.visitPlus(context, (BinaryEval)evalNode, stack);
                break;
            }
            case MINUS: {
                result = this.visitMinus(context, (BinaryEval)evalNode, stack);
                break;
            }
            case MULTIPLY: {
                result = this.visitMultiply(context, (BinaryEval)evalNode, stack);
                break;
            }
            case DIVIDE: {
                result = this.visitDivide(context, (BinaryEval)evalNode, stack);
                break;
            }
            case MODULAR: {
                result = this.visitModular(context, (BinaryEval)evalNode, stack);
                break;
            }
            case AND: {
                result = this.visitAnd(context, (BinaryEval)evalNode, stack);
                break;
            }
            case OR: {
                result = this.visitOr(context, (BinaryEval)evalNode, stack);
                break;
            }
            case NOT: {
                result = this.visitNot(context, (NotEval)evalNode, stack);
                break;
            }
            case EQUAL: {
                result = this.visitEqual(context, (BinaryEval)evalNode, stack);
                break;
            }
            case NOT_EQUAL: {
                result = this.visitNotEqual(context, (BinaryEval)evalNode, stack);
                break;
            }
            case LTH: {
                result = this.visitLessThan(context, (BinaryEval)evalNode, stack);
                break;
            }
            case LEQ: {
                result = this.visitLessThanOrEqual(context, (BinaryEval)evalNode, stack);
                break;
            }
            case GTH: {
                result = this.visitGreaterThan(context, (BinaryEval)evalNode, stack);
                break;
            }
            case GEQ: {
                result = this.visitGreaterThanOrEqual(context, (BinaryEval)evalNode, stack);
                break;
            }
            case IS_NULL: {
                result = this.visitIsNull(context, (IsNullEval)evalNode, stack);
                break;
            }
            case BETWEEN: {
                result = this.visitBetween(context, (BetweenPredicateEval)evalNode, stack);
                break;
            }
            case CASE: {
                result = this.visitCaseWhen(context, (CaseWhenEval)evalNode, stack);
                break;
            }
            case IF_THEN: {
                result = this.visitIfThen(context, (CaseWhenEval.IfThenEval)evalNode, stack);
                break;
            }
            case IN: {
                result = this.visitInPredicate(context, (InEval)evalNode, stack);
                break;
            }
            case LIKE: {
                result = this.visitLike(context, (LikePredicateEval)evalNode, stack);
                break;
            }
            case SIMILAR_TO: {
                result = this.visitSimilarTo(context, (SimilarToPredicateEval)evalNode, stack);
                break;
            }
            case REGEX: {
                result = this.visitRegex(context, (RegexPredicateEval)evalNode, stack);
                break;
            }
            case CONCATENATE: {
                result = this.visitConcatenate(context, (BinaryEval)evalNode, stack);
                break;
            }
            case FUNCTION: {
                result = this.visitFuncCall(context, (GeneralFunctionEval)evalNode, stack);
                break;
            }
            case AGG_FUNCTION: {
                result = this.visitAggrFuncCall(context, (AggregationFunctionCallEval)evalNode, stack);
                break;
            }
            case WINDOW_FUNCTION: {
                result = this.visitWindowFunc(context, (WindowFunctionEval)evalNode, stack);
                break;
            }
            case SIGNED: {
                result = this.visitSigned(context, (SignedEval)evalNode, stack);
                break;
            }
            case CAST: {
                result = this.visitCast(context, (CastEval)evalNode, stack);
                break;
            }
            default: {
                throw new UnsupportedException("Unknown EvalType: " + evalNode);
            }
        }
        return result;
    }

    private RESULT visitDefaultUnaryEval(CONTEXT context, UnaryEval unaryEval, Stack<EvalNode> stack) {
        stack.push(unaryEval);
        RESULT result = this.visitChild(context, unaryEval.getChild(), stack);
        stack.pop();
        return result;
    }

    private RESULT visitDefaultBinaryEval(CONTEXT context, BinaryEval binaryEval, Stack<EvalNode> stack) {
        stack.push(binaryEval);
        RESULT result = this.visitChild(context, (EvalNode)binaryEval.getLeftExpr(), stack);
        this.visitChild(context, (EvalNode)binaryEval.getRightExpr(), stack);
        stack.pop();
        return result;
    }

    private RESULT visitDefaultFunctionEval(CONTEXT context, FunctionEval functionEval, Stack<EvalNode> stack) {
        RESULT result = null;
        stack.push(functionEval);
        if (functionEval.getArgs() != null) {
            for (EvalNode arg : functionEval.getArgs()) {
                result = this.visitChild(context, arg, stack);
            }
        }
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitConst(CONTEXT context, ConstEval evalNode, Stack<EvalNode> stack) {
        return null;
    }

    @Override
    public RESULT visitRowConstant(CONTEXT context, RowConstantEval evalNode, Stack<EvalNode> stack) {
        return null;
    }

    @Override
    public RESULT visitField(CONTEXT context, Stack<EvalNode> stack, FieldEval evalNode) {
        return null;
    }

    @Override
    public RESULT visitPlus(CONTEXT context, BinaryEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultBinaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitMinus(CONTEXT context, BinaryEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultBinaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitMultiply(CONTEXT context, BinaryEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultBinaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitDivide(CONTEXT context, BinaryEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultBinaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitModular(CONTEXT context, BinaryEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultBinaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitAnd(CONTEXT context, BinaryEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultBinaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitOr(CONTEXT context, BinaryEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultBinaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitNot(CONTEXT context, NotEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultUnaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitEqual(CONTEXT context, BinaryEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultBinaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitNotEqual(CONTEXT context, BinaryEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultBinaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitLessThan(CONTEXT context, BinaryEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultBinaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitLessThanOrEqual(CONTEXT context, BinaryEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultBinaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitGreaterThan(CONTEXT context, BinaryEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultBinaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitGreaterThanOrEqual(CONTEXT context, BinaryEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultBinaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitIsNull(CONTEXT context, IsNullEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultUnaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitBetween(CONTEXT context, BetweenPredicateEval evalNode, Stack<EvalNode> stack) {
        stack.push(evalNode);
        RESULT result = this.visitChild(context, evalNode.getPredicand(), stack);
        this.visitChild(context, evalNode.getBegin(), stack);
        this.visitChild(context, evalNode.getEnd(), stack);
        return result;
    }

    @Override
    public RESULT visitCaseWhen(CONTEXT context, CaseWhenEval evalNode, Stack<EvalNode> stack) {
        RESULT result = null;
        stack.push(evalNode);
        for (CaseWhenEval.IfThenEval ifThenEval : evalNode.getIfThenEvals()) {
            result = this.visitIfThen(context, ifThenEval, stack);
        }
        if (evalNode.hasElse()) {
            result = this.visitChild(context, evalNode.getElse(), stack);
        }
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitIfThen(CONTEXT context, CaseWhenEval.IfThenEval evalNode, Stack<EvalNode> stack) {
        stack.push(evalNode);
        RESULT result = this.visitChild(context, evalNode.getCondition(), stack);
        this.visitChild(context, evalNode.getResult(), stack);
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitInPredicate(CONTEXT context, InEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultBinaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitLike(CONTEXT context, LikePredicateEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultBinaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitSimilarTo(CONTEXT context, SimilarToPredicateEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultBinaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitRegex(CONTEXT context, RegexPredicateEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultBinaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitConcatenate(CONTEXT context, BinaryEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultBinaryEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitFuncCall(CONTEXT context, GeneralFunctionEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultFunctionEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitAggrFuncCall(CONTEXT context, AggregationFunctionCallEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultFunctionEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitWindowFunc(CONTEXT context, WindowFunctionEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultFunctionEval(context, evalNode, stack);
    }

    @Override
    public RESULT visitSigned(CONTEXT context, SignedEval signedEval, Stack<EvalNode> stack) {
        return this.visitDefaultUnaryEval(context, signedEval, stack);
    }

    @Override
    public RESULT visitCast(CONTEXT context, CastEval castEval, Stack<EvalNode> stack) {
        return this.visitDefaultUnaryEval(context, castEval, stack);
    }
}

