/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.plan.expr.ConstEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalNodeVisitor;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.storage.Tuple;

public class BetweenPredicateEval
extends EvalNode
implements Cloneable {
    private static final TajoDataTypes.DataType RES_TYPE = CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.BOOLEAN);
    @Expose
    private boolean not;
    @Expose
    private boolean symmetric;
    @Expose
    private EvalNode predicand;
    @Expose
    private EvalNode begin;
    @Expose
    private EvalNode end;
    private Checker checker;

    public BetweenPredicateEval(boolean not, boolean symmetric, EvalNode predicand, EvalNode begin, EvalNode end) {
        super(EvalType.BETWEEN);
        this.not = not;
        this.symmetric = symmetric;
        this.predicand = predicand;
        this.begin = begin;
        this.end = end;
    }

    public boolean isNot() {
        return this.not;
    }

    public boolean isSymmetric() {
        return this.symmetric;
    }

    public void setPredicand(EvalNode predicand) {
        this.predicand = predicand;
    }

    public EvalNode getPredicand() {
        return this.predicand;
    }

    public void setBegin(EvalNode begin) {
        this.begin = begin;
    }

    public EvalNode getBegin() {
        return this.begin;
    }

    public void setEnd(EvalNode end) {
        this.end = end;
    }

    public EvalNode getEnd() {
        return this.end;
    }

    @Override
    public TajoDataTypes.DataType getValueType() {
        return RES_TYPE;
    }

    @Override
    public int childNum() {
        return 3;
    }

    @Override
    public EvalNode getChild(int idx) {
        if (idx == 0) {
            return this.predicand;
        }
        if (idx == 1) {
            return this.begin;
        }
        if (idx == 2) {
            return this.end;
        }
        throw new ArrayIndexOutOfBoundsException(idx);
    }

    @Override
    public String getName() {
        return "between";
    }

    public String toString() {
        return this.predicand + " BETWEEN " + (this.symmetric ? "SYMMETRIC" : "ASYMMETRIC") + " " + this.begin + " AND " + this.end;
    }

    public Datum eval(Schema schema, Tuple tuple) {
        if (this.checker == null) {
            if (this.begin.getType() == EvalType.CONST && this.end.getType() == EvalType.CONST) {
                Datum beginValue = ((ConstEval)this.begin).getValue();
                Datum endValue = ((ConstEval)this.end).getValue();
                this.checker = this.symmetric || beginValue.compareTo(endValue) <= 0 ? new ConstantChecker(this.not, this.predicand, beginValue, endValue) : new AsymmetricChecker(this.not, this.predicand, this.begin, this.end);
            } else {
                this.checker = this.symmetric ? new SymmetricChecker(this.not, this.predicand, this.begin, this.end) : new AsymmetricChecker(this.not, this.predicand, this.begin, this.end);
            }
        }
        return this.checker.eval(schema, tuple);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BetweenPredicateEval) {
            BetweenPredicateEval another = (BetweenPredicateEval)obj;
            return this.not == another.not && this.symmetric == another.symmetric && this.predicand.equals(another.predicand) && this.begin.equals(another.begin) && this.end.equals(another.end);
        }
        return false;
    }

    @Override
    @Deprecated
    public void preOrder(EvalNodeVisitor visitor) {
        visitor.visit(this);
        this.predicand.preOrder(visitor);
        this.begin.preOrder(visitor);
        this.end.preOrder(visitor);
    }

    @Override
    @Deprecated
    public void postOrder(EvalNodeVisitor visitor) {
        this.predicand.postOrder(visitor);
        this.begin.postOrder(visitor);
        this.end.postOrder(visitor);
        visitor.visit(this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BetweenPredicateEval newBetween = (BetweenPredicateEval)super.clone();
        newBetween.not = this.not;
        newBetween.symmetric = this.symmetric;
        newBetween.predicand = this.predicand;
        newBetween.begin = this.begin;
        newBetween.end = this.end;
        return newBetween;
    }

    private static class SymmetricChecker
    implements Checker {
        boolean not;
        EvalNode predicand;
        EvalNode begin;
        EvalNode end;

        SymmetricChecker(boolean not, EvalNode predicand, EvalNode begin, EvalNode end) {
            this.not = not;
            this.predicand = predicand;
            this.begin = begin;
            this.end = end;
        }

        @Override
        public Datum eval(Schema schema, Tuple param) {
            Object predicandValue = this.predicand.eval(schema, param);
            Object beginValue = this.begin.eval(schema, param);
            Object endValue = this.end.eval(schema, param);
            if (!(predicandValue.isNull() || beginValue.isNull() || endValue.isNull())) {
                return DatumFactory.createBool((this.not ^ (predicandValue.greaterThanEqual(beginValue).asBool() && predicandValue.lessThanEqual(endValue).asBool()) || predicandValue.lessThanEqual(beginValue).asBool() && predicandValue.greaterThanEqual(endValue).asBool() ? 1 : 0) != 0);
            }
            return NullDatum.get();
        }
    }

    private static class AsymmetricChecker
    implements Checker {
        EvalNode predicand;
        EvalNode begin;
        EvalNode end;
        private boolean not;

        private AsymmetricChecker(boolean not, EvalNode predicand, EvalNode begin, EvalNode end) {
            this.not = not;
            this.predicand = predicand;
            this.begin = begin;
            this.end = end;
        }

        @Override
        public Datum eval(Schema schema, Tuple param) {
            Object predicandValue = this.predicand.eval(schema, param);
            Object beginValue = this.begin.eval(schema, param);
            Object endValue = this.end.eval(schema, param);
            if (!(predicandValue.isNull() || beginValue.isNull() || endValue.isNull())) {
                return DatumFactory.createBool((boolean)(this.not ^ (predicandValue.greaterThanEqual(beginValue).asBool() && predicandValue.lessThanEqual(endValue).asBool())));
            }
            return NullDatum.get();
        }
    }

    private static class ConstantChecker
    implements Checker {
        EvalNode predicand;
        Datum begin;
        Datum end;
        private boolean not;

        private ConstantChecker(boolean not, EvalNode predicand, Datum begin, Datum end) {
            this.predicand = predicand;
            this.not = not;
            if (begin.compareTo(end) > 0) {
                this.begin = end;
                this.end = begin;
            } else {
                this.begin = begin;
                this.end = end;
            }
        }

        @Override
        public Datum eval(Schema schema, Tuple param) {
            Object predicandValue = this.predicand.eval(schema, param);
            if (!predicandValue.isNull()) {
                return DatumFactory.createBool((boolean)(this.not ^ (predicandValue.greaterThanEqual(this.begin).asBool() && predicandValue.lessThanEqual(this.end).asBool())));
            }
            return NullDatum.get();
        }
    }

    private static interface Checker {
        public Datum eval(Schema var1, Tuple var2);
    }
}

