/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalNodeVisitor;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.storage.Tuple;

public class ConstEval
extends EvalNode
implements Comparable<ConstEval>,
Cloneable {
    @Expose
    Datum datum = null;

    public ConstEval(Datum datum) {
        super(EvalType.CONST);
        this.datum = datum;
    }

    public Datum getValue() {
        return this.datum;
    }

    public String toString() {
        return this.datum.toString();
    }

    public Datum eval(Schema schema, Tuple tuple) {
        return this.datum;
    }

    @Override
    public TajoDataTypes.DataType getValueType() {
        return CatalogUtil.newSimpleDataType((TajoDataTypes.Type)this.datum.type());
    }

    @Override
    public int childNum() {
        return 0;
    }

    @Override
    public EvalNode getChild(int idx) {
        return null;
    }

    @Override
    public String getName() {
        return this.datum.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConstEval) {
            ConstEval other = (ConstEval)obj;
            if (this.type == other.type && this.datum.equals(other.datum)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.datum.type(), this.datum});
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ConstEval eval = (ConstEval)super.clone();
        eval.datum = this.datum;
        return eval;
    }

    @Override
    public int compareTo(ConstEval other) {
        return this.datum.compareTo(other.datum);
    }

    @Override
    public void preOrder(EvalNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void postOrder(EvalNodeVisitor visitor) {
        visitor.visit(this);
    }
}

