/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import org.apache.tajo.plan.expr.AggregationFunctionCallEval;
import org.apache.tajo.plan.expr.BetweenPredicateEval;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.CaseWhenEval;
import org.apache.tajo.plan.expr.CastEval;
import org.apache.tajo.plan.expr.ConstEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.FieldEval;
import org.apache.tajo.plan.expr.GeneralFunctionEval;
import org.apache.tajo.plan.expr.InEval;
import org.apache.tajo.plan.expr.IsNullEval;
import org.apache.tajo.plan.expr.LikePredicateEval;
import org.apache.tajo.plan.expr.NotEval;
import org.apache.tajo.plan.expr.RegexPredicateEval;
import org.apache.tajo.plan.expr.RowConstantEval;
import org.apache.tajo.plan.expr.SignedEval;
import org.apache.tajo.plan.expr.SimilarToPredicateEval;
import org.apache.tajo.plan.expr.WindowFunctionEval;

public enum EvalType {
    NOT(NotEval.class, "!"),
    AND(BinaryEval.class),
    OR(BinaryEval.class),
    EQUAL(BinaryEval.class, "="),
    IS_NULL(IsNullEval.class),
    NOT_EQUAL(BinaryEval.class, "<>"),
    LTH(BinaryEval.class, "<"),
    LEQ(BinaryEval.class, "<="),
    GTH(BinaryEval.class, ">"),
    GEQ(BinaryEval.class, ">="),
    PLUS(BinaryEval.class, "+"),
    MINUS(BinaryEval.class, "-"),
    MODULAR(BinaryEval.class, "%"),
    MULTIPLY(BinaryEval.class, "*"),
    DIVIDE(BinaryEval.class, "/"),
    BIT_AND(BinaryEval.class, "&"),
    BIT_OR(BinaryEval.class, "|"),
    BIT_XOR(BinaryEval.class, "|"),
    WINDOW_FUNCTION(WindowFunctionEval.class),
    AGG_FUNCTION(AggregationFunctionCallEval.class),
    FUNCTION(GeneralFunctionEval.class),
    LIKE(LikePredicateEval.class),
    SIMILAR_TO(SimilarToPredicateEval.class),
    REGEX(RegexPredicateEval.class),
    CONCATENATE(BinaryEval.class, "||"),
    BETWEEN(BetweenPredicateEval.class),
    CASE(CaseWhenEval.class),
    IF_THEN(CaseWhenEval.IfThenEval.class),
    IN(InEval.class),
    SIGNED(SignedEval.class),
    CAST(CastEval.class),
    ROW_CONSTANT(RowConstantEval.class),
    FIELD(FieldEval.class),
    CONST(ConstEval.class);

    private Class<? extends EvalNode> baseClass;
    private String operatorName;

    private EvalType(Class<? extends EvalNode> type) {
        this.baseClass = type;
    }

    private EvalType(Class<? extends EvalNode> type, String text) {
        this(type);
        this.operatorName = text;
    }

    public static boolean isUnaryOperator(EvalType type) {
        boolean match = false;
        match |= type == CAST;
        match |= type == IS_NULL;
        match |= type == NOT;
        return match |= type == SIGNED;
    }

    public static boolean isBinaryOperator(EvalType type) {
        boolean match = false;
        match |= EvalType.isArithmeticOperator(type);
        match |= EvalType.isLogicalOperator(type) && type != NOT;
        match |= EvalType.isComparisonOperator(type) && type != BETWEEN;
        match |= type == CONCATENATE;
        match |= type == IN;
        match |= type == LIKE;
        match |= type == REGEX;
        return match |= type == SIMILAR_TO;
    }

    public static boolean isLogicalOperator(EvalType type) {
        boolean match = false;
        match |= type == AND;
        match |= type == OR;
        return match |= type == NOT;
    }

    public static boolean isComparisonOperator(EvalType type) {
        boolean match = false;
        match |= type == EQUAL;
        match |= type == NOT_EQUAL;
        match |= type == LTH;
        match |= type == LEQ;
        match |= type == GTH;
        match |= type == GEQ;
        return match |= type == BETWEEN;
    }

    public static boolean isArithmeticOperator(EvalType type) {
        boolean match = false;
        match |= type == PLUS;
        match |= type == MINUS;
        match |= type == MULTIPLY;
        match |= type == DIVIDE;
        return match |= type == MODULAR;
    }

    public static boolean isFunction(EvalType type) {
        boolean match = false;
        match |= type == FUNCTION;
        match |= type == AGG_FUNCTION;
        return match |= type == WINDOW_FUNCTION;
    }

    public static boolean isStringPatternMatchOperator(EvalType type) {
        boolean match = false;
        match |= type == LIKE;
        match |= type == SIMILAR_TO;
        return match |= type == REGEX;
    }

    public String getOperatorName() {
        return this.operatorName != null ? this.operatorName : this.name();
    }

    public Class<? extends EvalNode> getBaseClass() {
        return this.baseClass;
    }
}

