/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalNodeVisitor;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.storage.Tuple;

public class FieldEval
extends EvalNode
implements Cloneable {
    @Expose
    private Column column;
    @Expose
    private int fieldId = -1;

    public FieldEval(String columnName, TajoDataTypes.DataType domain) {
        super(EvalType.FIELD);
        this.column = new Column(columnName, domain);
    }

    public FieldEval(Column column) {
        super(EvalType.FIELD);
        this.column = column;
    }

    public Datum eval(Schema schema, Tuple tuple) {
        if (this.fieldId == -1) {
            this.fieldId = this.column.hasQualifier() ? schema.getColumnId(this.column.getQualifiedName()) : schema.getColumnIdByName(this.column.getSimpleName());
            if (this.fieldId == -1) {
                throw new IllegalStateException("No Such Column Reference: " + this.column + ", schema: " + schema);
            }
        }
        return tuple.get(this.fieldId);
    }

    @Override
    public TajoDataTypes.DataType getValueType() {
        return this.column.getDataType();
    }

    @Override
    public int childNum() {
        return 0;
    }

    @Override
    public EvalNode getChild(int idx) {
        return null;
    }

    public Column getColumnRef() {
        return this.column;
    }

    public String getQualifier() {
        return this.column.getQualifier();
    }

    public String getColumnName() {
        return this.column.getSimpleName();
    }

    public void replaceColumnRef(String columnName) {
        this.column = new Column(columnName, this.column.getDataType());
    }

    @Override
    public String getName() {
        return this.column.getQualifiedName();
    }

    public String toString() {
        return this.column.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldEval) {
            FieldEval other = (FieldEval)obj;
            return this.column.equals((Object)other.column);
        }
        return false;
    }

    public int hashCode() {
        return this.column.hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FieldEval eval = (FieldEval)super.clone();
        eval.column = this.column;
        eval.fieldId = this.fieldId;
        return eval;
    }

    @Override
    public void preOrder(EvalNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void postOrder(EvalNodeVisitor visitor) {
        visitor.visit(this);
    }
}

