/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tajo.plan.expr.ConstEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.PatternMatchPredicateEval;
import org.apache.tajo.util.StringUtils;

public class LikePredicateEval
extends PatternMatchPredicateEval {
    public LikePredicateEval(boolean not, EvalNode field, ConstEval pattern) {
        super(EvalType.LIKE, not, field, pattern, false);
    }

    public LikePredicateEval(boolean not, EvalNode field, ConstEval pattern, boolean caseSensitive) {
        super(EvalType.LIKE, not, field, pattern, caseSensitive);
    }

    @Override
    protected void compile(String pattern) throws PatternSyntaxException {
        String escaped = StringUtils.escapeRegexp((String)pattern);
        String regex = escaped.replace("_", ".").replace("%", ".*");
        int flags = 32;
        if (this.caseInsensitive) {
            flags |= 2;
        }
        this.compiled = Pattern.compile(regex, flags);
    }

    public boolean isLeadingWildCard() {
        return this.pattern.indexOf(".*") == 0;
    }

    @Override
    public String toString() {
        return this.leftExpr.toString() + (this.caseInsensitive ? "ILIKE" : "LIKE") + "'" + this.pattern + "'";
    }
}

