/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.exception.InvalidOperationException;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.storage.Tuple;

public class PartialBinaryExpr
extends BinaryEval {
    public PartialBinaryExpr(EvalType type) {
        super(type);
    }

    public PartialBinaryExpr(EvalType type, EvalNode left, EvalNode right) {
        super(type);
        this.leftExpr = left;
        this.rightExpr = right;
    }

    @Override
    public TajoDataTypes.DataType getValueType() {
        return null;
    }

    @Override
    public String getName() {
        return "nonamed";
    }

    @Override
    public Datum eval(Schema schema, Tuple tuple) {
        throw new InvalidOperationException("ERROR: the partial binary expression cannot be evluated: " + this.toString());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PartialBinaryExpr) {
            PartialBinaryExpr other = (PartialBinaryExpr)obj;
            return this.type.equals((Object)other.type) && this.leftExpr.equals(other.leftExpr) && this.rightExpr.equals(other.rightExpr);
        }
        return false;
    }

    @Override
    public String toString() {
        return (this.leftExpr != null ? this.leftExpr.toString() : "[EMPTY]") + " " + (Object)((Object)this.type) + " " + (this.rightExpr != null ? this.rightExpr.toString() : "[EMPTY]");
    }
}

