/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.gson.annotations.Expose;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tajo.plan.expr.ConstEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.PatternMatchPredicateEval;

public class RegexPredicateEval
extends PatternMatchPredicateEval {
    @Expose
    private String operator;

    public RegexPredicateEval(boolean not, EvalNode field, ConstEval pattern, boolean caseInsensitive) {
        super(EvalType.REGEX, not, field, pattern, caseInsensitive);
        StringBuilder sb = new StringBuilder();
        if (not) {
            sb.append("!");
        }
        sb.append("~");
        if (caseInsensitive) {
            sb.append("*");
        }
        this.operator = sb.toString();
    }

    @Override
    protected void compile(String regex) throws PatternSyntaxException {
        int flags = 32;
        if (this.caseInsensitive) {
            flags |= 2;
        }
        this.compiled = Pattern.compile(regex, flags);
    }

    @Override
    public String toString() {
        return this.leftExpr.toString() + this.operator + "'" + this.pattern + "'";
    }
}

