/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tajo.plan.expr.ConstEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.PatternMatchPredicateEval;

public class SimilarToPredicateEval
extends PatternMatchPredicateEval {
    private static final String SIMILARTO_ESCAPE_SPATIAL_CHARACTERS = "([.])";

    public SimilarToPredicateEval(boolean not, EvalNode field, ConstEval pattern, boolean isCaseSensitive) {
        super(EvalType.SIMILAR_TO, not, field, pattern, false);
    }

    public SimilarToPredicateEval(boolean not, EvalNode field, ConstEval pattern) {
        super(EvalType.SIMILAR_TO, not, field, pattern);
    }

    @Override
    protected void compile(String pattern) throws PatternSyntaxException {
        String regex = pattern.replaceAll(SIMILARTO_ESCAPE_SPATIAL_CHARACTERS, "\\\\$1");
        regex = regex.replace("_", ".").replace("%", ".*");
        this.compiled = Pattern.compile(regex, 32);
    }

    @Override
    public String toString() {
        return this.leftExpr.toString() + " SIMILAR TO '" + this.pattern + "'";
    }
}

