/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.common.base.Preconditions;
import java.util.Stack;
import org.apache.tajo.exception.UnsupportedException;
import org.apache.tajo.plan.expr.BetweenPredicateEval;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.CaseWhenEval;
import org.apache.tajo.plan.expr.ConstEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.FieldEval;
import org.apache.tajo.plan.expr.FunctionEval;
import org.apache.tajo.plan.expr.InEval;
import org.apache.tajo.plan.expr.RowConstantEval;
import org.apache.tajo.plan.expr.UnaryEval;

public abstract class SimpleEvalNodeVisitor<CONTEXT> {
    public EvalNode visit(CONTEXT context, EvalNode evalNode, Stack<EvalNode> stack) {
        EvalNode result;
        Preconditions.checkNotNull((Object)evalNode);
        if (evalNode instanceof UnaryEval) {
            result = this.visitUnaryEval(context, stack, (UnaryEval)evalNode);
        } else if (evalNode instanceof BinaryEval) {
            result = this.visitBinaryEval(context, stack, (BinaryEval)evalNode);
        } else {
            switch (evalNode.getType()) {
                case CONST: {
                    result = this.visitConst(context, (ConstEval)evalNode, stack);
                    break;
                }
                case ROW_CONSTANT: {
                    result = this.visitRowConstant(context, (RowConstantEval)evalNode, stack);
                    break;
                }
                case FIELD: {
                    result = this.visitField(context, stack, (FieldEval)evalNode);
                    break;
                }
                case BETWEEN: {
                    result = this.visitBetween(context, (BetweenPredicateEval)evalNode, stack);
                    break;
                }
                case CASE: {
                    result = this.visitCaseWhen(context, (CaseWhenEval)evalNode, stack);
                    break;
                }
                case IF_THEN: {
                    result = this.visitIfThen(context, (CaseWhenEval.IfThenEval)evalNode, stack);
                    break;
                }
                case FUNCTION: {
                    result = this.visitFuncCall(context, (FunctionEval)evalNode, stack);
                    break;
                }
                case AGG_FUNCTION: {
                    result = this.visitFuncCall(context, (FunctionEval)evalNode, stack);
                    break;
                }
                case WINDOW_FUNCTION: {
                    result = this.visitFuncCall(context, (FunctionEval)evalNode, stack);
                    break;
                }
                default: {
                    throw new UnsupportedException("Unknown EvalType: " + evalNode);
                }
            }
        }
        return result;
    }

    protected EvalNode visitUnaryEval(CONTEXT context, Stack<EvalNode> stack, UnaryEval unaryEval) {
        stack.push(unaryEval);
        this.visit(context, unaryEval.getChild(), stack);
        stack.pop();
        return unaryEval;
    }

    protected EvalNode visitBinaryEval(CONTEXT context, Stack<EvalNode> stack, BinaryEval binaryEval) {
        stack.push(binaryEval);
        this.visit(context, (EvalNode)binaryEval.getLeftExpr(), stack);
        this.visit(context, (EvalNode)binaryEval.getRightExpr(), stack);
        stack.pop();
        return binaryEval;
    }

    protected EvalNode visitDefaultFunctionEval(CONTEXT context, Stack<EvalNode> stack, FunctionEval functionEval) {
        stack.push(functionEval);
        if (functionEval.getArgs() != null) {
            for (EvalNode arg : functionEval.getArgs()) {
                this.visit(context, arg, stack);
            }
        }
        stack.pop();
        return functionEval;
    }

    protected EvalNode visitConst(CONTEXT context, ConstEval evalNode, Stack<EvalNode> stack) {
        return evalNode;
    }

    protected EvalNode visitRowConstant(CONTEXT context, RowConstantEval evalNode, Stack<EvalNode> stack) {
        return evalNode;
    }

    protected EvalNode visitField(CONTEXT context, Stack<EvalNode> stack, FieldEval evalNode) {
        return evalNode;
    }

    protected EvalNode visitBetween(CONTEXT context, BetweenPredicateEval evalNode, Stack<EvalNode> stack) {
        stack.push(evalNode);
        this.visit(context, evalNode.getPredicand(), stack);
        this.visit(context, evalNode.getBegin(), stack);
        this.visit(context, evalNode.getEnd(), stack);
        return evalNode;
    }

    protected EvalNode visitCaseWhen(CONTEXT context, CaseWhenEval evalNode, Stack<EvalNode> stack) {
        stack.push(evalNode);
        for (CaseWhenEval.IfThenEval ifThenEval : evalNode.getIfThenEvals()) {
            this.visitIfThen(context, ifThenEval, stack);
        }
        if (evalNode.hasElse()) {
            this.visit(context, evalNode.getElse(), stack);
        }
        stack.pop();
        return evalNode;
    }

    protected EvalNode visitIfThen(CONTEXT context, CaseWhenEval.IfThenEval evalNode, Stack<EvalNode> stack) {
        stack.push(evalNode);
        this.visit(context, evalNode.getCondition(), stack);
        this.visit(context, evalNode.getResult(), stack);
        stack.pop();
        return evalNode;
    }

    protected EvalNode visitInPredicate(CONTEXT context, InEval evalNode, Stack<EvalNode> stack) {
        return this.visitBinaryEval(context, stack, evalNode);
    }

    protected EvalNode visitFuncCall(CONTEXT context, FunctionEval evalNode, Stack<EvalNode> stack) {
        return this.visitDefaultFunctionEval(context, stack, evalNode);
    }
}

