/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalNodeVisitor;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.storage.Tuple;

public abstract class UnaryEval
extends EvalNode
implements Cloneable {
    @Expose
    protected EvalNode child;

    public UnaryEval(EvalType type) {
        super(type);
    }

    public UnaryEval(EvalType type, EvalNode child) {
        super(type);
        this.child = child;
    }

    @Override
    public int childNum() {
        return 1;
    }

    @Override
    public EvalNode getChild(int idx) {
        Preconditions.checkArgument((idx == 0 ? 1 : 0) != 0, (Object)"UnaryEval always has one child.");
        return this.child;
    }

    public void setChild(EvalNode child) {
        this.child = child;
    }

    public EvalNode getChild() {
        return this.child;
    }

    @Override
    public TajoDataTypes.DataType getValueType() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public <T extends Datum> T eval(Schema schema, Tuple tuple) {
        return null;
    }

    @Override
    public void preOrder(EvalNodeVisitor visitor) {
        visitor.visit(this);
        this.child.preOrder(visitor);
    }

    @Override
    public void postOrder(EvalNodeVisitor visitor) {
        this.child.postOrder(visitor);
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnaryEval) {
            UnaryEval another = (UnaryEval)obj;
            return this.type == another.type && this.child.equals(another.child);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.child});
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        UnaryEval unaryEval = (UnaryEval)super.clone();
        unaryEval.child = (EvalNode)this.child.clone();
        return unaryEval;
    }
}

