/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.joinorder;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.apache.tajo.algebra.JoinType;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.util.TUtil;

public class JoinEdge {
    private final JoinType joinType;
    private final LogicalNode leftRelation;
    private final LogicalNode rightRelation;
    private final Set<EvalNode> joinQual = Sets.newHashSet();

    public JoinEdge(JoinType joinType, LogicalNode leftRelation, LogicalNode rightRelation) {
        this.joinType = joinType;
        this.leftRelation = leftRelation;
        this.rightRelation = rightRelation;
    }

    public JoinEdge(JoinType joinType, LogicalNode leftRelation, LogicalNode rightRelation, EvalNode ... condition) {
        this(joinType, leftRelation, rightRelation);
        Collections.addAll(this.joinQual, condition);
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public LogicalNode getLeftRelation() {
        return this.leftRelation;
    }

    public LogicalNode getRightRelation() {
        return this.rightRelation;
    }

    public boolean hasJoinQual() {
        return this.joinQual.size() > 0;
    }

    public void addJoinQual(EvalNode joinQual) {
        this.joinQual.add(joinQual);
    }

    public EvalNode[] getJoinQual() {
        return this.joinQual.toArray(new EvalNode[this.joinQual.size()]);
    }

    public String toString() {
        return this.leftRelation + " " + this.joinType + " " + this.rightRelation + " ON " + TUtil.collectionToString(this.joinQual, (String)", ");
    }
}

