/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.joinorder;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import org.apache.tajo.algebra.JoinType;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.NamedExprsManager;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.expr.AlgebraicUtil;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalTreeUtil;
import org.apache.tajo.plan.joinorder.JoinEdge;
import org.apache.tajo.plan.logical.JoinNode;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.RelationNode;
import org.apache.tajo.plan.util.PlannerUtil;
import org.apache.tajo.util.TUtil;
import org.apache.tajo.util.graph.SimpleUndirectedGraph;

public class JoinGraph
extends SimpleUndirectedGraph<String, JoinEdge> {
    private String[] guessRelationsFromJoinQual(LogicalPlan.QueryBlock block, BinaryEval joinCondition) throws PlanningException {
        String qualifier;
        String qualifier2;
        String columnName;
        Column leftExpr = EvalTreeUtil.findAllColumnRefs(joinCondition.getLeftExpr()).get(0);
        Column rightExpr = EvalTreeUtil.findAllColumnRefs(joinCondition.getRightExpr()).get(0);
        String[] relationNames = new String[2];
        NamedExprsManager namedExprsMgr = block.getNamedExprsManager();
        if (leftExpr.hasQualifier()) {
            relationNames[0] = leftExpr.getQualifier();
        } else if (namedExprsMgr.isAliasedName(leftExpr.getSimpleName())) {
            columnName = namedExprsMgr.getOriginalName(leftExpr.getSimpleName());
            relationNames[0] = qualifier2 = CatalogUtil.extractQualifier((String)columnName);
        } else {
            for (RelationNode rel : block.getRelations()) {
                if (!rel.getOutSchema().contains(leftExpr)) continue;
                relationNames[0] = qualifier = rel.getCanonicalName();
            }
            if (relationNames[0] == null) {
                throw new PlanningException("Cannot expect a referenced relation: " + leftExpr);
            }
        }
        if (rightExpr.hasQualifier()) {
            relationNames[1] = rightExpr.getQualifier();
        } else if (namedExprsMgr.isAliasedName(rightExpr.getSimpleName())) {
            columnName = namedExprsMgr.getOriginalName(rightExpr.getSimpleName());
            relationNames[1] = qualifier2 = CatalogUtil.extractQualifier((String)columnName);
        } else {
            for (RelationNode rel : block.getRelations()) {
                if (!rel.getOutSchema().contains(rightExpr)) continue;
                relationNames[1] = qualifier = rel.getCanonicalName();
            }
            if (relationNames[1] == null) {
                throw new PlanningException("Cannot expect a referenced relation: " + rightExpr);
            }
        }
        return relationNames;
    }

    public Collection<EvalNode> addJoin(LogicalPlan plan, LogicalPlan.QueryBlock block, JoinNode joinNode) throws PlanningException {
        if (joinNode.getJoinType() == JoinType.LEFT_OUTER || joinNode.getJoinType() == JoinType.RIGHT_OUTER) {
            JoinEdge edge = new JoinEdge(joinNode.getJoinType(), (LogicalNode)joinNode.getLeftChild(), (LogicalNode)joinNode.getRightChild(), joinNode.getJoinQual());
            TreeSet<String> leftNodeRelationName = new TreeSet<String>(PlannerUtil.getRelationLineageWithinQueryBlock(plan, joinNode.getLeftChild()));
            TreeSet<String> rightNodeRelationName = new TreeSet<String>(PlannerUtil.getRelationLineageWithinQueryBlock(plan, joinNode.getRightChild()));
            this.addEdge(TUtil.collectionToString(leftNodeRelationName, (String)", "), TUtil.collectionToString(rightNodeRelationName, (String)", "), edge);
            HashSet<EvalNode> allInOneCnf = new HashSet<EvalNode>();
            allInOneCnf.add(joinNode.getJoinQual());
            return allInOneCnf;
        }
        HashSet cnf = Sets.newHashSet((Object[])AlgebraicUtil.toConjunctiveNormalFormArray(joinNode.getJoinQual()));
        for (EvalNode singleQual : cnf) {
            if (!EvalTreeUtil.isJoinQual(block, ((LogicalNode)joinNode.getLeftChild()).getOutSchema(), ((LogicalNode)joinNode.getRightChild()).getOutSchema(), singleQual, true)) continue;
            String[] relations = this.guessRelationsFromJoinQual(block, (BinaryEval)singleQual);
            String leftExprRelName = relations[0];
            String rightExprRelName = relations[1];
            Collection<String> leftLineage = PlannerUtil.getRelationLineageWithinQueryBlock(plan, joinNode.getLeftChild());
            boolean isLeftExprForLeftTable = leftLineage.contains(leftExprRelName);
            JoinEdge edge = (JoinEdge)this.getEdge(leftExprRelName, rightExprRelName);
            if (edge != null) {
                edge.addJoinQual(singleQual);
                continue;
            }
            if (isLeftExprForLeftTable) {
                edge = new JoinEdge(joinNode.getJoinType(), block.getRelation(leftExprRelName), block.getRelation(rightExprRelName), singleQual);
                this.addEdge(leftExprRelName, rightExprRelName, edge);
                continue;
            }
            edge = new JoinEdge(joinNode.getJoinType(), block.getRelation(rightExprRelName), block.getRelation(leftExprRelName), singleQual);
            this.addEdge(rightExprRelName, leftExprRelName, edge);
        }
        return cnf;
    }
}

