/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.gson.annotations.Expose;
import org.apache.tajo.json.GsonObject;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.LogicalNodeVisitor;
import org.apache.tajo.plan.logical.NodeType;

public abstract class BinaryNode
extends LogicalNode
implements Cloneable,
GsonObject {
    @Expose
    LogicalNode leftChild = null;
    @Expose
    LogicalNode rightChild = null;

    public BinaryNode(int pid, NodeType nodeType) {
        super(pid, nodeType);
    }

    @Override
    public int childNum() {
        return 2;
    }

    @Override
    public LogicalNode getChild(int idx) {
        if (idx == 0) {
            return this.leftChild;
        }
        if (idx == 1) {
            return this.rightChild;
        }
        throw new ArrayIndexOutOfBoundsException(idx);
    }

    public <T extends LogicalNode> T getLeftChild() {
        return (T)this.leftChild;
    }

    public void setLeftChild(LogicalNode op) {
        this.leftChild = op;
    }

    public <T extends LogicalNode> T getRightChild() {
        return (T)this.rightChild;
    }

    public void setRightChild(LogicalNode op) {
        this.rightChild = op;
    }

    @Override
    public boolean deepEquals(Object o) {
        if (o instanceof BinaryNode) {
            BinaryNode b = (BinaryNode)o;
            return this.equals(o) && this.leftChild.deepEquals(b.leftChild) && this.rightChild.deepEquals(b.rightChild);
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BinaryNode binNode = (BinaryNode)super.clone();
        binNode.leftChild = (LogicalNode)this.leftChild.clone();
        binNode.rightChild = (LogicalNode)this.rightChild.clone();
        return binNode;
    }

    @Override
    public void preOrder(LogicalNodeVisitor visitor) {
        visitor.visit(this);
        this.leftChild.postOrder(visitor);
        this.rightChild.postOrder(visitor);
    }

    @Override
    public void postOrder(LogicalNodeVisitor visitor) {
        this.leftChild.postOrder(visitor);
        this.rightChild.postOrder(visitor);
        visitor.visit(this);
    }
}

