/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.common.base.Objects;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.LogicalNodeVisitor;
import org.apache.tajo.plan.logical.NodeType;

public class CreateDatabaseNode
extends LogicalNode
implements Cloneable {
    private String databaseName;
    private boolean ifNotExists;

    public CreateDatabaseNode(int pid) {
        super(pid, NodeType.CREATE_DATABASE);
    }

    @Override
    public int childNum() {
        return 0;
    }

    @Override
    public LogicalNode getChild(int idx) {
        return null;
    }

    public void init(String databaseName, boolean ifNotExists) {
        this.databaseName = databaseName;
        this.ifNotExists = ifNotExists;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public PlanString getPlanString() {
        return new PlanString(this).appendTitle(this.ifNotExists ? " IF NOT EXISTS " : " ").appendTitle(this.databaseName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.databaseName, this.ifNotExists});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CreateDatabaseNode) {
            CreateDatabaseNode other = (CreateDatabaseNode)obj;
            return super.equals(other) && this.databaseName.equals(other.databaseName) && this.ifNotExists == other.ifNotExists;
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CreateDatabaseNode newNode = (CreateDatabaseNode)super.clone();
        newNode.databaseName = this.databaseName;
        newNode.ifNotExists = this.ifNotExists;
        return newNode;
    }

    @Override
    public String toString() {
        return "CREATE DATABASE " + (this.ifNotExists ? " IF NOT EXISTS " : "") + CatalogUtil.denormalizeIdentifier((String)this.databaseName);
    }

    @Override
    public void preOrder(LogicalNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void postOrder(LogicalNodeVisitor visitor) {
        visitor.visit(this);
    }
}

