/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.LogicalNodeVisitor;
import org.apache.tajo.plan.logical.NodeType;

public class DropDatabaseNode
extends LogicalNode
implements Cloneable {
    @Expose
    private String databaseName;
    @Expose
    private boolean ifExists = false;

    public DropDatabaseNode(int pid) {
        super(pid, NodeType.DROP_DATABASE);
    }

    @Override
    public int childNum() {
        return 0;
    }

    @Override
    public LogicalNode getChild(int idx) {
        return null;
    }

    public void init(String databaseName, boolean ifExists) {
        this.databaseName = databaseName;
        this.ifExists = ifExists;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    @Override
    public PlanString getPlanString() {
        return new PlanString(this).appendTitle(this.ifExists ? " IF EXISTS " : " ").appendTitle(this.databaseName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.databaseName, this.ifExists});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DropDatabaseNode) {
            DropDatabaseNode other = (DropDatabaseNode)obj;
            boolean eq = super.equals(other);
            eq &= this.databaseName.equals(other.databaseName);
            return eq &= this.ifExists == other.ifExists;
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DropDatabaseNode dropTableNode = (DropDatabaseNode)super.clone();
        dropTableNode.databaseName = this.databaseName;
        return dropTableNode;
    }

    @Override
    public String toString() {
        return "DROP DATABASE " + (this.ifExists ? "IF EXISTS " : "") + this.databaseName;
    }

    @Override
    public void preOrder(LogicalNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void postOrder(LogicalNodeVisitor visitor) {
        visitor.visit(this);
    }
}

