/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.gson.annotations.Expose;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.SelectableNode;
import org.apache.tajo.plan.logical.UnaryNode;

public class HavingNode
extends UnaryNode
implements SelectableNode,
Cloneable {
    @Expose
    private EvalNode qual;

    public HavingNode(int pid) {
        super(pid, NodeType.HAVING);
    }

    @Override
    public boolean hasQual() {
        return true;
    }

    @Override
    public void setQual(EvalNode qual) {
        this.qual = qual;
    }

    @Override
    public EvalNode getQual() {
        return this.qual;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof HavingNode) {
            HavingNode other = (HavingNode)obj;
            return super.equals(other) && this.qual.equals(other.qual);
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        HavingNode selNode = (HavingNode)super.clone();
        selNode.qual = (EvalNode)this.qual.clone();
        return selNode;
    }

    @Override
    public PlanString getPlanString() {
        return new PlanString(this).appendTitle(" (").appendTitle(this.qual.toString()).appendTitle(")");
    }

    @Override
    public String toString() {
        return "Having (filter=" + this.qual + ")";
    }
}

