/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.gson.Gson;
import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.SortSpec;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.ScanNode;
import org.apache.tajo.plan.serder.PlanGsonHelper;

public class IndexScanNode
extends ScanNode {
    @Expose
    private SortSpec[] sortKeys;
    @Expose
    private Schema keySchema = null;
    @Expose
    private Datum[] datum = null;

    public IndexScanNode(int pid, ScanNode scanNode, Schema keySchema, Datum[] datum, SortSpec[] sortKeys) {
        super(pid);
        this.init(scanNode.getTableDesc());
        this.setQual(scanNode.getQual());
        this.setInSchema(scanNode.getInSchema());
        this.setTargets(scanNode.getTargets());
        this.setType(NodeType.BST_INDEX_SCAN);
        this.sortKeys = sortKeys;
        this.keySchema = keySchema;
        this.datum = datum;
    }

    public SortSpec[] getSortKeys() {
        return this.sortKeys;
    }

    public Schema getKeySchema() {
        return this.keySchema;
    }

    public Datum[] getDatum() {
        return this.datum;
    }

    public void setSortKeys(SortSpec[] sortKeys) {
        this.sortKeys = sortKeys;
    }

    public void setKeySchema(Schema keySchema) {
        this.keySchema = keySchema;
    }

    @Override
    public String toString() {
        Gson gson = PlanGsonHelper.getInstance();
        StringBuilder builder = new StringBuilder();
        builder.append("IndexScanNode : {\n");
        builder.append("  \"keySchema\" : \"" + gson.toJson((Object)this.keySchema) + "\"\n");
        builder.append("  \"sortKeys\" : \"" + gson.toJson((Object)this.sortKeys) + " \"\n");
        builder.append("  \"datums\" : \"" + gson.toJson((Object)this.datum) + "\"\n");
        builder.append("      <<\"superClass\" : " + super.toString());
        builder.append(">>}");
        builder.append("}");
        return builder.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IndexScanNode) {
            int i;
            IndexScanNode other = (IndexScanNode)obj;
            boolean eq = super.equals(other);
            boolean bl = eq = eq && this.sortKeys.length == other.sortKeys.length;
            if (eq) {
                for (i = 0; i < this.sortKeys.length; ++i) {
                    eq = eq && this.sortKeys[i].getSortKey().equals((Object)other.sortKeys[i].getSortKey());
                    eq = eq && this.sortKeys[i].isAscending() == other.sortKeys[i].isAscending();
                    eq = eq && this.sortKeys[i].isNullFirst() == other.sortKeys[i].isNullFirst();
                }
            }
            if (eq) {
                for (i = 0; i < this.datum.length; ++i) {
                    eq = eq && this.datum[i].equals(other.datum[i]);
                }
            }
            return eq;
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int i;
        IndexScanNode indexNode = (IndexScanNode)super.clone();
        indexNode.keySchema = (Schema)this.keySchema.clone();
        indexNode.sortKeys = new SortSpec[this.sortKeys.length];
        for (i = 0; i < this.sortKeys.length; ++i) {
            indexNode.sortKeys[i] = (SortSpec)this.sortKeys[i].clone();
        }
        indexNode.datum = new Datum[this.datum.length];
        for (i = 0; i < this.datum.length; ++i) {
            indexNode.datum[i] = this.datum[i];
        }
        return indexNode;
    }
}

