/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.gson.annotations.Expose;
import org.apache.hadoop.fs.Path;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.TableDesc;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.LogicalNodeVisitor;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.StoreTableNode;
import org.apache.tajo.util.TUtil;

public class InsertNode
extends StoreTableNode
implements Cloneable {
    @Expose
    private boolean overwrite;
    @Expose
    private Schema tableSchema;
    @Expose
    private Schema targetSchema;
    @Expose
    private Schema projectedSchema;
    @Expose
    private Path path;

    public InsertNode(int pid) {
        super(pid, NodeType.INSERT);
    }

    public void setTargetTable(TableDesc desc) {
        this.setTableName(desc.getName());
        this.tableSchema = desc.hasPartition() ? desc.getLogicalSchema() : desc.getSchema();
        if (desc.getPath() != null) {
            this.setPath(new Path(desc.getPath()));
        }
        this.setOptions(desc.getMeta().getOptions());
        this.setStorageType(desc.getMeta().getStoreType());
        if (desc.hasPartition()) {
            this.setPartitionMethod(desc.getPartitionMethod());
        }
    }

    public void setTargetLocation(Path path) {
        this.path = path;
    }

    public void setSubQuery(LogicalNode subQuery) {
        this.setChild(subQuery);
        this.setInSchema(subQuery.getOutSchema());
        this.setOutSchema(subQuery.getOutSchema());
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public Schema getTableSchema() {
        return this.tableSchema;
    }

    public void setTableSchema(Schema tableSchema) {
        this.tableSchema = tableSchema;
    }

    public boolean hasTargetSchema() {
        return this.targetSchema != null;
    }

    public Schema getTargetSchema() {
        return this.targetSchema;
    }

    public void setTargetSchema(Schema schema) {
        this.targetSchema = schema;
    }

    public boolean hasProjectedSchema() {
        return this.projectedSchema != null;
    }

    public Schema getProjectedSchema() {
        return this.projectedSchema;
    }

    public void setProjectedSchema(Schema projected) {
        this.projectedSchema = projected;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean hasStorageType() {
        return this.storageType != null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof InsertNode) {
            InsertNode other = (InsertNode)obj;
            boolean eq = super.equals(other);
            eq &= this.overwrite == other.overwrite;
            eq &= TUtil.checkEquals((Object)this.tableSchema, (Object)other.tableSchema);
            eq &= TUtil.checkEquals((Object)this.targetSchema, (Object)other.targetSchema);
            return eq &= TUtil.checkEquals((Object)this.path, (Object)other.path);
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        InsertNode insertNode = (InsertNode)super.clone();
        insertNode.overwrite = this.overwrite;
        insertNode.tableSchema = new Schema(this.tableSchema);
        insertNode.targetSchema = this.targetSchema != null ? new Schema(this.targetSchema) : null;
        insertNode.path = this.path != null ? new Path(this.path.toString()) : null;
        return insertNode;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Insert (overwrite=").append(this.overwrite);
        if (this.hasTargetTable()) {
            sb.append(",table=").append(this.tableName);
        }
        if (this.hasPath()) {
            sb.append(", location=").append(this.path);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void preOrder(LogicalNodeVisitor visitor) {
        ((LogicalNode)this.getChild()).preOrder(visitor);
        visitor.visit(this);
    }

    @Override
    public void postOrder(LogicalNodeVisitor visitor) {
        visitor.visit(this);
        ((LogicalNode)this.getChild()).postOrder(visitor);
    }

    @Override
    public PlanString getPlanString() {
        PlanString planString = new PlanString(this);
        planString.appendTitle(" INTO ");
        if (this.hasTargetTable()) {
            planString.appendTitle(this.getTableName());
            if (this.hasTargetSchema()) {
                planString.addExplan(this.getTargetSchema().toString());
            }
        } else {
            planString.addExplan("LOCATION " + this.path);
        }
        return planString;
    }
}

