/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.List;
import org.apache.tajo.algebra.JoinType;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.logical.BinaryNode;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.Projectable;
import org.apache.tajo.plan.util.PlannerUtil;
import org.apache.tajo.util.TUtil;

public class JoinNode
extends BinaryNode
implements Projectable,
Cloneable {
    @Expose
    private JoinType joinType;
    @Expose
    private EvalNode joinQual;
    @Expose
    private Target[] targets;
    private boolean candidateBroadcast = false;
    private List<LogicalNode> broadcastCandidateTargets = new ArrayList<LogicalNode>();

    public JoinNode(int pid) {
        super(pid, NodeType.JOIN);
    }

    public void init(JoinType joinType, LogicalNode left, LogicalNode right) {
        this.joinType = joinType;
        this.setLeftChild(left);
        this.setRightChild(right);
    }

    public boolean isCandidateBroadcast() {
        return this.candidateBroadcast;
    }

    public void setCandidateBroadcast(boolean candidateBroadcast) {
        this.candidateBroadcast = candidateBroadcast;
    }

    public List<LogicalNode> getBroadcastCandidateTargets() {
        return this.broadcastCandidateTargets;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public void setJoinType(JoinType joinType) {
        this.joinType = joinType;
    }

    public void setJoinQual(EvalNode joinQual) {
        this.joinQual = joinQual;
    }

    public boolean hasJoinQual() {
        return this.joinQual != null;
    }

    public EvalNode getJoinQual() {
        return this.joinQual;
    }

    @Override
    public boolean hasTargets() {
        return this.targets != null;
    }

    @Override
    public Target[] getTargets() {
        return this.targets;
    }

    @Override
    public void setTargets(Target[] targets) {
        this.targets = targets;
        this.setOutSchema(PlannerUtil.targetToSchema(targets));
    }

    @Override
    public PlanString getPlanString() {
        PlanString planStr = new PlanString(this).appendTitle("(").appendTitle(this.joinType.name()).appendTitle(")");
        if (this.hasJoinQual()) {
            planStr.addExplan("Join Cond: " + this.joinQual.toString());
        }
        if (this.hasTargets()) {
            planStr.addExplan("target list: ");
            boolean first = true;
            for (Target target : this.targets) {
                if (!first) {
                    planStr.appendExplain(", ");
                }
                planStr.appendExplain(target.toString());
                first = false;
            }
        }
        planStr.addDetail("out schema: " + this.getOutSchema());
        planStr.addDetail("in schema: " + this.getInSchema());
        return planStr;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof JoinNode) {
            JoinNode other = (JoinNode)obj;
            boolean eq = this.joinType.equals((Object)other.joinType);
            eq &= TUtil.checkEquals((Object[])this.targets, (Object[])other.targets);
            return (eq &= TUtil.checkEquals((Object)this.joinQual, (Object)other.joinQual)) && this.leftChild.equals(other.leftChild) && this.rightChild.equals(other.rightChild);
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        JoinNode join = (JoinNode)super.clone();
        join.joinType = this.joinType;
        EvalNode evalNode = join.joinQual = this.joinQual == null ? null : (BinaryEval)this.joinQual.clone();
        if (this.hasTargets()) {
            join.targets = new Target[this.targets.length];
            for (int i = 0; i < this.targets.length; ++i) {
                join.targets[i] = (Target)this.targets[i].clone();
            }
        }
        return join;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Join (type").append(this.joinType);
        if (this.hasJoinQual()) {
            sb.append(",filter=").append(this.joinQual);
        }
        sb.append(")");
        return sb.toString();
    }
}

