/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.gson.annotations.Expose;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.UnaryNode;

public final class LimitNode
extends UnaryNode
implements Cloneable {
    @Expose
    private long fetchFirstNum;

    public LimitNode(int pid) {
        super(pid, NodeType.LIMIT);
    }

    public void setFetchFirst(long num) {
        this.fetchFirstNum = num;
    }

    public long getFetchFirstNum() {
        return this.fetchFirstNum;
    }

    @Override
    public PlanString getPlanString() {
        return new PlanString(this).appendTitle(" " + this.fetchFirstNum);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LimitNode) {
            LimitNode other = (LimitNode)obj;
            return super.equals(other) && this.fetchFirstNum == other.fetchFirstNum;
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        LimitNode newLimitNode = (LimitNode)super.clone();
        newLimitNode.fetchFirstNum = this.fetchFirstNum;
        return newLimitNode;
    }

    @Override
    public String toString() {
        return "Limit (fetch first=" + this.fetchFirstNum + ")";
    }
}

